/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.SaxAlert;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.XmlEventHandler;
import com.google.gxp.compiler.parser.XmlParser;
import com.google.gxp.org.apache.xerces.parsers.SAXParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SaxXmlParser
implements XmlParser {
    public static final XmlParser INSTANCE = new SaxXmlParser();

    private SaxXmlParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(FileRef input, XmlEventHandler eventHandler) throws IOException {
        InputStream inputStream = input.openInputStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            SaxEventAdapter saxEventAdapter = new SaxEventAdapter(input, eventHandler);
            try {
                SAXParser xmlReader = new SAXParser();
                xmlReader.setContentHandler(saxEventAdapter);
                xmlReader.setDTDHandler(saxEventAdapter);
                xmlReader.setEntityResolver(saxEventAdapter);
                xmlReader.setErrorHandler(saxEventAdapter);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                xmlReader.parse(inputSource);
            }
            catch (SAXException saxException) {
                if (!saxEventAdapter.getExceptionMessages().contains(saxException.getMessage())) {
                    eventHandler.add(new SaxAlert(new SourcePosition(input), Alert.Severity.ERROR, saxException));
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static class SaxEventAdapter
    implements ContentHandler,
    DTDHandler,
    EntityResolver,
    ErrorHandler {
        private final FileRef input;
        private final XmlEventHandler eventHandler;
        private Locator saxLocator = null;
        private boolean started = false;
        private boolean ended = false;
        private final Set<String> exceptionMessages = Sets.newHashSet();
        private int lineNumber = 0;
        private int columnNumber = 0;

        SaxEventAdapter(FileRef input, XmlEventHandler eventHandler) {
            this.input = Preconditions.checkNotNull(input);
            this.eventHandler = Preconditions.checkNotNull(eventHandler);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.saxLocator = locator;
            this.recordPosition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startDocument() throws SAXException {
            try {
                if (this.started) {
                    throw new AssertionError((Object)"startDocument called multiple times?!");
                }
                this.started = true;
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endDocument() throws SAXException {
            try {
                if (!this.started) {
                    throw new AssertionError((Object)"endDocument without startDocument?!");
                }
                if (this.ended) {
                    throw new AssertionError((Object)"endDocument called multiple times?!");
                }
                this.ended = true;
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            try {
                this.eventHandler.startPrefixMapping(this.getSourcePosition(), prefix, uri);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            try {
                this.eventHandler.endPrefixMapping(this.getSourcePosition(), prefix);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String nsUri, String localName, String qName, Attributes saxAttrs) throws SAXException {
            try {
                int attrCount = saxAttrs.getLength();
                ArrayList<ParsedAttribute> attrs = Lists.newArrayListWithExpectedSize(attrCount);
                for (int i = 0; i < attrCount; ++i) {
                    ParsedAttribute attr = this.parseAttribute(this.getSourcePosition(), saxAttrs, i);
                    if (attr == null) continue;
                    attrs.add(attr);
                }
                this.eventHandler.startElement(this.getSourcePosition(), nsUri, localName, qName, attrs);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String nsUri, String localName, String qName) throws SAXException {
            try {
                this.eventHandler.endElement(this.getSourcePosition(), nsUri, localName, qName);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.eventHandler.characters(this.getSourcePosition(), ch, start, length);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            try {
                this.eventHandler.characters(this.getSourcePosition(), ch, start, length);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            try {
                this.eventHandler.processingInstruction(this.getSourcePosition(), target, data);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skippedEntity(String name) throws SAXException {
            try {
                this.eventHandler.skippedEntity(this.getSourcePosition(), name);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            try {
                this.eventHandler.notationDecl(this.getSourcePosition(), name, publicId, systemId);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            try {
                this.eventHandler.unparsedEntityDecl(this.getSourcePosition(), name, publicId, systemId, notationName);
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            try {
                InputStream stream = this.eventHandler.resolveEntity(this.getSourcePosition(), publicId, systemId);
                InputSource result = new InputSource(stream);
                result.setPublicId(publicId);
                result.setSystemId(systemId);
                InputSource inputSource = result;
                return inputSource;
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void warning(SAXParseException exception) throws SAXException {
            try {
                this.eventHandler.add(new SaxAlert(this.getSourcePosition(), Alert.Severity.WARNING, exception));
                this.exceptionMessages.add(exception.getMessage());
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void error(SAXParseException exception) throws SAXException {
            try {
                this.eventHandler.add(new SaxAlert(this.getSourcePosition(), Alert.Severity.ERROR, exception));
                this.exceptionMessages.add(exception.getMessage());
            }
            finally {
                this.recordPosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            try {
                this.eventHandler.add(new SaxAlert(this.getSourcePosition(), Alert.Severity.ERROR, exception));
                this.exceptionMessages.add(exception.getMessage());
            }
            finally {
                this.recordPosition();
            }
        }

        public Set<String> getExceptionMessages() {
            return Collections.unmodifiableSet(this.exceptionMessages);
        }

        private void recordPosition() {
            this.lineNumber = 0;
            this.columnNumber = 0;
            if (this.saxLocator != null) {
                this.lineNumber = this.saxLocator.getLineNumber();
                this.columnNumber = this.saxLocator.getColumnNumber();
            }
        }

        private SourcePosition getSourcePosition() {
            if (this.lineNumber > 0 && this.columnNumber > 0) {
                return new SourcePosition(this.input, this.lineNumber, this.columnNumber);
            }
            return new SourcePosition(this.input);
        }

        private ParsedAttribute parseAttribute(SourcePosition sourcePosition, Attributes saxAttrs, int i) {
            String attrQName;
            String attrName = saxAttrs.getLocalName(i);
            String attrValue = saxAttrs.getValue(i);
            if (attrName.equals("")) {
                return null;
            }
            String attrNamespaceUri = saxAttrs.getURI(i);
            if ("".equals(attrNamespaceUri)) {
                attrNamespaceUri = null;
                attrQName = attrName;
            } else {
                attrQName = saxAttrs.getQName(i);
            }
            return this.eventHandler.parseAttribute(sourcePosition, attrNamespaceUri, attrName, attrValue, attrQName);
        }
    }
}

