/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Node;
import java.io.Serializable;

public class SerializableAbstractNode
implements Node,
Serializable {
    private final SourcePosition sourcePosition;
    private final String displayName;

    protected SerializableAbstractNode(SourcePosition sourcePosition, String displayName) {
        this.sourcePosition = Preconditions.checkNotNull(sourcePosition);
        this.displayName = Preconditions.checkNotNull(displayName);
    }

    protected SerializableAbstractNode(Node fromNode) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName());
    }

    @Override
    public SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    protected final boolean equalsAbstractNode(SerializableAbstractNode that) {
        return Objects.equal(this.getSourcePosition(), that.getSourcePosition()) && Objects.equal(this.getDisplayName(), that.getDisplayName());
    }

    protected final int abstractNodeHashCode() {
        return Objects.hashCode(this.getSourcePosition(), this.getDisplayName());
    }
}

