/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Verify the OSGI-INF xml files generated by the bnd plugin based
// on our annotations
import groovy.xml.XmlSlurper
def INVALID_CONFIG = 'Configuration is invalid'

// Utility functions
def getXml(filename) {
    return new XmlSlurper().parse(new File(basedir, "target/classes/OSGI-INF/" + filename))
}

def assertTypedAttribute(xml, name, type, value) {
    def errorMsg = name + " " + type + " attribute does not match " + value
    assert(xml.property.find{ it.@name == name && it.@type == type && it.@value == value }) : errorMsg
}

def assertProperty(xml, name, type, String [] expected) {
    def linesFromXml = xml.property.find{ it.@name == name && it.@type == type }.toString().split('\n')
    expected.each {
        def errorMsg = name + " " + type + " does not contain " + it
        assert(linesFromXml.contains(it)) : errorMsg
    }
    assert(linesFromXml.length == expected.length)
}

def assertNoProperty(xml, String [] names) {
    names.each {
        def name = it
        xml.property.find{ it.@name == name }.each {
            assert(false) : "did not expect " + it + " for " + name
        }
    }
}

// The actual tests
{
    def xml=getXml("org.apache.sling.resource.observation.annotations.SampleResourceChangeListener.xml")
    assertProperty(xml, 'resource.paths', 'String', '/examplepath')
    assertProperty(xml, 'resource.change.types', 'String', 'ADDED', 'REMOVED')
    assertNoProperty(xml,
        'resource.property.names.hint',
    )
}

return true
