/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Attributes {
    private Attributes() {
    }

    public static Map<String, ?> properties(Properties properties) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(2 * properties.size());
        try {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                attributes.put(key, properties.getProperty(key));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property map contains non-String key", e);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            attributes.put(entry.getKey().toString(), entry.getValue());
        }
        return Collections.unmodifiableMap(attributes);
    }

    public static Map<String, ?> names(String ... names) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(2 * names.length);
        for (String n : names) {
            try {
                for (Rdn rdn : new LdapName(n).getRdns()) {
                    attributes.put(rdn.getType(), rdn.getValue());
                }
            }
            catch (InvalidNameException e) {
                throw new IllegalArgumentException("Bad LDAP name: " + n, e);
            }
        }
        return Collections.unmodifiableMap(attributes);
    }

    public static Map<String, ?> objectClass(Class<?> ... interfaces) {
        String[] objectClass = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            objectClass[i] = interfaces[i].getName();
        }
        return Collections.singletonMap("objectClass", objectClass);
    }

    public static Map<String, ?> union(Map ... attributes) {
        HashMap unionMap = new HashMap();
        for (Map a : attributes) {
            if (null == a) continue;
            unionMap.putAll(a);
        }
        return Collections.unmodifiableMap(unionMap);
    }
}

