/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.schema.SchemaPropertiesKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.schema.SchemaTitleRequiredValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.SchemaValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.SchemaValidatorFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultSchemaValidatorFactory
implements SchemaValidatorFactory {
    public List<SchemaValidator> create(FactoryOptions options) {
        ArrayList<SchemaValidator> validators = new ArrayList<SchemaValidator>();
        this.addSchemaTitleRequiredValidator(validators, options);
        this.addSchemaPropertiesKeysCaseValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addSchemaTitleRequiredValidator(List<SchemaValidator> validators, FactoryOptions options) {
        Boolean required = options.getBoolean("schema.title.required");
        if (Boolean.TRUE.equals(required)) {
            validators.add((SchemaValidator)new SchemaTitleRequiredValidator());
        }
    }

    private void addSchemaPropertiesKeysCaseValidator(List<SchemaValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("schema.properties.key.case");
        if (expectedCase != null) {
            validators.add((SchemaValidator)new SchemaPropertiesKeysCaseValidator(expectedCase));
        }
    }
}

