/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.operation.OperationIdCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.operation.OperationServersSizeEqValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.operation.OperationSummaryRequiredValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.operation.OperationTagsReferenceValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.operation.OperationTagsSizeEqValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.OperationValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.OperationValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ParameterValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.RequestBodyValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ResponsesValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.operation.OperationParametersValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.operation.OperationRequestBodyValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.operation.OperationResponsesValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultOperationValidatorFactory
implements OperationValidatorFactory {
    private final ParameterValidatorFactory parameterValidatorFactory;
    private final ResponsesValidatorFactory responsesValidatorFactory;
    private final RequestBodyValidatorFactory requestBodyValidatorFactory;

    public DefaultOperationValidatorFactory(ParameterValidatorFactory parameterValidatorFactory, ResponsesValidatorFactory responsesValidatorFactory, RequestBodyValidatorFactory requestBodyValidatorFactory) {
        this.parameterValidatorFactory = parameterValidatorFactory;
        this.responsesValidatorFactory = responsesValidatorFactory;
        this.requestBodyValidatorFactory = requestBodyValidatorFactory;
    }

    public List<OperationValidator> create(FactoryOptions options) {
        ArrayList<OperationValidator> validators = new ArrayList<OperationValidator>();
        validators.add((OperationValidator)new OperationParametersValidator(this.parameterValidatorFactory.create(options)));
        validators.add((OperationValidator)new OperationResponsesValidator(this.responsesValidatorFactory.create(options)));
        validators.add((OperationValidator)new OperationRequestBodyValidator(this.requestBodyValidatorFactory.create(options)));
        this.addOperationSummaryRequiredValidator(validators, options);
        this.addOperationIdCaseValidator(validators, options);
        this.addOperationTagsSizeEqValidator(validators, options);
        this.addOperationServersSizeEqValidator(validators, options);
        this.addOperationTagsReferenceValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addOperationSummaryRequiredValidator(List<OperationValidator> validators, FactoryOptions options) {
        Boolean required = options.getBoolean("operation.summary.required");
        if (Boolean.TRUE.equals(required)) {
            validators.add(new OperationSummaryRequiredValidator());
        }
    }

    private void addOperationIdCaseValidator(List<OperationValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("operation.operationId.case");
        if (expectedCase != null) {
            validators.add(new OperationIdCaseValidator(expectedCase));
        }
    }

    private void addOperationTagsSizeEqValidator(List<OperationValidator> validators, FactoryOptions options) {
        Integer expectedSize = options.getInteger("operation.tags.size.eq");
        if (expectedSize != null) {
            validators.add(new OperationTagsSizeEqValidator(expectedSize));
        }
    }

    private void addOperationServersSizeEqValidator(List<OperationValidator> validators, FactoryOptions options) {
        Integer expectedSize = options.getInteger("operations.servers.size.eq");
        if (expectedSize != null) {
            validators.add(new OperationServersSizeEqValidator(expectedSize));
        }
    }

    private void addOperationTagsReferenceValidator(List<OperationValidator> validators, FactoryOptions options) {
        Boolean needCheck = options.getBoolean("operation.tags.element.must_reference_root_tags");
        if (Boolean.TRUE.equals(needCheck)) {
            validators.add(new OperationTagsReferenceValidator());
        }
    }
}

