/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.threetenbp.ser.ThreeTenFormattedSerializerBase;
import java.io.IOException;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class LocalTimeSerializer
extends ThreeTenFormattedSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    protected LocalTimeSerializer() {
        this((DateTimeFormatter)null);
    }

    public LocalTimeSerializer(DateTimeFormatter formatter) {
        super(LocalTime.class, formatter);
    }

    protected LocalTimeSerializer(LocalTimeSerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
        super(base, useTimestamp, formatter);
    }

    @Override
    protected ThreeTenFormattedSerializerBase<LocalTime> withFormat(Boolean useTimestamp, DateTimeFormatter dtf) {
        return new LocalTimeSerializer(this, useTimestamp, dtf);
    }

    public void serialize(LocalTime time, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            generator.writeStartArray();
            generator.writeNumber(time.getHour());
            generator.writeNumber(time.getMinute());
            if (time.getSecond() > 0 || time.getNano() > 0) {
                generator.writeNumber(time.getSecond());
                if (time.getNano() > 0) {
                    if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        generator.writeNumber(time.getNano());
                    } else {
                        generator.writeNumber(time.get((TemporalField)ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            generator.writeEndArray();
        } else {
            String str = this._formatter == null ? time.toString() : time.format(this._formatter);
            generator.writeString(str);
        }
    }
}

