/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderProcessorCreator
implements ParamValueProcessorCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderProcessorCreator.class);
    public static final String PARAMTYPE = "header";

    public HeaderProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = TypeFactory.defaultInstance().constructType(genericParamType);
        return new HeaderProcessor(parameter.getName(), targetType, ((HeaderParameter)parameter).getDefaultValue(), parameter.getRequired());
    }

    public static class HeaderProcessor
    extends AbstractParamProcessor {
        private boolean ignoreRequiredCheck = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.header.ignoreRequiredCheck", false).get();

        public HeaderProcessor(String paramPath, JavaType targetType, Object defaultValue, boolean required) {
            super(paramPath, targetType, defaultValue, required);
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            Object value = null;
            if (this.targetType.isContainerType()) {
                Enumeration headerValues = request.getHeaders(this.paramPath);
                if (headerValues == null) {
                    return null;
                }
                value = Collections.list(headerValues);
            } else {
                value = request.getHeader(this.paramPath);
                if (value == null) {
                    value = this.checkRequiredAndDefaultValue();
                }
            }
            return this.convertValue(value, this.targetType);
        }

        private Object checkRequiredAndDefaultValue() {
            if (!this.ignoreRequiredCheck && this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            return this.getDefaultValue();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            if (null == arg) {
                LOGGER.debug("Header arg is null, will not be set into clientRequest. paramPath = [{}]", (Object)this.paramPath);
                return;
            }
            clientRequest.putHeader(this.paramPath, RestObjectMapperFactory.getConsumerWriterMapper().convertToString(arg));
        }

        @Override
        public String getProcessorType() {
            return HeaderProcessorCreator.PARAMTYPE;
        }
    }
}

