/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.AssertJProxySetup;
import org.assertj.core.api.ClassLoadingStrategyFactory;
import org.assertj.core.api.ErrorCollector;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.ProxifyMethodChangingTheObjectUnderTest;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.TypeCache;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.modifier.Visibility;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.core.internal.bytebuddy.implementation.FieldAccessor;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.MethodDelegation;
import org.assertj.core.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;

class SoftProxies {
    private static final ElementMatcher.Junction<MethodDescription> METHODS_CHANGING_THE_OBJECT_UNDER_TEST = SoftProxies.methodsNamed("extracting").or(ElementMatchers.named("filteredOn")).or(ElementMatchers.named("filteredOnNull")).or(ElementMatchers.named("filteredOnAssertions")).or(ElementMatchers.named("map")).or(ElementMatchers.named("asString")).or(ElementMatchers.named("asList")).or(ElementMatchers.named("size")).or(ElementMatchers.named("toAssert")).or(ElementMatchers.named("flatMap")).or(ElementMatchers.named("extractingResultOf")).or(ElementMatchers.named("flatExtracting"));
    private static final ElementMatcher.Junction<MethodDescription> METHODS_NOT_TO_PROXY = SoftProxies.methodsNamed("as").or(ElementMatchers.named("clone")).or(ElementMatchers.named("describedAs")).or(ElementMatchers.named("descriptionText")).or(ElementMatchers.named("getWritableAssertionInfo")).or(ElementMatchers.named("inBinary")).or(ElementMatchers.named("inHexadecimal")).or(ElementMatchers.named("newAbstractIterableAssert")).or(ElementMatchers.named("newObjectArrayAssert")).or(ElementMatchers.named("removeCustomAssertRelatedElementsFromStackTraceIfNeeded")).or(ElementMatchers.named("overridingErrorMessage")).or(ElementMatchers.named("usingDefaultComparator")).or(ElementMatchers.named("usingElementComparator")).or(ElementMatchers.named("withComparatorsForElementPropertyOrFieldNames")).or(ElementMatchers.named("withComparatorsForElementPropertyOrFieldTypes")).or(ElementMatchers.named("withIterables")).or(ElementMatchers.named("withFailMessage")).or(ElementMatchers.named("withAssertionInfo")).or(ElementMatchers.named("withAssertionState")).or(ElementMatchers.named("withRepresentation")).or(ElementMatchers.named("withTypeComparators")).or(ElementMatchers.named("withThreadDumpOnError"));
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy().with(new AuxiliaryType.NamingStrategy.SuffixingRandom("AssertJ$SoftProxies")).with(TypeValidation.DISABLED);
    private static final Implementation PROXIFY_METHOD_CHANGING_THE_OBJECT_UNDER_TEST = MethodDelegation.to(ProxifyMethodChangingTheObjectUnderTest.class);
    private static final Implementation ERROR_COLLECTOR = MethodDelegation.to(ErrorCollector.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction<TypeCache.SimpleKey>(TypeCache.Sort.SOFT);
    private final ErrorCollector collector = new ErrorCollector();

    SoftProxies() {
    }

    public boolean wasSuccess() {
        return this.collector.wasSuccess();
    }

    void collectError(Throwable error) {
        this.collector.addError(error);
    }

    List<Throwable> errorsCollected() {
        return this.collector.errors();
    }

    <V, T> V createSoftAssertionProxy(Class<V> assertClass, Class<T> actualClass, T actual) {
        try {
            Class<V> proxyClass = SoftProxies.createSoftAssertionProxyClass(assertClass);
            Constructor<V> constructor = proxyClass.getConstructor(actualClass);
            V proxiedAssert = constructor.newInstance(actual);
            ((AssertJProxySetup)proxiedAssert).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <V> Class<? extends V> createSoftAssertionProxyClass(Class<V> assertClass) {
        TypeCache.SimpleKey cacheKey = new TypeCache.SimpleKey(assertClass, new Class[0]);
        return CACHE.findOrInsert(SoftProxies.class.getClassLoader(), cacheKey, () -> SoftProxies.generateProxyClass(assertClass));
    }

    IterableSizeAssert<?> createIterableSizeAssertProxy(IterableSizeAssert<?> iterableSizeAssert) {
        Class<IterableSizeAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(IterableSizeAssert.class);
        try {
            Constructor<IterableSizeAssert> constructor = proxyClass.getConstructor(AbstractIterableAssert.class, Integer.class);
            IterableSizeAssert proxiedAssert = constructor.newInstance(iterableSizeAssert.returnToIterable(), iterableSizeAssert.actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    MapSizeAssert<?, ?> createMapSizeAssertProxy(MapSizeAssert<?, ?> mapSizeAssert) {
        Class<MapSizeAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(MapSizeAssert.class);
        try {
            Constructor<MapSizeAssert> constructor = proxyClass.getConstructor(AbstractMapAssert.class, Integer.class);
            MapSizeAssert proxiedAssert = constructor.newInstance(mapSizeAssert.returnToMap(), mapSizeAssert.actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static <V> Class<? extends V> generateProxyClass(Class<V> assertClass) {
        return BYTE_BUDDY.subclass(assertClass).defineField("dispatcher", (Type)((Object)ProxifyMethodChangingTheObjectUnderTest.class), Visibility.PRIVATE).method(METHODS_CHANGING_THE_OBJECT_UNDER_TEST).intercept(PROXIFY_METHOD_CHANGING_THE_OBJECT_UNDER_TEST).defineField("errorCollector", (Type)((Object)ErrorCollector.class), Visibility.PRIVATE).method(ElementMatchers.any().and(ElementMatchers.not(METHODS_CHANGING_THE_OBJECT_UNDER_TEST)).and(ElementMatchers.not(METHODS_NOT_TO_PROXY))).intercept(ERROR_COLLECTOR).implement(new Type[]{AssertJProxySetup.class}).intercept(FieldAccessor.ofField("dispatcher").setsArgumentAt(0).andThen(FieldAccessor.ofField("errorCollector").setsArgumentAt(1))).make().load(assertClass.getClassLoader(), ClassLoadingStrategyFactory.classLoadingStrategy(assertClass)).getLoaded();
    }

    private static ElementMatcher.Junction<MethodDescription> methodsNamed(String name) {
        return ElementMatchers.named(name);
    }
}

