/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FactoryOptions {
    private final Map<String, String> options;

    public FactoryOptions(Map<String, String> options) {
        this.options = Collections.unmodifiableMap(new HashMap<String, String>(options));
    }

    public FactoryOptions(Properties properties) {
        HashMap<String, String> options = new HashMap<String, String>();
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            options.put((String)key, (String)properties.get(key));
        }
        this.options = Collections.unmodifiableMap(options);
    }

    public String getString(String key) {
        String value = this.options.get(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        String value = this.options.get(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public Integer getInteger(String key) {
        String value = this.options.get(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }
}

