/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.ReactiveResponseExecutor;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.SyncResponseExecutor;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvokerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokerUtils.class);

    public static Object syncInvoke(String microserviceName, String schemaId, String operationName, Object[] args) {
        ReferenceConfig referenceConfig = SCBEngine.getInstance().getReferenceConfigForInvoke(microserviceName);
        return InvokerUtils.syncInvoke(InvokerUtils.generateInvocation(schemaId, operationName, args, referenceConfig));
    }

    public static Object syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationName, Object[] args) {
        ReferenceConfig referenceConfig = SCBEngine.getInstance().createReferenceConfigForInvoke(microserviceName, microserviceVersion, transport);
        return InvokerUtils.syncInvoke(InvokerUtils.generateInvocation(schemaId, operationName, args, referenceConfig));
    }

    public static Object syncInvoke(Invocation invocation) throws InvocationException {
        Response response = InvokerUtils.innerSyncInvoke(invocation);
        if (response.isSuccessed()) {
            return response.getResult();
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    public static Response innerSyncInvoke(Invocation invocation) {
        try {
            invocation.onStart(null, System.nanoTime());
            SyncResponseExecutor respExecutor = new SyncResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.getInvocationStageTrace().startHandlersRequest();
            invocation.next(respExecutor::setResponse);
            Response response = respExecutor.waitResponse();
            invocation.getInvocationStageTrace().finishHandlersResponse();
            invocation.onFinish(response);
            return response;
        }
        catch (Throwable e) {
            String msg = String.format("invoke failed, %s", invocation.getOperationMeta().getMicroserviceQualifiedName());
            LOGGER.error(msg, e);
            Response response = Response.createConsumerFail((Throwable)e);
            invocation.onFinish(response);
            return response;
        }
    }

    public static void reactiveInvoke(Invocation invocation, AsyncResponse asyncResp) {
        try {
            invocation.onStart(null, System.nanoTime());
            invocation.setSync(false);
            ReactiveResponseExecutor respExecutor = new ReactiveResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.getInvocationStageTrace().startHandlersRequest();
            invocation.next(ar -> {
                ContextUtils.setInvocationContext((InvocationContext)invocation.getParentContext());
                try {
                    invocation.getInvocationStageTrace().finishHandlersResponse();
                    invocation.onFinish(ar);
                    asyncResp.handle(ar);
                }
                finally {
                    ContextUtils.removeInvocationContext();
                }
            });
        }
        catch (Throwable e) {
            invocation.getInvocationStageTrace().finishHandlersResponse();
            Response response = Response.createConsumerFail((Throwable)e);
            invocation.onFinish(response);
            LOGGER.error("invoke failed, {}", (Object)invocation.getOperationMeta().getMicroserviceQualifiedName());
            asyncResp.handle(response);
        }
    }

    private static Invocation generateInvocation(String schemaId, String operationName, Object[] args, ReferenceConfig referenceConfig) {
        SchemaMeta schemaMeta = referenceConfig.getMicroserviceMeta().ensureFindSchemaMeta(schemaId);
        return InvocationFactory.forConsumer(referenceConfig, schemaMeta, operationName, args);
    }

    @Deprecated
    public static Object invoke(Invocation invocation) {
        return InvokerUtils.syncInvoke(invocation);
    }
}

