/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.executor.LinkedBlockingQueueEx;

public class ThreadPoolExecutorEx
extends ThreadPoolExecutor {
    private AtomicInteger submittedCount = new AtomicInteger();
    private AtomicInteger finishedCount = new AtomicInteger();
    private AtomicInteger rejectedCount = new AtomicInteger();

    public ThreadPoolExecutorEx(int coreThreads, int maxThreads, int maxIdleInSecond, TimeUnit timeUnit, BlockingQueue<Runnable> queue) {
        super(coreThreads, maxThreads, maxIdleInSecond, timeUnit, queue);
        if (queue instanceof LinkedBlockingQueueEx) {
            ((LinkedBlockingQueueEx)queue).setOwner(this);
        }
        this.setRejectedExecutionHandler(this::rejectedExecution);
    }

    @Override
    public void execute(Runnable command) {
        this.submittedCount.incrementAndGet();
        super.execute(command);
    }

    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        this.rejectedCount.incrementAndGet();
        this.finishedCount.incrementAndGet();
        throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.finishedCount.incrementAndGet();
    }

    public int getNotFinished() {
        return this.submittedCount.get() - this.finishedCount.get();
    }

    public int getRejectedCount() {
        return this.rejectedCount.get();
    }
}

