/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.event.InvocationBusinessMethodFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodStartEvent;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.tracing.ScbMarker;
import org.apache.servicecomb.core.tracing.TraceIdGenerator;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;

public class Invocation
extends SwaggerInvocation {
    private static final Collection<TraceIdGenerator> TRACE_ID_GENERATORS = Invocation.loadTraceIdGenerators();
    protected static final AtomicLong INVOCATION_ID = new AtomicLong();
    private ReferenceConfig referenceConfig;
    private SchemaMeta schemaMeta;
    private OperationMeta operationMeta;
    private Endpoint endpoint;
    private Map<String, Object> handlerContext;
    private List<Handler> handlerList;
    private int handlerIndex;
    private Executor responseExecutor;
    private boolean sync;
    private InvocationStageTrace invocationStageTrace;
    private HttpServletRequestEx requestEx;
    private boolean finished;
    private boolean edge;
    private long invocationId;

    static Collection<TraceIdGenerator> loadTraceIdGenerators() {
        return SPIServiceUtils.getPriorityHighestServices(generator -> generator.getName(), TraceIdGenerator.class);
    }

    public long getInvocationId() {
        return this.invocationId;
    }

    public HttpServletRequestEx getRequestEx() {
        return this.requestEx;
    }

    public InvocationStageTrace getInvocationStageTrace() {
        return this.invocationStageTrace;
    }

    public String getTraceId() {
        return this.getContext("X-B3-TraceId");
    }

    public String getTraceId(String traceIdName) {
        return this.getContext(traceIdName);
    }

    @Deprecated
    public long getStartTime() {
        return this.invocationStageTrace.getStart();
    }

    @Deprecated
    public long getStartExecutionTime() {
        return this.invocationStageTrace.getStartExecution();
    }

    public Invocation() {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationStageTrace = new InvocationStageTrace(this);
    }

    public Invocation(ReferenceConfig referenceConfig, OperationMeta operationMeta, Object[] swaggerArguments) {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationStageTrace = new InvocationStageTrace(this);
        this.invocationType = InvocationType.CONSUMER;
        this.referenceConfig = referenceConfig;
        this.init(operationMeta, swaggerArguments);
    }

    public Invocation(Endpoint endpoint, OperationMeta operationMeta, Object[] swaggerArguments) {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationStageTrace = new InvocationStageTrace(this);
        this.invocationType = InvocationType.PRODUCER;
        this.endpoint = endpoint;
        this.init(operationMeta, swaggerArguments);
    }

    private void init(OperationMeta operationMeta, Object[] swaggerArguments) {
        this.invocationId = INVOCATION_ID.getAndIncrement();
        this.schemaMeta = operationMeta.getSchemaMeta();
        this.operationMeta = operationMeta;
        this.swaggerArguments = swaggerArguments;
        this.handlerList = this.getHandlerChain();
        this.handlerIndex = 0;
    }

    public Transport getTransport() {
        if (this.endpoint == null) {
            throw new IllegalStateException("Endpoint is empty. Forget to configure \"loadbalance\" in consumer handler chain?");
        }
        return this.endpoint.getTransport();
    }

    public List<Handler> getHandlerChain() {
        return InvocationType.CONSUMER.equals((Object)this.invocationType) ? this.schemaMeta.getConsumerHandlerChain() : this.schemaMeta.getProviderHandlerChain();
    }

    public Executor getResponseExecutor() {
        return this.responseExecutor;
    }

    public void setResponseExecutor(Executor responseExecutor) {
        this.responseExecutor = responseExecutor;
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    public Object[] getArgs() {
        return this.swaggerArguments;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getHandlerContext() {
        return this.handlerContext;
    }

    public int getHandlerIndex() {
        return this.handlerIndex;
    }

    public void setHandlerIndex(int handlerIndex) {
        this.handlerIndex = handlerIndex;
    }

    public void next(AsyncResponse asyncResp) throws Exception {
        int runIndex = this.handlerIndex++;
        this.handlerList.get(runIndex).handle(this, asyncResp);
    }

    public String getSchemaId() {
        return this.schemaMeta.getSchemaId();
    }

    public String getOperationName() {
        return this.operationMeta.getOperationId();
    }

    public String getConfigTransportName() {
        if (this.operationMeta.getTransport() != null) {
            return this.operationMeta.getTransport();
        }
        return this.referenceConfig.getTransport();
    }

    public String getRealTransportName() {
        return this.endpoint != null ? this.endpoint.getTransport().getName() : this.getConfigTransportName();
    }

    public String getMicroserviceName() {
        return this.schemaMeta.getMicroserviceName();
    }

    public String getAppId() {
        return this.schemaMeta.getMicroserviceMeta().getAppId();
    }

    public String getMicroserviceVersionRule() {
        return this.referenceConfig.getVersionRule();
    }

    public String getInvocationQualifiedName() {
        return this.invocationType.name() + " " + this.getRealTransportName() + " " + this.getOperationMeta().getMicroserviceQualifiedName();
    }

    public String getMicroserviceQualifiedName() {
        return this.operationMeta.getMicroserviceQualifiedName();
    }

    protected void initTraceId() {
        for (TraceIdGenerator traceIdGenerator : TRACE_ID_GENERATORS) {
            this.initTraceId(traceIdGenerator);
        }
        this.marker = new ScbMarker(this);
    }

    protected void initTraceId(TraceIdGenerator traceIdGenerator) {
        if (!StringUtils.isEmpty((CharSequence)this.getTraceId(traceIdGenerator.getTraceIdKeyName()))) {
            return;
        }
        if (this.requestEx == null) {
            this.addContext(traceIdGenerator.getTraceIdKeyName(), traceIdGenerator.generate());
            return;
        }
        String traceId = this.requestEx.getHeader(traceIdGenerator.getTraceIdKeyName());
        if (!StringUtils.isEmpty((CharSequence)traceId)) {
            this.addContext(traceIdGenerator.getTraceIdKeyName(), traceId);
            return;
        }
        this.addContext(traceIdGenerator.getTraceIdKeyName(), traceIdGenerator.generate());
    }

    public void onStart(long start) {
        this.invocationStageTrace.start(start);
        this.initTraceId();
        EventManager.post((Object)new InvocationStartEvent(this));
    }

    public void onStart(HttpServletRequestEx requestEx, long start) {
        this.requestEx = requestEx;
        this.onStart(start);
    }

    public void onExecuteStart() {
        this.invocationStageTrace.startExecution();
    }

    public void onBusinessMethodStart() {
        this.invocationStageTrace.startBusinessMethod();
        EventManager.post((Object)new InvocationBusinessMethodStartEvent(this));
    }

    public void onBusinessMethodFinish() {
        EventManager.post((Object)new InvocationBusinessMethodFinishEvent(this));
    }

    public void onBusinessFinish() {
        this.invocationStageTrace.finishBusiness();
    }

    public void onFinish(Response response) {
        if (this.finished) {
            return;
        }
        this.invocationStageTrace.finish();
        EventManager.post((Object)new InvocationFinishEvent(this, response));
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isConsumer() {
        return InvocationType.CONSUMER.equals((Object)this.invocationType);
    }

    public boolean isEdge() {
        return this.edge;
    }

    public void setEdge(boolean edge) {
        this.edge = edge;
    }
}

