/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.context;

import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.generator.context.IExtensionsContext;
import org.apache.servicecomb.toolkit.generator.context.ISchemaContext;
import org.apache.servicecomb.toolkit.generator.context.OperationContext;
import org.apache.servicecomb.toolkit.generator.parser.api.OpenApiAnnotationParser;
import org.apache.servicecomb.toolkit.generator.util.ModelConverter;
import org.apache.servicecomb.toolkit.generator.util.ParamUtils;
import org.apache.servicecomb.toolkit.generator.util.RequestResponse;

public class ParameterContext
implements ISchemaContext,
IExtensionsContext {
    private static final Schema nullSchema = new Schema();
    private OperationContext parentContext;
    private java.lang.reflect.Parameter parameter;
    private Object defaultValue;
    private Parameter oasParameter = new Parameter();
    private String name = null;
    private InType in = null;
    private String description = null;
    private Boolean required = null;
    private Boolean deprecated = null;
    private Boolean allowEmptyValue = null;
    private ParameterStyle style;
    private Boolean explode = null;
    private Boolean allowReserved = null;
    private Schema schema;
    private Object example = null;
    private Map<String, Example> examples = null;
    private Content content = null;
    private String ref = null;
    private RequestBody requestBody;
    private List<String> consumes;

    public ParameterContext(OperationContext parentContext, java.lang.reflect.Parameter parameter) {
        this.parentContext = parentContext;
        this.parameter = parameter;
        parentContext.addParamCtx(this);
    }

    public Parameter toParameter() {
        if (this.parameter == null) {
            return null;
        }
        this.ensureName();
        if (this.schema == null || nullSchema.equals((Object)this.schema)) {
            this.schema = ModelConverter.getSchema(this.parameter.getType(), this.getComponents(), RequestResponse.REQUEST);
            this.oasParameter.schema(this.schema);
        }
        if (this.in == null) {
            this.oasParameter.setIn(ParameterIn.QUERY.toString());
        } else {
            switch (this.in) {
                case PATH: {
                    this.oasParameter.setIn(ParameterIn.PATH.toString());
                    break;
                }
                case QUERY: {
                    this.oasParameter.setIn(ParameterIn.QUERY.toString());
                    break;
                }
                case COOKIE: {
                    this.oasParameter.setIn(ParameterIn.COOKIE.toString());
                    break;
                }
                case HEADER: {
                    this.oasParameter.setIn(ParameterIn.HEADER.toString());
                    break;
                }
                default: {
                    this.oasParameter.setIn(ParameterIn.QUERY.toString());
                }
            }
        }
        if (this.defaultValue != null) {
            this.required = false;
            this.oasParameter.getSchema().setDefault(this.defaultValue);
        }
        this.oasParameter.setRequired(this.required);
        return this.oasParameter;
    }

    public boolean isRequestBody() {
        return this.in != null && (this.in.equals((Object)InType.BODY) || this.in.equals((Object)InType.FORM));
    }

    public void applyAnnotations(List<Annotation> annotations) {
        ParameterProcessor.applyAnnotations((Parameter)this.oasParameter, (Type)this.getType(), annotations, (Components)this.getComponents(), null, null, null);
    }

    private void ensureName() {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = ParamUtils.getParameterName(this.parentContext.getMethod(), this.parameter);
        }
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = this.parameter.getName();
        }
        this.oasParameter.setName(this.name);
    }

    public OperationContext getOperationContext() {
        return this.parentContext;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Components getComponents() {
        return this.parentContext.getComponents();
    }

    public Parameter getOasParameter() {
        return this.oasParameter;
    }

    public java.lang.reflect.Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(java.lang.reflect.Parameter parameter) {
        this.parameter = parameter;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Type getType() {
        if (this.getRealType() != null) {
            return this.getRealType();
        }
        if (StringUtils.isNotEmpty((CharSequence)this.oasParameter.getIn())) {
            return ReflectionUtils.typeFromString((String)this.oasParameter.getIn());
        }
        return null;
    }

    public void addConsume(String consume) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        this.consumes.add(consume);
    }

    public List<String> getConsumers() {
        return this.consumes;
    }

    public Type getRealType() {
        return this.parameter.getParameterizedType();
    }

    public void setRequestBody(RequestBody requestBody) {
        this.required = requestBody.getRequired();
        this.description = requestBody.getDescription();
        this.requestBody = requestBody;
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    @Override
    public Schema getSchema() {
        Schema refSchema = this.oasParameter.getSchema();
        if (refSchema == null || nullSchema.equals((Object)refSchema)) {
            refSchema = ModelConverter.getSchema(this.parameter.getType(), this.getComponents(), RequestResponse.REQUEST);
            this.oasParameter.schema(refSchema);
        }
        return refSchema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public void addExtension(String name, Object value) {
        this.oasParameter.addExtension(name, value);
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.oasParameter.getExtensions();
    }

    @Override
    public OpenApiAnnotationParser getParser() {
        return this.parentContext.getParser();
    }

    public String getName() {
        this.ensureName();
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InType getIn() {
        return this.in;
    }

    public void setIn(InType in) {
        this.in = in;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    public ParameterStyle getStyle() {
        return this.style;
    }

    public void setStyle(ParameterStyle style) {
        this.style = style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public void setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = examples;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public static enum InType {
        QUERY,
        PATH,
        HEADER,
        COOKIE,
        FORM,
        BODY;

    }
}

