/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PriorityMappingEntryType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 25222;
  }

  // Properties.
  protected final PascalString mappingUri;
  protected final PascalString priorityLabel;
  protected final short priorityValue_PCP;
  protected final long priorityValue_DSCP;

  public PriorityMappingEntryType(
      PascalString mappingUri,
      PascalString priorityLabel,
      short priorityValue_PCP,
      long priorityValue_DSCP) {
    super();
    this.mappingUri = mappingUri;
    this.priorityLabel = priorityLabel;
    this.priorityValue_PCP = priorityValue_PCP;
    this.priorityValue_DSCP = priorityValue_DSCP;
  }

  public PascalString getMappingUri() {
    return mappingUri;
  }

  public PascalString getPriorityLabel() {
    return priorityLabel;
  }

  public short getPriorityValue_PCP() {
    return priorityValue_PCP;
  }

  public long getPriorityValue_DSCP() {
    return priorityValue_DSCP;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PriorityMappingEntryType");

    // Simple Field (mappingUri)
    writeSimpleField("mappingUri", mappingUri, writeComplex(writeBuffer));

    // Simple Field (priorityLabel)
    writeSimpleField("priorityLabel", priorityLabel, writeComplex(writeBuffer));

    // Simple Field (priorityValue_PCP)
    writeSimpleField("priorityValue_PCP", priorityValue_PCP, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (priorityValue_DSCP)
    writeSimpleField("priorityValue_DSCP", priorityValue_DSCP, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("PriorityMappingEntryType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PriorityMappingEntryType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (mappingUri)
    lengthInBits += mappingUri.getLengthInBits();

    // Simple field (priorityLabel)
    lengthInBits += priorityLabel.getLengthInBits();

    // Simple field (priorityValue_PCP)
    lengthInBits += 8;

    // Simple field (priorityValue_DSCP)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("PriorityMappingEntryType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString mappingUri =
        readSimpleField(
            "mappingUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString priorityLabel =
        readSimpleField(
            "priorityLabel", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    short priorityValue_PCP =
        readSimpleField("priorityValue_PCP", readUnsignedShort(readBuffer, 8));

    long priorityValue_DSCP =
        readSimpleField("priorityValue_DSCP", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("PriorityMappingEntryType");
    // Create the instance
    return new PriorityMappingEntryTypeBuilderImpl(
        mappingUri, priorityLabel, priorityValue_PCP, priorityValue_DSCP);
  }

  public static class PriorityMappingEntryTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString mappingUri;
    private final PascalString priorityLabel;
    private final short priorityValue_PCP;
    private final long priorityValue_DSCP;

    public PriorityMappingEntryTypeBuilderImpl(
        PascalString mappingUri,
        PascalString priorityLabel,
        short priorityValue_PCP,
        long priorityValue_DSCP) {
      this.mappingUri = mappingUri;
      this.priorityLabel = priorityLabel;
      this.priorityValue_PCP = priorityValue_PCP;
      this.priorityValue_DSCP = priorityValue_DSCP;
    }

    public PriorityMappingEntryType build() {
      PriorityMappingEntryType priorityMappingEntryType =
          new PriorityMappingEntryType(
              mappingUri, priorityLabel, priorityValue_PCP, priorityValue_DSCP);
      return priorityMappingEntryType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PriorityMappingEntryType)) {
      return false;
    }
    PriorityMappingEntryType that = (PriorityMappingEntryType) o;
    return (getMappingUri() == that.getMappingUri())
        && (getPriorityLabel() == that.getPriorityLabel())
        && (getPriorityValue_PCP() == that.getPriorityValue_PCP())
        && (getPriorityValue_DSCP() == that.getPriorityValue_DSCP())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMappingUri(),
        getPriorityLabel(),
        getPriorityValue_PCP(),
        getPriorityValue_DSCP());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
