/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesAccessCredentialDisableReason is the corresponding interface of BACnetPropertyStatesAccessCredentialDisableReason
type BACnetPropertyStatesAccessCredentialDisableReason interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetAccessCredentialDisableReason returns AccessCredentialDisableReason (property field)
	GetAccessCredentialDisableReason() BACnetAccessCredentialDisableReasonTagged
	// IsBACnetPropertyStatesAccessCredentialDisableReason is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesAccessCredentialDisableReason()
	// CreateBuilder creates a BACnetPropertyStatesAccessCredentialDisableReasonBuilder
	CreateBACnetPropertyStatesAccessCredentialDisableReasonBuilder() BACnetPropertyStatesAccessCredentialDisableReasonBuilder
}

// _BACnetPropertyStatesAccessCredentialDisableReason is the data-structure of this message
type _BACnetPropertyStatesAccessCredentialDisableReason struct {
	BACnetPropertyStatesContract
	AccessCredentialDisableReason BACnetAccessCredentialDisableReasonTagged
}

var _ BACnetPropertyStatesAccessCredentialDisableReason = (*_BACnetPropertyStatesAccessCredentialDisableReason)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesAccessCredentialDisableReason)(nil)

// NewBACnetPropertyStatesAccessCredentialDisableReason factory function for _BACnetPropertyStatesAccessCredentialDisableReason
func NewBACnetPropertyStatesAccessCredentialDisableReason(peekedTagHeader BACnetTagHeader, accessCredentialDisableReason BACnetAccessCredentialDisableReasonTagged) *_BACnetPropertyStatesAccessCredentialDisableReason {
	if accessCredentialDisableReason == nil {
		panic("accessCredentialDisableReason of type BACnetAccessCredentialDisableReasonTagged for BACnetPropertyStatesAccessCredentialDisableReason must not be nil")
	}
	_result := &_BACnetPropertyStatesAccessCredentialDisableReason{
		BACnetPropertyStatesContract:  NewBACnetPropertyStates(peekedTagHeader),
		AccessCredentialDisableReason: accessCredentialDisableReason,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesAccessCredentialDisableReasonBuilder is a builder for BACnetPropertyStatesAccessCredentialDisableReason
type BACnetPropertyStatesAccessCredentialDisableReasonBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(accessCredentialDisableReason BACnetAccessCredentialDisableReasonTagged) BACnetPropertyStatesAccessCredentialDisableReasonBuilder
	// WithAccessCredentialDisableReason adds AccessCredentialDisableReason (property field)
	WithAccessCredentialDisableReason(BACnetAccessCredentialDisableReasonTagged) BACnetPropertyStatesAccessCredentialDisableReasonBuilder
	// WithAccessCredentialDisableReasonBuilder adds AccessCredentialDisableReason (property field) which is build by the builder
	WithAccessCredentialDisableReasonBuilder(func(BACnetAccessCredentialDisableReasonTaggedBuilder) BACnetAccessCredentialDisableReasonTaggedBuilder) BACnetPropertyStatesAccessCredentialDisableReasonBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesAccessCredentialDisableReason or returns an error if something is wrong
	Build() (BACnetPropertyStatesAccessCredentialDisableReason, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesAccessCredentialDisableReason
}

// NewBACnetPropertyStatesAccessCredentialDisableReasonBuilder() creates a BACnetPropertyStatesAccessCredentialDisableReasonBuilder
func NewBACnetPropertyStatesAccessCredentialDisableReasonBuilder() BACnetPropertyStatesAccessCredentialDisableReasonBuilder {
	return &_BACnetPropertyStatesAccessCredentialDisableReasonBuilder{_BACnetPropertyStatesAccessCredentialDisableReason: new(_BACnetPropertyStatesAccessCredentialDisableReason)}
}

type _BACnetPropertyStatesAccessCredentialDisableReasonBuilder struct {
	*_BACnetPropertyStatesAccessCredentialDisableReason

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesAccessCredentialDisableReasonBuilder) = (*_BACnetPropertyStatesAccessCredentialDisableReasonBuilder)(nil)

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesAccessCredentialDisableReason
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) WithMandatoryFields(accessCredentialDisableReason BACnetAccessCredentialDisableReasonTagged) BACnetPropertyStatesAccessCredentialDisableReasonBuilder {
	return b.WithAccessCredentialDisableReason(accessCredentialDisableReason)
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) WithAccessCredentialDisableReason(accessCredentialDisableReason BACnetAccessCredentialDisableReasonTagged) BACnetPropertyStatesAccessCredentialDisableReasonBuilder {
	b.AccessCredentialDisableReason = accessCredentialDisableReason
	return b
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) WithAccessCredentialDisableReasonBuilder(builderSupplier func(BACnetAccessCredentialDisableReasonTaggedBuilder) BACnetAccessCredentialDisableReasonTaggedBuilder) BACnetPropertyStatesAccessCredentialDisableReasonBuilder {
	builder := builderSupplier(b.AccessCredentialDisableReason.CreateBACnetAccessCredentialDisableReasonTaggedBuilder())
	var err error
	b.AccessCredentialDisableReason, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAccessCredentialDisableReasonTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) Build() (BACnetPropertyStatesAccessCredentialDisableReason, error) {
	if b.AccessCredentialDisableReason == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'accessCredentialDisableReason' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesAccessCredentialDisableReason.deepCopy(), nil
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) MustBuild() BACnetPropertyStatesAccessCredentialDisableReason {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesAccessCredentialDisableReasonBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesAccessCredentialDisableReasonBuilder().(*_BACnetPropertyStatesAccessCredentialDisableReasonBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesAccessCredentialDisableReasonBuilder creates a BACnetPropertyStatesAccessCredentialDisableReasonBuilder
func (b *_BACnetPropertyStatesAccessCredentialDisableReason) CreateBACnetPropertyStatesAccessCredentialDisableReasonBuilder() BACnetPropertyStatesAccessCredentialDisableReasonBuilder {
	if b == nil {
		return NewBACnetPropertyStatesAccessCredentialDisableReasonBuilder()
	}
	return &_BACnetPropertyStatesAccessCredentialDisableReasonBuilder{_BACnetPropertyStatesAccessCredentialDisableReason: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetAccessCredentialDisableReason() BACnetAccessCredentialDisableReasonTagged {
	return m.AccessCredentialDisableReason
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesAccessCredentialDisableReason(structType any) BACnetPropertyStatesAccessCredentialDisableReason {
	if casted, ok := structType.(BACnetPropertyStatesAccessCredentialDisableReason); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesAccessCredentialDisableReason); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetTypeName() string {
	return "BACnetPropertyStatesAccessCredentialDisableReason"
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (accessCredentialDisableReason)
	lengthInBits += m.AccessCredentialDisableReason.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesAccessCredentialDisableReason BACnetPropertyStatesAccessCredentialDisableReason, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesAccessCredentialDisableReason"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesAccessCredentialDisableReason")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	accessCredentialDisableReason, err := ReadSimpleField[BACnetAccessCredentialDisableReasonTagged](ctx, "accessCredentialDisableReason", ReadComplex[BACnetAccessCredentialDisableReasonTagged](BACnetAccessCredentialDisableReasonTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessCredentialDisableReason' field"))
	}
	m.AccessCredentialDisableReason = accessCredentialDisableReason

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesAccessCredentialDisableReason"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesAccessCredentialDisableReason")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesAccessCredentialDisableReason"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesAccessCredentialDisableReason")
		}

		if err := WriteSimpleField[BACnetAccessCredentialDisableReasonTagged](ctx, "accessCredentialDisableReason", m.GetAccessCredentialDisableReason(), WriteComplex[BACnetAccessCredentialDisableReasonTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessCredentialDisableReason' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesAccessCredentialDisableReason"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesAccessCredentialDisableReason")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) IsBACnetPropertyStatesAccessCredentialDisableReason() {
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) deepCopy() *_BACnetPropertyStatesAccessCredentialDisableReason {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesAccessCredentialDisableReasonCopy := &_BACnetPropertyStatesAccessCredentialDisableReason{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetAccessCredentialDisableReasonTagged](m.AccessCredentialDisableReason),
	}
	_BACnetPropertyStatesAccessCredentialDisableReasonCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesAccessCredentialDisableReasonCopy
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
