/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNotifyType is the corresponding interface of BACnetConstructedDataNotifyType
type BACnetConstructedDataNotifyType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNotifyType returns NotifyType (property field)
	GetNotifyType() BACnetNotifyTypeTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetNotifyTypeTagged
	// IsBACnetConstructedDataNotifyType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataNotifyType()
	// CreateBuilder creates a BACnetConstructedDataNotifyTypeBuilder
	CreateBACnetConstructedDataNotifyTypeBuilder() BACnetConstructedDataNotifyTypeBuilder
}

// _BACnetConstructedDataNotifyType is the data-structure of this message
type _BACnetConstructedDataNotifyType struct {
	BACnetConstructedDataContract
	NotifyType BACnetNotifyTypeTagged
}

var _ BACnetConstructedDataNotifyType = (*_BACnetConstructedDataNotifyType)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataNotifyType)(nil)

// NewBACnetConstructedDataNotifyType factory function for _BACnetConstructedDataNotifyType
func NewBACnetConstructedDataNotifyType(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, notifyType BACnetNotifyTypeTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNotifyType {
	if notifyType == nil {
		panic("notifyType of type BACnetNotifyTypeTagged for BACnetConstructedDataNotifyType must not be nil")
	}
	_result := &_BACnetConstructedDataNotifyType{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NotifyType:                    notifyType,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataNotifyTypeBuilder is a builder for BACnetConstructedDataNotifyType
type BACnetConstructedDataNotifyTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(notifyType BACnetNotifyTypeTagged) BACnetConstructedDataNotifyTypeBuilder
	// WithNotifyType adds NotifyType (property field)
	WithNotifyType(BACnetNotifyTypeTagged) BACnetConstructedDataNotifyTypeBuilder
	// WithNotifyTypeBuilder adds NotifyType (property field) which is build by the builder
	WithNotifyTypeBuilder(func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetConstructedDataNotifyTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataNotifyType or returns an error if something is wrong
	Build() (BACnetConstructedDataNotifyType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataNotifyType
}

// NewBACnetConstructedDataNotifyTypeBuilder() creates a BACnetConstructedDataNotifyTypeBuilder
func NewBACnetConstructedDataNotifyTypeBuilder() BACnetConstructedDataNotifyTypeBuilder {
	return &_BACnetConstructedDataNotifyTypeBuilder{_BACnetConstructedDataNotifyType: new(_BACnetConstructedDataNotifyType)}
}

type _BACnetConstructedDataNotifyTypeBuilder struct {
	*_BACnetConstructedDataNotifyType

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataNotifyTypeBuilder) = (*_BACnetConstructedDataNotifyTypeBuilder)(nil)

func (b *_BACnetConstructedDataNotifyTypeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataNotifyType
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) WithMandatoryFields(notifyType BACnetNotifyTypeTagged) BACnetConstructedDataNotifyTypeBuilder {
	return b.WithNotifyType(notifyType)
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) WithNotifyType(notifyType BACnetNotifyTypeTagged) BACnetConstructedDataNotifyTypeBuilder {
	b.NotifyType = notifyType
	return b
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) WithNotifyTypeBuilder(builderSupplier func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetConstructedDataNotifyTypeBuilder {
	builder := builderSupplier(b.NotifyType.CreateBACnetNotifyTypeTaggedBuilder())
	var err error
	b.NotifyType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetNotifyTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) Build() (BACnetConstructedDataNotifyType, error) {
	if b.NotifyType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'notifyType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataNotifyType.deepCopy(), nil
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) MustBuild() BACnetConstructedDataNotifyType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataNotifyTypeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataNotifyTypeBuilder().(*_BACnetConstructedDataNotifyTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataNotifyTypeBuilder creates a BACnetConstructedDataNotifyTypeBuilder
func (b *_BACnetConstructedDataNotifyType) CreateBACnetConstructedDataNotifyTypeBuilder() BACnetConstructedDataNotifyTypeBuilder {
	if b == nil {
		return NewBACnetConstructedDataNotifyTypeBuilder()
	}
	return &_BACnetConstructedDataNotifyTypeBuilder{_BACnetConstructedDataNotifyType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNotifyType) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataNotifyType) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_NOTIFY_TYPE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNotifyType) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataNotifyType) GetNotifyType() BACnetNotifyTypeTagged {
	return m.NotifyType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataNotifyType) GetActualValue() BACnetNotifyTypeTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetNotifyTypeTagged(m.GetNotifyType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNotifyType(structType any) BACnetConstructedDataNotifyType {
	if casted, ok := structType.(BACnetConstructedDataNotifyType); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNotifyType); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNotifyType) GetTypeName() string {
	return "BACnetConstructedDataNotifyType"
}

func (m *_BACnetConstructedDataNotifyType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (notifyType)
	lengthInBits += m.NotifyType.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataNotifyType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataNotifyType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataNotifyType BACnetConstructedDataNotifyType, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNotifyType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNotifyType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	notifyType, err := ReadSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", ReadComplex[BACnetNotifyTypeTagged](BACnetNotifyTypeTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notifyType' field"))
	}
	m.NotifyType = notifyType

	actualValue, err := ReadVirtualField[BACnetNotifyTypeTagged](ctx, "actualValue", (*BACnetNotifyTypeTagged)(nil), notifyType)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNotifyType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNotifyType")
	}

	return m, nil
}

func (m *_BACnetConstructedDataNotifyType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataNotifyType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNotifyType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNotifyType")
		}

		if err := WriteSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", m.GetNotifyType(), WriteComplex[BACnetNotifyTypeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'notifyType' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNotifyType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNotifyType")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNotifyType) IsBACnetConstructedDataNotifyType() {}

func (m *_BACnetConstructedDataNotifyType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataNotifyType) deepCopy() *_BACnetConstructedDataNotifyType {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataNotifyTypeCopy := &_BACnetConstructedDataNotifyType{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetNotifyTypeTagged](m.NotifyType),
	}
	_BACnetConstructedDataNotifyTypeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataNotifyTypeCopy
}

func (m *_BACnetConstructedDataNotifyType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
