/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.component;

/**
 * Constants for the renderer type
 */
public enum RendererTypes {

  Badge,
  BadgeInsideButtons,
  Bar,
  Box,
  Button,
  ButtonInsideButtons,
  ButtonInsideIn,
  ButtonInsideInAfter,
  Buttons,
  Calendar,
  Column,
  ColumnSelector,
  Date,
  Event,
  Figure,
  File,
  FlexLayout,
  FlowLayout,
  Footer,
  Form,
  GridLayout,
  Header,
  Hidden,
  In,
  Image,
  Link,
  LinkInsideCommand,
  LinkInsideLinks,
  Links,
  LinksInsideBar,
  Label,
  Messages,
  Meta,
  MetaLink,
  Object,
  Operation,
  Out,
  OutInsideBoxLabel,
  OutInsideIn,
  OutInsideSectionLabel,
  Page,
  Panel,
  Popup,
  Progress,
  Row,
  Script,
  Section,
  SegmentLayout,
  SelectBooleanCheckbox,
  SelectBooleanCheckboxInsideCommand,
  SelectBooleanToggle,
  SelectManyCheckbox,
  SelectManyCheckboxInsideCommand,
  SelectManyListbox,
  SelectManyShuttle,
  SelectOneChoice,
  SelectOneChoiceInsideIn,
  SelectOneRadio,
  SelectOneRadioInsideCommand,
  SelectOneListbox,
  SelectReference,
  Separator,
  SeparatorInsideCommand,
  Sheet,
  SheetPageCommand,
  Stars,
  Style,
  Suggest,
  Textarea,
  Tab,
  TabGroup,
  ToolBar,
  Tree,
  /**
   * @deprecated since 2.0.0
   */
  @Deprecated
  TreeData,
  /**
   * @deprecated since 4.0.0, please use {@link #Link}
   */
  @Deprecated
  TreeCommand,
  TreeIcon,
  TreeIndent,
  TreeLabel,
  TreeListbox,
  /**
   * @deprecated since 4.2.1
   */
  @Deprecated
  TreeMenu,
  TreeNode,
  TreeSelect;

  public static final String BADGE = "Badge";
  public static final String BADGE_INSIDE_BUTTONS = "BadgeInsideButtons";
  public static final String BAR = "Bar";
  public static final String BOX = "Box";
  public static final String BUTTON = "Button";
  public static final String BUTTON_INSIDE_BUTTONS = "ButtonInsideButtons";
  public static final String BUTTON_INSIDE_IN = "ButtonInsideIn";
  public static final String BUTTON_INSIDE_IN_AFTER = "ButtonInsideInAfter";
  public static final String BUTTONS = "Buttons";
  public static final String CALENDAR = "Calendar";
  public static final String COLUMN = "Column";
  public static final String COLUMN_SELECTOR = "ColumnSelector";
  public static final String EVENT = "Event";
  public static final String DATE = "Date";
  public static final String FIGURE = "Figure";
  public static final String FILE = "File";
  public static final String FLEX_LAYOUT = "FlexLayout";
  public static final String FLOW_LAYOUT = "FlowLayout";
  public static final String FOOTER = "Footer";
  public static final String FORM = "Form";
  public static final String GRID_LAYOUT = "GridLayout";
  public static final String HEADER = "Header";
  public static final String HIDDEN = "Hidden";
  public static final String IN = "In";
  public static final String IMAGE = "Image";
  public static final String LINK = "Link";
  public static final String LINK_INSIDE_COMMAND = "LinkInsideCommand";
  public static final String LINK_INSIDE_LINKS = "LinkInsideLinks";
  public static final String LINKS = "Links";
  public static final String LINKS_INSIDE_BAR = "LinksInsideBar";
  public static final String LABEL = "Label";
  public static final String MESSAGES = "Messages";
  public static final String META = "Meta";
  public static final String META_LINK = "MetaLink";
  public static final String OBJECT = "Object";
  public static final String OPERATION = "Operation";
  public static final String OUT = "Out";
  public static final String OUT_INSIDE_BOX_LABEL = "OutInsideBoxLabel";
  public static final String OUT_INSIDE_IN = "OutInsideIn";
  public static final String OUT_INSIDE_SECTION_LABEL = "OutInsideSectionLabel";
  public static final String PAGE = "Page";
  public static final String PANEL = "Panel";
  public static final String POPUP = "Popup";
  public static final String PROGRESS = "Progress";
  public static final String ROW = "Row";
  public static final String SCRIPT = "Script";
  public static final String SECTION = "Section";
  public static final String SEGMENT_LAYOUT = "SegmentLayout";
  public static final String SELECT_BOOLEAN_CHECKBOX = "SelectBooleanCheckbox";
  public static final String SELECT_BOOLEAN_CHECKBOX_INSIDE_COMMAND = "SelectBooleanCheckboxInsideCommand";
  public static final String SELECT_BOOLEAN_TOGGLE = "SelectBooleanToggle";
  public static final String SELECT_MANY_CHECKBOX = "SelectManyCheckbox";
  public static final String SELECT_MANY_CHECKBOX_INSIDE_COMMAND = "SelectManyCheckboxInsideCommand";
  public static final String SELECT_MANY_LISTBOX = "SelectManyListbox";
  public static final String SELECT_MANY_SHUTTLE = "SelectManyShuttle";
  public static final String SELECT_ONE_CHOICE = "SelectOneChoice";
  public static final String SELECT_ONE_CHOICE_INSIDE_IN = "SelectOneChoiceInsideIn";
  public static final String SELECT_ONE_RADIO = "SelectOneRadio";
  public static final String SELECT_ONE_RADIO_INSIDE_COMMAND = "SelectOneRadioInsideCommand";
  public static final String SELECT_ONE_LISTBOX = "SelectOneListbox";
  public static final String SELECT_REFERENCE = "SelectReference";
  public static final String SEPARATOR = "Separator";
  public static final String SEPARATOR_INSIDE_COMMAND = "SeparatorInsideCommand";
  public static final String SHEET = "Sheet";
  public static final String SHEET_PAGE_COMMAND = "SheetPageCommand";
  public static final String STARS = "Stars";
  public static final String STYLE = "Style";
  public static final String SUGGEST = "Suggest";
  public static final String TEXTAREA = "Textarea";
  public static final String TAB = "Tab";
  public static final String TAB_GROUP = "TabGroup";
  public static final String TOOL_BAR = "ToolBar";
  public static final String TREE = "Tree";
  /**
   * @deprecated since 2.0.0
   */
  @Deprecated
  public static final String TREE_DATA = "TreeData";
  /**
   * @deprecated since 4.0.0, please use {@link #LINK}
   */
  @Deprecated
  public static final String TREE_COMMAND = "TreeCommand";
  public static final String TREE_ICON = "TreeIcon";
  public static final String TREE_INDENT = "TreeIndent";
  public static final String TREE_LABEL = "TreeLabel";
  public static final String TREE_LISTBOX = "TreeListbox";
  /**
   * @deprecated since 4.2.1
   */
  @Deprecated
  public static final String TREE_MENU = "TreeMenu";
  public static final String TREE_NODE = "TreeNode";
  public static final String TREE_SELECT = "TreeSelect";
}
