/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager;

import java.security.SecureRandom;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.util.EncryptUtils;
import org.apache.ftpserver.util.PasswordUtil;

public class SaltedPasswordEncryptor
implements PasswordEncryptor {
    private SecureRandom rnd = new SecureRandom();
    private static final int MAX_SEED = 99999999;
    private static final int HASH_ITERATIONS = 1000;

    private String encrypt(String password, String salt) {
        String hash = salt + password;
        for (int i = 0; i < 1000; ++i) {
            hash = EncryptUtils.encryptMD5(hash);
        }
        return salt + ":" + hash;
    }

    @Override
    public String encrypt(String password) {
        String seed = Integer.toString(this.rnd.nextInt(99999999));
        return this.encrypt(password, seed);
    }

    @Override
    public boolean matches(String passwordToCheck, String storedPassword) {
        if (storedPassword == null) {
            throw new NullPointerException("storedPassword can not be null");
        }
        if (passwordToCheck == null) {
            throw new NullPointerException("passwordToCheck can not be null");
        }
        int divider = storedPassword.indexOf(58);
        if (divider < 1) {
            throw new IllegalArgumentException("stored password does not contain salt");
        }
        String storedSalt = storedPassword.substring(0, divider);
        return PasswordUtil.secureCompareFast(this.encrypt(passwordToCheck, storedSalt).toLowerCase(), storedPassword.toLowerCase());
    }
}

