/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.util.ContentStream;

public class BinaryRequestWriter
extends RequestWriter {
    @Override
    public RequestWriter.ContentWriter getContentWriter(SolrRequest<?> req) {
        if (req instanceof UpdateRequest) {
            final UpdateRequest updateRequest = (UpdateRequest)req;
            if (this.isEmpty(updateRequest)) {
                return null;
            }
            return new RequestWriter.ContentWriter(){

                @Override
                public void write(OutputStream os) throws IOException {
                    new JavaBinUpdateRequestCodec().marshal(updateRequest, os);
                }

                @Override
                public String getContentType() {
                    return "application/javabin";
                }
            };
        }
        return req.getContentWriter("application/javabin");
    }

    @Override
    public Collection<ContentStream> getContentStreams(SolrRequest<?> req) throws IOException {
        if (req instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)req;
            if (this.isEmpty(updateRequest)) {
                return null;
            }
            throw new RuntimeException("This Should not happen");
        }
        return super.getContentStreams(req);
    }

    @Override
    public String getUpdateContentType() {
        return "application/javabin";
    }

    @Override
    public void write(SolrRequest<?> request, OutputStream os) throws IOException {
        if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            new JavaBinUpdateRequestCodec().marshal(updateRequest, os);
        }
    }

    public static class BAOS
    extends ByteArrayOutputStream {
        public byte[] getbuf() {
            return this.buf;
        }
    }
}

