/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

abstract class AbstractSingleValueMathFunction
implements Function {
    AbstractSingleValueMathFunction() {
    }

    @Override
    public boolean acceptsParameters(List<Expression> parameters) {
        return true;
    }

    @Override
    public final Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression iParameter;
        if (parameters.size() > 1) {
            problemsHandler.wrongNumberOfArgumentsToFunctionMin(call.getParameter(), call.getName(), 1);
        }
        if ((iParameter = parameters.get(0)).getType() != ASTCssNodeType.NUMBER) {
            problemsHandler.wrongArgumentTypeToFunction(iParameter, this.getName(), iParameter.getType(), ASTCssNodeType.NUMBER);
            return new FaultyExpression(iParameter);
        }
        NumberExpression parameter = (NumberExpression)iParameter;
        HiddenTokenAwareTree parentToken = parameter.getUnderlyingStructure();
        Double oValue = parameter.getValueAsDouble();
        String suffix = parameter.getSuffix();
        NumberExpression.Dimension dimension = parameter.getDimension();
        if (oValue.isInfinite() || oValue.isNaN()) {
            return new NumberExpression(parentToken, oValue, suffix, null, dimension);
        }
        return this.calc(parentToken, oValue, suffix, dimension);
    }

    protected Expression calc(HiddenTokenAwareTree parentToken, Double oValue, String suffix, NumberExpression.Dimension dimension) {
        return new NumberExpression(parentToken, this.calc(oValue, suffix, dimension), this.resultSuffix(suffix, dimension), null, this.resultDimension(suffix, dimension));
    }

    protected String resultSuffix(String suffix, NumberExpression.Dimension dimension) {
        return suffix;
    }

    protected NumberExpression.Dimension resultDimension(String suffix, NumberExpression.Dimension dimension) {
        return dimension;
    }

    protected abstract String getName();

    protected abstract double calc(double var1, String var3, NumberExpression.Dimension var4);
}

