/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OrderedHashMap
extends HashMap {
    private static final long serialVersionUID = -1648679783713336948L;
    private ArrayList _orderedValues = null;

    public OrderedHashMap() {
        this._orderedValues = new ArrayList();
    }

    public OrderedHashMap(int initialCapacity) {
        super(initialCapacity);
        this._orderedValues = new ArrayList(initialCapacity);
    }

    public OrderedHashMap(Map m) {
        this(m.size());
        this.putAll(m);
    }

    public void clear() {
        super.clear();
        this._orderedValues.clear();
    }

    public Object clone() {
        OrderedHashMap map = new OrderedHashMap(this.size());
        map.putAll((Map)this);
        return map;
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    public Set keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    public Object put(Object key, Object value) {
        Object obj = super.get(key);
        if (obj != null) {
            this._orderedValues.remove(obj);
        }
        obj = super.put(key, value);
        this._orderedValues.add(value);
        return obj;
    }

    public void putAll(Map m) {
        Set entries = m.entrySet();
        if (!entries.isEmpty()) {
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object remove(Object key) {
        Object obj = super.remove(key);
        this._orderedValues.remove(obj);
        return obj;
    }

    public Collection values() {
        return Collections.unmodifiableList(this._orderedValues);
    }
}

