/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.exists.indices;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;

public class RestIndicesExistsAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestIndicesExistsAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(RestRequest request, final RestChannel channel) {
        IndicesExistsRequest indicesExistsRequest = new IndicesExistsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        indicesExistsRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesExistsRequest.indicesOptions()));
        indicesExistsRequest.local(request.paramAsBoolean("local", indicesExistsRequest.local()));
        indicesExistsRequest.listenerThreaded(false);
        this.client.admin().indices().exists(indicesExistsRequest, new ActionListener<IndicesExistsResponse>(){

            @Override
            public void onResponse(IndicesExistsResponse response) {
                try {
                    if (response.isExists()) {
                        channel.sendResponse(new StringRestResponse(RestStatus.OK));
                    } else {
                        channel.sendResponse(new StringRestResponse(RestStatus.NOT_FOUND));
                    }
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new StringRestResponse(ExceptionsHelper.status(e)));
                }
                catch (Exception e1) {
                    RestIndicesExistsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

