/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class DoubleValues {
    public static final DoubleValues EMPTY = new Empty();
    private final boolean multiValued;
    protected int docId;

    protected DoubleValues(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public final boolean isMultiValued() {
        return this.multiValued;
    }

    public abstract int setDocument(int var1);

    public abstract double nextValue();

    public AtomicFieldData.Order getOrder() {
        return AtomicFieldData.Order.NUMERIC;
    }

    public static DoubleValues asDoubleValues(final LongValues values) {
        return new DoubleValues(values.isMultiValued()){

            @Override
            public int setDocument(int docId) {
                return values.setDocument(docId);
            }

            @Override
            public double nextValue() {
                return values.nextValue();
            }
        };
    }

    private static class Empty
    extends DoubleValues {
        Empty() {
            super(false);
        }

        @Override
        public int setDocument(int docId) {
            return 0;
        }

        @Override
        public double nextValue() {
            throw new ElasticsearchIllegalStateException("Empty DoubleValues has no next value");
        }
    }

    public static abstract class WithOrdinals
    extends DoubleValues {
        protected final Ordinals.Docs ordinals;

        protected WithOrdinals(Ordinals.Docs ordinals) {
            super(ordinals.isMultiValued());
            this.ordinals = ordinals;
        }

        public Ordinals.Docs ordinals() {
            return this.ordinals;
        }

        public abstract double getValueByOrd(long var1);

        @Override
        public int setDocument(int docId) {
            this.docId = docId;
            return this.ordinals.setDocument(docId);
        }

        @Override
        public double nextValue() {
            return this.getValueByOrd(this.ordinals.nextOrd());
        }
    }
}

