/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.common.hppc.DoubleArrayList;
import org.elasticsearch.common.hppc.FloatArrayList;
import org.elasticsearch.common.hppc.LongArrayList;
import org.elasticsearch.common.primitives.Longs;

public enum CollectionUtils {


    public static void sort(LongArrayList list) {
        CollectionUtils.sort(list.buffer, list.size());
    }

    public static void sort(final long[] array, int len) {
        new IntroSorter(){
            long pivot;

            protected void swap(int i, int j) {
                long tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            protected int compare(int i, int j) {
                return Longs.compare(array[i], array[j]);
            }

            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            protected int comparePivot(int j) {
                return Longs.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sortAndDedup(LongArrayList list) {
        list.elementsCount = CollectionUtils.sortAndDedup(list.buffer, list.elementsCount);
    }

    public static int sortAndDedup(long[] array, int len) {
        if (len <= 1) {
            return len;
        }
        CollectionUtils.sort(array, len);
        int uniqueCount = 1;
        for (int i = 1; i < len; ++i) {
            if (array[i] == array[i - 1]) continue;
            array[uniqueCount++] = array[i];
        }
        return uniqueCount;
    }

    public static void sort(FloatArrayList list) {
        CollectionUtils.sort(list.buffer, list.size());
    }

    public static void sort(final float[] array, int len) {
        new IntroSorter(){
            float pivot;

            protected void swap(int i, int j) {
                float tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            protected int compare(int i, int j) {
                return Float.compare(array[i], array[j]);
            }

            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            protected int comparePivot(int j) {
                return Float.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sortAndDedup(FloatArrayList list) {
        list.elementsCount = CollectionUtils.sortAndDedup(list.buffer, list.elementsCount);
    }

    public static int sortAndDedup(float[] array, int len) {
        if (len <= 1) {
            return len;
        }
        CollectionUtils.sort(array, len);
        int uniqueCount = 1;
        for (int i = 1; i < len; ++i) {
            if (Float.compare(array[i], array[i - 1]) == 0) continue;
            array[uniqueCount++] = array[i];
        }
        return uniqueCount;
    }

    public static void sort(DoubleArrayList list) {
        CollectionUtils.sort(list.buffer, list.size());
    }

    public static void sort(final double[] array, int len) {
        new IntroSorter(){
            double pivot;

            protected void swap(int i, int j) {
                double tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            protected int compare(int i, int j) {
                return Double.compare(array[i], array[j]);
            }

            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            protected int comparePivot(int j) {
                return Double.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sortAndDedup(DoubleArrayList list) {
        list.elementsCount = CollectionUtils.sortAndDedup(list.buffer, list.elementsCount);
    }

    public static int sortAndDedup(double[] array, int len) {
        if (len <= 1) {
            return len;
        }
        CollectionUtils.sort(array, len);
        int uniqueCount = 1;
        for (int i = 1; i < len; ++i) {
            if (Double.compare(array[i], array[i - 1]) == 0) continue;
            array[uniqueCount++] = array[i];
        }
        return uniqueCount;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }
}

