/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.RestoreMetaData;
import org.elasticsearch.cluster.metadata.SnapshotMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.hppc.ObjectArrayList;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class MetaData
implements Iterable<IndexMetaData> {
    public static Map<String, Custom.Factory> customFactories = new HashMap<String, Custom.Factory>();
    public static final String SETTING_READ_ONLY = "cluster.blocks.read_only";
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK;
    public static final MetaData EMPTY_META_DATA;
    public static final String GLOBAL_PERSISTENT_ONLY_PARAM = "global_persistent_only";
    private final String uuid;
    private final long version;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final ImmutableOpenMap<String, IndexMetaData> indices;
    private final ImmutableOpenMap<String, IndexTemplateMetaData> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int numberOfShards;
    private final String[] allIndices;
    private final String[] allOpenIndices;
    private final String[] allClosedIndices;
    private final ImmutableOpenMap<String, ImmutableOpenMap<String, AliasMetaData>> aliases;
    private final ImmutableOpenMap<String, String[]> aliasAndIndexToIndexMap;

    public static void registerFactory(String type, Custom.Factory factory) {
        customFactories.put(type, factory);
    }

    @Nullable
    public static <T extends Custom> Custom.Factory<T> lookupFactory(String type) {
        return customFactories.get(type);
    }

    public static <T extends Custom> Custom.Factory<T> lookupFactorySafe(String type) throws ElasticsearchIllegalArgumentException {
        Custom.Factory factory = customFactories.get(type);
        if (factory == null) {
            throw new ElasticsearchIllegalArgumentException("No custom index metadata factory registered for type [" + type + "]");
        }
        return factory;
    }

    MetaData(String uuid, long version, Settings transientSettings, Settings persistentSettings, ImmutableOpenMap<String, IndexMetaData> indices, ImmutableOpenMap<String, IndexTemplateMetaData> templates, ImmutableOpenMap<String, Custom> customs) {
        this.uuid = uuid;
        this.version = version;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = ImmutableSettings.settingsBuilder().put(persistentSettings).put(transientSettings).build();
        this.indices = indices;
        this.customs = customs;
        this.templates = templates;
        int totalNumberOfShards = 0;
        int numberOfShards = 0;
        int numAliases = 0;
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            totalNumberOfShards += ((IndexMetaData)objectCursor.value).totalNumberOfShards();
            numberOfShards += ((IndexMetaData)objectCursor.value).numberOfShards();
            numAliases += ((IndexMetaData)objectCursor.value).aliases().size();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.numberOfShards = numberOfShards;
        ArrayList<String> allIndicesLst = Lists.newArrayList();
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            allIndicesLst.add(((IndexMetaData)objectCursor.value).index());
        }
        this.allIndices = allIndicesLst.toArray(new String[allIndicesLst.size()]);
        int n = allIndicesLst.size();
        ArrayList<String> arrayList = Lists.newArrayList();
        ArrayList<String> allClosedIndices = Lists.newArrayList();
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            IndexMetaData indexMetaData = (IndexMetaData)objectCursor.value;
            if (indexMetaData.state() == IndexMetaData.State.OPEN) {
                arrayList.add(indexMetaData.index());
                continue;
            }
            if (indexMetaData.state() != IndexMetaData.State.CLOSE) continue;
            allClosedIndices.add(indexMetaData.index());
        }
        this.allOpenIndices = arrayList.toArray(new String[arrayList.size()]);
        this.allClosedIndices = allClosedIndices.toArray(new String[allClosedIndices.size()]);
        ImmutableOpenMap.Builder tmpAliases = ImmutableOpenMap.builder(numAliases);
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            IndexMetaData indexMetaData = (IndexMetaData)objectCursor.value;
            String index = indexMetaData.index();
            for (ObjectCursor<AliasMetaData> objectCursor2 : indexMetaData.aliases().values()) {
                AliasMetaData aliasMd = (AliasMetaData)objectCursor2.value;
                ImmutableOpenMap.Builder<String, AliasMetaData> indexAliasMap = (ImmutableOpenMap.Builder<String, AliasMetaData>)tmpAliases.get(aliasMd.alias());
                if (indexAliasMap == null) {
                    indexAliasMap = ImmutableOpenMap.builder(indices.size());
                    tmpAliases.put(aliasMd.alias(), indexAliasMap);
                }
                indexAliasMap.put(index, aliasMd);
            }
        }
        for (ObjectCursor objectCursor : tmpAliases.keys()) {
            String string = (String)objectCursor.value;
            ImmutableOpenMap map = ((ImmutableOpenMap.Builder)tmpAliases.get(string)).cast().build();
            tmpAliases.put(string, map);
        }
        this.aliases = tmpAliases.cast().build();
        ImmutableOpenMap.Builder<String, Object> builder = ImmutableOpenMap.builder(numAliases + n);
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            IndexMetaData indexMetaData = (IndexMetaData)objectCursor.value;
            ObjectArrayList<String> indicesLst = (ObjectArrayList<String>)builder.get(indexMetaData.index());
            if (indicesLst == null) {
                indicesLst = new ObjectArrayList<String>();
                builder.put(indexMetaData.index(), indicesLst);
            }
            indicesLst.add(indexMetaData.index());
            for (ObjectCursor cursor1 : indexMetaData.aliases().keys()) {
                String alias = (String)cursor1.value;
                indicesLst = (ObjectArrayList<String>)builder.get(alias);
                if (indicesLst == null) {
                    indicesLst = new ObjectArrayList<String>();
                    builder.put(alias, indicesLst);
                }
                indicesLst.add(indexMetaData.index());
            }
        }
        for (ObjectObjectCursor objectObjectCursor : builder) {
            String[] indicesLst = (String[])((ObjectArrayList)objectObjectCursor.value).toArray(String.class);
            builder.put((String)objectObjectCursor.key, indicesLst);
        }
        this.aliasAndIndexToIndexMap = builder.cast().build();
    }

    public long version() {
        return this.version;
    }

    public String uuid() {
        return this.uuid;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, AliasMetaData>> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, AliasMetaData>> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, ImmutableList<AliasMetaData>> findAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        boolean matchAllAliases = this.matchAllAliases(aliases);
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectOpenHashSet.from(concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = Lists.newArrayList();
            for (ObjectCursor<AliasMetaData> objectCursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)objectCursor.value;
                if (!matchAllAliases && !Regex.simpleMatch(aliases, value.alias())) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            mapBuilder.put(index, ImmutableList.copyOf(filteredValues));
        }
        return mapBuilder.build();
    }

    private boolean matchAllAliases(String[] aliases) {
        for (String alias : aliases) {
            if (!alias.equals("_all")) continue;
            return true;
        }
        return aliases.length == 0;
    }

    public boolean hasAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return false;
        }
        Iterable<String> intersection = HppcMaps.intersection(ObjectOpenHashSet.from(concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = Lists.newArrayList();
            for (ObjectCursor<AliasMetaData> objectCursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)objectCursor.value;
                if (!Regex.simpleMatch(aliases, value.alias())) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> findMappings(String[] concreteIndices, String[] types) {
        assert (types != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectOpenHashSet.from(concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            if (this.isAllTypes(types)) {
                indexMapBuilder.put(index, indexMetaData.getMappings());
                continue;
            }
            ImmutableOpenMap.Builder filteredMappings = ImmutableOpenMap.builder();
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.mappings()) {
                if (!Regex.simpleMatch(types, (String)objectObjectCursor.key)) continue;
                filteredMappings.put(objectObjectCursor.key, objectObjectCursor.value);
            }
            if (filteredMappings.isEmpty()) continue;
            indexMapBuilder.put(index, filteredMappings.build());
        }
        return indexMapBuilder.build();
    }

    public ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> findWarmers(String[] concreteIndices, final String[] types, String[] uncheckedWarmers) {
        assert (uncheckedWarmers != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        final String[] warmers = Strings.isAllOrWildcard(uncheckedWarmers) ? Strings.EMPTY_ARRAY : uncheckedWarmers;
        ImmutableOpenMap.Builder<String, ImmutableList<IndexWarmersMetaData.Entry>> mapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectOpenHashSet.from(concreteIndices), this.indices.keys());
        for (String index : intersection) {
            Collection<IndexWarmersMetaData.Entry> filteredWarmers;
            IndexMetaData indexMetaData = this.indices.get(index);
            IndexWarmersMetaData indexWarmersMetaData = (IndexWarmersMetaData)indexMetaData.custom("warmers");
            if (indexWarmersMetaData == null || indexWarmersMetaData.entries().isEmpty() || (filteredWarmers = Collections2.filter(indexWarmersMetaData.entries(), new Predicate<IndexWarmersMetaData.Entry>(){

                @Override
                public boolean apply(IndexWarmersMetaData.Entry warmer) {
                    if (warmers.length != 0 && types.length != 0) {
                        return Regex.simpleMatch(warmers, warmer.name()) && Regex.simpleMatch(types, warmer.types());
                    }
                    if (warmers.length != 0) {
                        return Regex.simpleMatch(warmers, warmer.name());
                    }
                    if (types.length != 0) {
                        return Regex.simpleMatch(types, warmer.types());
                    }
                    return true;
                }
            })).isEmpty()) continue;
            mapBuilder.put(index, ImmutableList.copyOf(filteredWarmers));
        }
        return mapBuilder.build();
    }

    public String[] concreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteAllIndices() {
        return this.concreteAllIndices();
    }

    public String[] concreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] concreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        ImmutableOpenMap<String, AliasMetaData> indexAliases = this.aliases.get(aliasOrIndex);
        if (indexAliases == null || indexAliases.isEmpty()) {
            return routing;
        }
        if (indexAliases.size() > 1) {
            throw new ElasticsearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexAliases.keys().toArray(String.class)) + "], can't execute a single index op");
        }
        AliasMetaData aliasMd = (AliasMetaData)indexAliases.values().iterator().next().value;
        if (aliasMd.indexRouting() != null) {
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new ElasticsearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            routing = aliasMd.indexRouting();
        }
        if (routing != null && routing.indexOf(44) != -1) {
            throw new ElasticsearchIllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + routing + "] that resolved to several routing values, rejecting operation");
        }
        return routing;
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String aliasOrIndex) {
        return this.resolveSearchRouting(routing, this.convertFromWildcards(new String[]{aliasOrIndex}, IndicesOptions.lenient()));
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String[] aliasesOrIndices) {
        if (this.isAllIndices(aliasesOrIndices)) {
            return this.resolveSearchRoutingAllIndices(routing);
        }
        if ((aliasesOrIndices = this.convertFromWildcards(aliasesOrIndices, IndicesOptions.lenient())).length == 1) {
            return this.resolveSearchRoutingSingleValue(routing, aliasesOrIndices[0]);
        }
        HashMap routings = null;
        Set<String> paramRouting = null;
        HashSet<Object> norouting = new HashSet<Object>();
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        for (String aliasOrIndex : aliasesOrIndices) {
            ImmutableOpenMap<String, AliasMetaData> indexToRoutingMap = this.aliases.get(aliasOrIndex);
            if (indexToRoutingMap != null && !indexToRoutingMap.isEmpty()) {
                for (ObjectObjectCursor<String, AliasMetaData> objectObjectCursor : indexToRoutingMap) {
                    HashSet<Object> r;
                    if (norouting.contains(objectObjectCursor.key)) continue;
                    if (!((AliasMetaData)objectObjectCursor.value).searchRoutingValues().isEmpty()) {
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        if ((r = (HashSet<String>)routings.get(objectObjectCursor.key)) == null) {
                            r = new HashSet<String>();
                            routings.put(objectObjectCursor.key, r);
                        }
                        r.addAll(((AliasMetaData)objectObjectCursor.value).searchRoutingValues());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(objectObjectCursor.key);
                        continue;
                    }
                    if (norouting.contains(objectObjectCursor.key)) continue;
                    norouting.add(objectObjectCursor.key);
                    if (paramRouting != null) {
                        r = new HashSet<String>(paramRouting);
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        routings.put(objectObjectCursor.key, r);
                        continue;
                    }
                    if (routings == null) continue;
                    routings.remove(objectObjectCursor.key);
                }
                continue;
            }
            if (norouting.contains(aliasOrIndex)) continue;
            norouting.add(aliasOrIndex);
            if (paramRouting != null) {
                HashSet<String> r = new HashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put(aliasOrIndex, r);
                continue;
            }
            if (routings == null) continue;
            routings.remove(aliasOrIndex);
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    private Map<String, Set<String>> resolveSearchRoutingSingleValue(@Nullable String routing, String aliasOrIndex) {
        ImmutableOpenMap<String, AliasMetaData> indexToRoutingMap;
        Map<String, Set<String>> routings = null;
        Set<String> paramRouting = null;
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        if ((indexToRoutingMap = this.aliases.get(aliasOrIndex)) != null && !indexToRoutingMap.isEmpty()) {
            for (ObjectObjectCursor<String, AliasMetaData> objectObjectCursor : indexToRoutingMap) {
                HashSet<String> r;
                if (!((AliasMetaData)objectObjectCursor.value).searchRoutingValues().isEmpty()) {
                    r = new HashSet<String>(((AliasMetaData)objectObjectCursor.value).searchRoutingValues());
                    if (paramRouting != null) {
                        r.retainAll(paramRouting);
                    }
                    if (r.isEmpty()) continue;
                    if (routings == null) {
                        routings = Maps.newHashMap();
                    }
                    routings.put((String)objectObjectCursor.key, (Set<String>)r);
                    continue;
                }
                if (paramRouting == null) continue;
                r = new HashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put((String)objectObjectCursor.key, (Set<String>)r);
            }
        } else if (paramRouting != null) {
            routings = ImmutableMap.of(aliasOrIndex, paramRouting);
        }
        return routings;
    }

    private Map<String, Set<String>> resolveSearchRoutingAllIndices(String routing) {
        if (routing != null) {
            String[] concreteIndices;
            Set<String> r = Strings.splitStringByCommaToSet(routing);
            HashMap<String, Set<String>> routings = Maps.newHashMap();
            for (String index : concreteIndices = this.concreteAllIndices()) {
                routings.put(index, r);
            }
            return routings;
        }
        return null;
    }

    public String[] concreteIndices(String[] indices) throws IndexMissingException {
        return this.concreteIndices(indices, IndicesOptions.fromOptions(false, true, true, true));
    }

    public String[] concreteIndicesIgnoreMissing(String[] indices) {
        return this.concreteIndices(indices, IndicesOptions.fromOptions(true, true, true, false));
    }

    public String[] concreteIndices(String[] aliasesOrIndices, IndicesOptions indicesOptions) throws IndexMissingException {
        if (this.isAllIndices(aliasesOrIndices)) {
            String[] concreteIndices;
            if (indicesOptions.expandWildcardsOpen() && indicesOptions.expandWildcardsClosed()) {
                concreteIndices = this.concreteAllIndices();
            } else if (indicesOptions.expandWildcardsOpen()) {
                concreteIndices = this.concreteAllOpenIndices();
            } else if (indicesOptions.expandWildcardsClosed()) {
                concreteIndices = this.concreteAllClosedIndices();
            } else {
                assert (false) : "Shouldn't end up here";
                concreteIndices = Strings.EMPTY_ARRAY;
            }
            if (!indicesOptions.allowNoIndices() && concreteIndices.length == 0) {
                throw new IndexMissingException(new Index("_all"));
            }
            return concreteIndices;
        }
        if ((aliasesOrIndices = this.convertFromWildcards(aliasesOrIndices, indicesOptions)).length == 1) {
            String aliasOrIndex = aliasesOrIndices[0];
            if (this.indices.containsKey(aliasOrIndex)) {
                return aliasesOrIndices;
            }
            String[] actualLst = this.aliasAndIndexToIndexMap.getOrDefault(aliasOrIndex, Strings.EMPTY_ARRAY);
            if (!indicesOptions.allowNoIndices() && actualLst == null) {
                throw new IndexMissingException(new Index(aliasOrIndex));
            }
            return actualLst;
        }
        boolean possiblyAliased = false;
        for (String index : aliasesOrIndices) {
            if (this.indices.containsKey(index)) continue;
            possiblyAliased = true;
            break;
        }
        if (!possiblyAliased) {
            return aliasesOrIndices;
        }
        HashSet<String> actualIndices = new HashSet<String>();
        for (String index : aliasesOrIndices) {
            String[] actualLst = this.aliasAndIndexToIndexMap.get(index);
            if (actualLst == null) {
                if (indicesOptions.ignoreUnavailable()) continue;
                throw new IndexMissingException(new Index(index));
            }
            for (String x : actualLst) {
                actualIndices.add(x);
            }
        }
        if (!indicesOptions.allowNoIndices() && actualIndices.isEmpty()) {
            throw new IndexMissingException(new Index(Arrays.toString(aliasesOrIndices)));
        }
        return actualIndices.toArray(new String[actualIndices.size()]);
    }

    public String concreteIndex(String index) throws IndexMissingException, ElasticsearchIllegalArgumentException {
        if (this.indices.containsKey(index)) {
            return index;
        }
        Object[] lst = this.aliasAndIndexToIndexMap.get(index);
        if (lst == null) {
            throw new IndexMissingException(new Index(index));
        }
        if (lst.length > 1) {
            throw new ElasticsearchIllegalArgumentException("Alias [" + index + "] has more than one indices associated with it [" + Arrays.toString(lst) + "], can't execute a single index op");
        }
        return lst[0];
    }

    public String[] convertFromWildcards(String[] aliasesOrIndices, IndicesOptions indicesOptions) {
        if (aliasesOrIndices == null) {
            return null;
        }
        HashSet<Object> result = null;
        for (int i = 0; i < aliasesOrIndices.length; ++i) {
            String[] indices;
            String aliasOrIndex = aliasesOrIndices[i];
            if (this.aliasAndIndexToIndexMap.containsKey(aliasOrIndex)) {
                if (result == null) continue;
                result.add(aliasOrIndex);
                continue;
            }
            boolean add = true;
            if (aliasOrIndex.charAt(0) == '+') {
                if (i == 0) {
                    result = new HashSet<String>();
                }
                add = true;
                aliasOrIndex = aliasOrIndex.substring(1);
            } else if (aliasOrIndex.charAt(0) == '-') {
                if (i == 0) {
                    String[] concreteIndices;
                    if (indicesOptions.expandWildcardsOpen() && indicesOptions.expandWildcardsClosed()) {
                        concreteIndices = this.concreteAllIndices();
                    } else if (indicesOptions.expandWildcardsOpen()) {
                        concreteIndices = this.concreteAllOpenIndices();
                    } else if (indicesOptions.expandWildcardsClosed()) {
                        concreteIndices = this.concreteAllClosedIndices();
                    } else {
                        assert (false) : "Shouldn't end up here";
                        concreteIndices = Strings.EMPTY_ARRAY;
                    }
                    result = new HashSet<String>(Arrays.asList(concreteIndices));
                }
                add = false;
                aliasOrIndex = aliasOrIndex.substring(1);
            }
            if (!Regex.isSimpleMatchPattern(aliasOrIndex)) {
                if (!indicesOptions.ignoreUnavailable() && !this.aliasAndIndexToIndexMap.containsKey(aliasOrIndex)) {
                    throw new IndexMissingException(new Index(aliasOrIndex));
                }
                if (result == null) continue;
                if (add) {
                    result.add(aliasOrIndex);
                    continue;
                }
                result.remove(aliasOrIndex);
                continue;
            }
            if (result == null) {
                result = new HashSet();
                result.addAll(Arrays.asList(aliasesOrIndices).subList(0, i));
            }
            if (indicesOptions.expandWildcardsOpen() && indicesOptions.expandWildcardsClosed()) {
                indices = this.concreteAllIndices();
            } else if (indicesOptions.expandWildcardsOpen()) {
                indices = this.concreteAllOpenIndices();
            } else if (indicesOptions.expandWildcardsClosed()) {
                indices = this.concreteAllClosedIndices();
            } else {
                assert (false) : "Shouldn't end up here";
                indices = Strings.EMPTY_ARRAY;
            }
            boolean found = false;
            for (String index : indices) {
                if (!Regex.simpleMatch(aliasOrIndex, index)) continue;
                found = true;
                if (add) {
                    result.add(index);
                    continue;
                }
                result.remove(index);
            }
            for (ObjectCursor cursor : this.aliases.keys()) {
                String alias = (String)cursor.value;
                if (!Regex.simpleMatch(aliasOrIndex, alias)) continue;
                found = true;
                if (add) {
                    result.add(alias);
                    continue;
                }
                result.remove(alias);
            }
            if (found || indicesOptions.allowNoIndices()) continue;
            throw new IndexMissingException(new Index(aliasOrIndex));
        }
        if (result == null) {
            return aliasesOrIndices;
        }
        if (result.isEmpty() && !indicesOptions.allowNoIndices()) {
            throw new IndexMissingException(new Index(Arrays.toString(aliasesOrIndices)));
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasConcreteIndex(String index) {
        return this.aliasAndIndexToIndexMap.containsKey(index);
    }

    public IndexMetaData index(String index) {
        return this.indices.get(index);
    }

    public ImmutableOpenMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableOpenMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfShards() {
        return this.numberOfShards();
    }

    public String[] filteringAliases(String index, String ... indicesOrAliases) {
        if (this.isAllIndices(indicesOrAliases = this.convertFromWildcards(indicesOrAliases, IndicesOptions.lenient()))) {
            return null;
        }
        if (indicesOrAliases.length == 1) {
            boolean filteringRequired;
            String alias = indicesOrAliases[0];
            IndexMetaData indexMetaData = this.indices.get(index);
            if (indexMetaData == null) {
                throw new IndexMissingException(new Index(index));
            }
            AliasMetaData aliasMetaData = indexMetaData.aliases().get(alias);
            boolean bl = filteringRequired = aliasMetaData != null && aliasMetaData.filteringRequired();
            if (!filteringRequired) {
                return null;
            }
            return new String[]{alias};
        }
        ArrayList<String> filteringAliases = null;
        for (String alias : indicesOrAliases) {
            if (alias.equals(index)) {
                return null;
            }
            IndexMetaData indexMetaData = this.indices.get(index);
            if (indexMetaData == null) {
                throw new IndexMissingException(new Index(index));
            }
            AliasMetaData aliasMetaData = indexMetaData.aliases().get(alias);
            if (aliasMetaData == null) continue;
            boolean filteringRequired = aliasMetaData.filteringRequired();
            if (filteringRequired) {
                if (filteringAliases == null) {
                    filteringAliases = Lists.newArrayList();
                }
                filteringAliases.add(alias);
                continue;
            }
            return null;
        }
        if (filteringAliases == null) {
            return null;
        }
        return filteringAliases.toArray(new String[filteringAliases.size()]);
    }

    public boolean isAllIndices(String[] aliasesOrIndices) {
        return aliasesOrIndices == null || aliasesOrIndices.length == 0 || this.isExplicitAllPattern(aliasesOrIndices);
    }

    public boolean isAllTypes(String[] types) {
        return types == null || types.length == 0 || this.isExplicitAllPattern(types);
    }

    public boolean isExplicitAllPattern(String[] aliasesOrIndices) {
        return aliasesOrIndices != null && aliasesOrIndices.length == 1 && "_all".equals(aliasesOrIndices[0]);
    }

    public boolean isPatternMatchingAllIndices(String[] indicesOrAliases, String[] concreteIndices) {
        if (concreteIndices.length == this.concreteAllIndices().length && indicesOrAliases.length > 0) {
            if (indicesOrAliases[0].charAt(0) == '-') {
                return true;
            }
            for (String indexOrAlias : indicesOrAliases) {
                if (!Regex.isSimpleMatchPattern(indexOrAlias)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean routingRequired(String concreteIndex, String type) {
        MappingMetaData mappingMetaData;
        IndexMetaData indexMetaData = this.indices.get(concreteIndex);
        if (indexMetaData != null && (mappingMetaData = indexMetaData.getMappings().get(type)) != null) {
            return mappingMetaData.routing().required();
        }
        return false;
    }

    @Override
    public UnmodifiableIterator<IndexMetaData> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(MetaData metaData1, MetaData metaData2) {
        if (!metaData1.persistentSettings.equals(metaData2.persistentSettings)) {
            return false;
        }
        if (!metaData1.templates.equals(metaData2.templates())) {
            return false;
        }
        int customCount1 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metaData1.customs) {
            if (!customFactories.get(objectObjectCursor.key).isPersistent()) continue;
            if (!objectObjectCursor.equals(metaData2.custom((String)objectObjectCursor.key))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metaData2.customs) {
            if (!customFactories.get(objectObjectCursor.key).isPersistent()) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetaData metaData) {
        return new Builder(metaData);
    }

    static {
        MetaData.registerFactory("repositories", RepositoriesMetaData.FACTORY);
        MetaData.registerFactory("snapshots", SnapshotMetaData.FACTORY);
        MetaData.registerFactory("restore", RestoreMetaData.FACTORY);
        CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA);
        EMPTY_META_DATA = MetaData.builder().build();
    }

    public static class Builder {
        private String uuid;
        private long version;
        private Settings transientSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private Settings persistentSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, IndexMetaData> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetaData> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder() {
            this.uuid = "_na_";
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(MetaData metaData) {
            this.uuid = metaData.uuid;
            this.transientSettings = metaData.transientSettings;
            this.persistentSettings = metaData.persistentSettings;
            this.version = metaData.version;
            this.indices = ImmutableOpenMap.builder(metaData.indices);
            this.templates = ImmutableOpenMap.builder(metaData.templates);
            this.customs = ImmutableOpenMap.builder(metaData.customs);
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            indexMetaDataBuilder.version(indexMetaDataBuilder.version() + 1L);
            IndexMetaData indexMetaData = indexMetaDataBuilder.build();
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public Builder put(IndexMetaData indexMetaData, boolean incrementVersion) {
            if (this.indices.get(indexMetaData.index()) == indexMetaData) {
                return this;
            }
            if (incrementVersion) {
                indexMetaData = IndexMetaData.builder(indexMetaData).version(indexMetaData.version() + 1L).build();
            }
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index) {
            return this.indices.get(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.builder(indexMetaData).settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.builder(indexMetaData).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder generateUuidIfNeeded() {
            if (this.uuid.equals("_na_")) {
                this.uuid = Strings.randomBase64UUID();
            }
            return this;
        }

        public MetaData build() {
            return new MetaData(this.uuid, this.version, this.transientSettings, this.persistentSettings, this.indices.build(), this.templates.build(), this.customs.build());
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            boolean globalPersistentOnly = params.paramAsBoolean(MetaData.GLOBAL_PERSISTENT_ONLY_PARAM, false);
            builder.startObject("meta-data");
            builder.field("version", metaData.version());
            builder.field("uuid", metaData.uuid);
            if (!metaData.persistentSettings().getAsMap().isEmpty()) {
                builder.startObject("settings");
                for (Map.Entry entry : metaData.persistentSettings().getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if (!globalPersistentOnly && !metaData.transientSettings().getAsMap().isEmpty()) {
                builder.startObject("transient_settings");
                for (Map.Entry entry : metaData.transientSettings().getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            builder.startObject("templates");
            for (ObjectCursor<IndexTemplateMetaData> objectCursor : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContent((IndexTemplateMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            if (!globalPersistentOnly && !metaData.indices().isEmpty()) {
                builder.startObject("indices");
                for (IndexMetaData indexMetaData : metaData) {
                    IndexMetaData.Builder.toXContent(indexMetaData, builder, params);
                }
                builder.endObject();
            }
            for (ObjectObjectCursor<String, Custom> objectObjectCursor : metaData.customs()) {
                Custom.Factory<Custom> factory = MetaData.lookupFactorySafe((String)objectObjectCursor.key);
                if (globalPersistentOnly && !factory.isPersistent()) continue;
                builder.startObject((String)objectObjectCursor.key);
                factory.toXContent((Custom)objectObjectCursor.value, builder, params);
                builder.endObject();
            }
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
                if (token == null) {
                    return builder.build();
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(ImmutableSettings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())).build());
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetaData.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    Custom.Factory factory = MetaData.lookupFactory(currentFieldName);
                    if (factory == null) {
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(factory.type(), (Custom)factory.fromXContent(parser));
                    continue;
                }
                if (!token.isValue()) continue;
                if ("version".equals(currentFieldName)) {
                    builder.version = parser.longValue();
                    continue;
                }
                if (!"uuid".equals(currentFieldName)) continue;
                builder.uuid = parser.text();
            }
            return builder.build();
        }

        public static MetaData readFrom(StreamInput in) throws IOException {
            int i;
            Builder builder = new Builder();
            builder.version = in.readLong();
            builder.uuid = in.readString();
            builder.transientSettings(ImmutableSettings.readSettingsFromStream(in));
            builder.persistentSettings(ImmutableSettings.readSettingsFromStream(in));
            int size = in.readVInt();
            for (i = 0; i < size; ++i) {
                builder.put(IndexMetaData.Builder.readFrom(in), false);
            }
            size = in.readVInt();
            for (i = 0; i < size; ++i) {
                builder.put(IndexTemplateMetaData.Builder.readFrom(in));
            }
            int customSize = in.readVInt();
            for (int i2 = 0; i2 < customSize; ++i2) {
                String type = in.readString();
                Object customIndexMetaData = MetaData.lookupFactorySafe(type).readFrom(in);
                builder.putCustom(type, (Custom)customIndexMetaData);
            }
            return builder.build();
        }

        public static void writeTo(MetaData metaData, StreamOutput out) throws IOException {
            out.writeLong(metaData.version);
            out.writeString(metaData.uuid);
            ImmutableSettings.writeSettingsToStream(metaData.transientSettings(), out);
            ImmutableSettings.writeSettingsToStream(metaData.persistentSettings(), out);
            out.writeVInt(metaData.indices.size());
            for (IndexMetaData indexMetaData : metaData) {
                IndexMetaData.Builder.writeTo(indexMetaData, out);
            }
            out.writeVInt(metaData.templates.size());
            for (ObjectCursor objectCursor : metaData.templates.values()) {
                IndexTemplateMetaData.Builder.writeTo((IndexTemplateMetaData)objectCursor.value, out);
            }
            out.writeVInt(metaData.customs().size());
            for (ObjectObjectCursor objectObjectCursor : metaData.customs()) {
                out.writeString((String)objectObjectCursor.key);
                MetaData.lookupFactorySafe((String)objectObjectCursor.key).writeTo((Custom)objectObjectCursor.value, out);
            }
        }
    }

    public static interface Custom {

        public static interface Factory<T extends Custom> {
            public String type();

            public T readFrom(StreamInput var1) throws IOException;

            public void writeTo(T var1, StreamOutput var2) throws IOException;

            public T fromXContent(XContentParser var1) throws IOException;

            public void toXContent(T var1, XContentBuilder var2, ToXContent.Params var3) throws IOException;

            public boolean isPersistent();
        }
    }
}

