/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.query.QuerySearchResult;

public class PercolateShardResponse
extends BroadcastShardOperationResponse {
    private static final BytesRef[] EMPTY_MATCHES = new BytesRef[0];
    private static final float[] EMPTY_SCORES = new float[0];
    private static final List<Map<String, HighlightField>> EMPTY_HL = ImmutableList.of();
    private long count;
    private float[] scores;
    private BytesRef[] matches;
    private List<Map<String, HighlightField>> hls;
    private byte percolatorTypeId;
    private int requestedSize;
    private InternalFacets facets;
    private InternalAggregations aggregations;

    PercolateShardResponse() {
        this.hls = new ArrayList<Map<String, HighlightField>>();
    }

    public PercolateShardResponse(BytesRef[] matches, List<Map<String, HighlightField>> hls, long count, float[] scores, PercolateContext context, String index, int shardId) {
        super(index, shardId);
        this.matches = matches;
        this.hls = hls;
        this.count = count;
        this.scores = scores;
        this.percolatorTypeId = context.percolatorTypeId;
        this.requestedSize = context.size;
        QuerySearchResult result = context.queryResult();
        if (result != null) {
            if (result.facets() != null) {
                this.facets = new InternalFacets(result.facets().facets());
            }
            if (result.aggregations() != null) {
                this.aggregations = (InternalAggregations)result.aggregations();
            }
        }
    }

    public PercolateShardResponse(BytesRef[] matches, long count, float[] scores, PercolateContext context, String index, int shardId) {
        this(matches, EMPTY_HL, count, scores, context, index, shardId);
    }

    public PercolateShardResponse(BytesRef[] matches, List<Map<String, HighlightField>> hls, long count, PercolateContext context, String index, int shardId) {
        this(matches, hls, count, EMPTY_SCORES, context, index, shardId);
    }

    public PercolateShardResponse(long count, PercolateContext context, String index, int shardId) {
        this(EMPTY_MATCHES, EMPTY_HL, count, EMPTY_SCORES, context, index, shardId);
    }

    public PercolateShardResponse(PercolateContext context, String index, int shardId) {
        this(EMPTY_MATCHES, EMPTY_HL, 0L, EMPTY_SCORES, context, index, shardId);
    }

    public BytesRef[] matches() {
        return this.matches;
    }

    public float[] scores() {
        return this.scores;
    }

    public long count() {
        return this.count;
    }

    public int requestedSize() {
        return this.requestedSize;
    }

    public List<Map<String, HighlightField>> hls() {
        return this.hls;
    }

    public InternalFacets facets() {
        return this.facets;
    }

    public InternalAggregations aggregations() {
        return this.aggregations;
    }

    public byte percolatorTypeId() {
        return this.percolatorTypeId;
    }

    public boolean isEmpty() {
        return this.percolatorTypeId == 0;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.percolatorTypeId = in.readByte();
        this.requestedSize = in.readVInt();
        this.count = in.readVLong();
        this.matches = new BytesRef[in.readVInt()];
        for (i = 0; i < this.matches.length; ++i) {
            this.matches[i] = in.readBytesRef();
        }
        this.scores = new float[in.readVInt()];
        for (i = 0; i < this.scores.length; ++i) {
            this.scores[i] = in.readFloat();
        }
        int size = in.readVInt();
        for (int i2 = 0; i2 < size; ++i2) {
            int mSize = in.readVInt();
            HashMap<String, HighlightField> fields = new HashMap<String, HighlightField>();
            for (int j = 0; j < mSize; ++j) {
                fields.put(in.readString(), HighlightField.readHighlightField(in));
            }
            this.hls.add(fields);
        }
        this.facets = InternalFacets.readOptionalFacets(in);
        this.aggregations = InternalAggregations.readOptionalAggregations(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.percolatorTypeId);
        out.writeVLong(this.requestedSize);
        out.writeVLong(this.count);
        out.writeVInt(this.matches.length);
        for (BytesRef match : this.matches) {
            out.writeBytesRef(match);
        }
        out.writeVLong(this.scores.length);
        for (float score : this.scores) {
            out.writeFloat(score);
        }
        out.writeVInt(this.hls.size());
        for (Map<String, HighlightField> hl : this.hls) {
            out.writeVInt(hl.size());
            for (Map.Entry<String, HighlightField> entry : hl.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
        out.writeOptionalStreamable(this.facets);
        out.writeOptionalStreamable(this.aggregations);
    }
}

