/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class SubtitleSampleEntry
extends AbstractSampleEntry {
    public static final String TYPE1 = "stpp";
    private String namespace = "";
    private String schemaLocation = "";
    private String imageMimeType = "";

    public SubtitleSampleEntry() {
        super(TYPE1);
    }

    public long getSize() {
        long s = this.getContainerSize();
        long t = 8 + this.namespace.length() + this.schemaLocation.length() + this.imageMimeType.length() + 3;
        return s + t + (long)(this.largeBox || s + t + 8L >= 0x100000000L ? 16 : 8);
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        dataSource.read((ByteBuffer)byteBuffer.rewind());
        byteBuffer.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
        long start = dataSource.position();
        ByteBuffer content = ByteBuffer.allocate(1024);
        dataSource.read((ByteBuffer)content.rewind());
        this.namespace = IsoTypeReader.readString((ByteBuffer)content.rewind());
        dataSource.position(start + (long)this.namespace.length() + 1L);
        dataSource.read((ByteBuffer)content.rewind());
        this.schemaLocation = IsoTypeReader.readString((ByteBuffer)content.rewind());
        dataSource.position(start + (long)this.namespace.length() + (long)this.schemaLocation.length() + 2L);
        dataSource.read((ByteBuffer)content.rewind());
        this.imageMimeType = IsoTypeReader.readString((ByteBuffer)content.rewind());
        dataSource.position(start + (long)this.namespace.length() + (long)this.schemaLocation.length() + (long)this.imageMimeType.length() + 3L);
        this.parseContainer(dataSource, contentSize - (long)(header.remaining() + this.namespace.length() + this.schemaLocation.length() + this.imageMimeType.length() + 3), boxParser);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + this.namespace.length() + this.schemaLocation.length() + this.imageMimeType.length() + 3);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.namespace);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.schemaLocation);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.imageMimeType);
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getImageMimeType() {
        return this.imageMimeType;
    }

    public void setImageMimeType(String imageMimeType) {
        this.imageMimeType = imageMimeType;
    }
}

