/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ChainsawColumns;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ChainsawCyclicBufferTableModel;
import org.apache.log4j.chainsaw.ChainsawStatusBar;
import org.apache.log4j.chainsaw.DockablePanel;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.ExpressionRuleContext;
import org.apache.log4j.chainsaw.JSortTable;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanelLoggerTreeModel;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.LogPanelPreferencePanel;
import org.apache.log4j.chainsaw.LoggerNameTreePanel;
import org.apache.log4j.chainsaw.LoggingEventWrapper;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.RuleMediator;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.TableColorizingRenderer;
import org.apache.log4j.chainsaw.color.ColorPanel;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.layout.DefaultLayoutFactory;
import org.apache.log4j.chainsaw.layout.EventDetailLayout;
import org.apache.log4j.chainsaw.layout.LayoutEditorPane;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.Profileable;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.xstream.TableColumnConverter;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class LogPanel
extends DockablePanel
implements EventBatchListener,
Profileable {
    private static final DateFormat TIMESTAMP_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final double DEFAULT_DETAIL_SPLIT_LOCATION = 0.71;
    private static final double DEFAULT_LOG_TREE_SPLIT_LOCATION = 0.2;
    private final String identifier;
    private final ChainsawStatusBar statusBar;
    private final JFrame logPanelPreferencesFrame = new JFrame();
    private ColorPanel colorPanel;
    private final JFrame colorFrame = new JFrame();
    private final JFrame undockedFrame;
    private final DockablePanel externalPanel;
    private final Action dockingAction;
    private final JToolBar undockedToolbar;
    private final JSortTable table;
    private final TableColorizingRenderer renderer;
    private final EventContainer tableModel;
    private final JEditorPane detail;
    private final JSplitPane lowerPanel;
    private final DetailPaneUpdater detailPaneUpdater;
    private final JPanel detailPanel = new JPanel(new BorderLayout());
    private final JSplitPane nameTreeAndMainPanelSplit;
    private final LoggerNameTreePanel logTreePanel;
    private final LogPanelPreferenceModel preferenceModel = new LogPanelPreferenceModel();
    private ApplicationPreferenceModel applicationPreferenceModel;
    private final LogPanelPreferencePanel logPanelPreferencesPanel;
    private final FilterModel filterModel = new FilterModel();
    private final RuleColorizer colorizer = new RuleColorizer();
    private final RuleMediator tableRuleMediator = new RuleMediator(false);
    private final RuleMediator searchRuleMediator = new RuleMediator(true);
    private final EventDetailLayout detailLayout = new EventDetailLayout();
    private double lastLogTreePanelSplitLocation = 0.2;
    private Point currentPoint;
    private JTable currentTable;
    private boolean paused = false;
    private Rule findRule;
    private String currentFindRuleText;
    private Rule findMarkerRule;
    private final int dividerSize;
    static final String TABLE_COLUMN_ORDER = "table.columns.order";
    static final String TABLE_COLUMN_WIDTHS = "table.columns.widths";
    static final String COLORS_EXTENSION = ".colors";
    private static final int LOG_PANEL_SERIALIZATION_VERSION_NUMBER = 2;
    private int previousLastIndex = -1;
    private final Logger logger = LogManager.getLogger(LogPanel.class);
    private AutoFilterComboBox filterCombo;
    private AutoFilterComboBox findCombo;
    private JScrollPane eventsPane;
    private int currentSearchMatchCount;
    private Rule clearTableExpressionRule;
    private int lowerPanelDividerLocation;
    private EventContainer searchModel;
    private final JSortTable searchTable;
    private TableColorizingRenderer searchRenderer;
    private ToggleToolTips mainToggleToolTips;
    private ToggleToolTips searchToggleToolTips;
    private JScrollPane detailPane;
    private JScrollPane searchPane;
    private TableCellEditor markerCellEditor;
    private JToolBar detailToolbar;
    private boolean searchResultsDisplayed;
    private ColorizedEventAndSearchMatchThumbnail colorizedEventAndSearchMatchThumbnail;
    private EventTimeDeltaMatchThumbnail eventTimeDeltaMatchThumbnail;
    private boolean isDetailPanelVisible;

    public LogPanel(final ChainsawStatusBar statusBar, String identifier, int cyclicBufferSize, Map<String, RuleColorizer> allColorizers, ApplicationPreferenceModel applicationPreferenceModel) {
        this.identifier = identifier;
        this.statusBar = statusBar;
        this.applicationPreferenceModel = applicationPreferenceModel;
        this.logPanelPreferencesPanel = new LogPanelPreferencePanel(this.preferenceModel, applicationPreferenceModel);
        this.logger.debug((Object)("creating logpanel for " + identifier));
        this.setLayout(new BorderLayout());
        String prototypeValue = "1231231231231231231231";
        this.filterCombo = new AutoFilterComboBox();
        this.findCombo = new AutoFilterComboBox();
        this.filterCombo.setPrototypeDisplayValue(prototypeValue);
        this.buildCombo(this.filterCombo, true, this.findCombo.model);
        this.findCombo.setPrototypeDisplayValue(prototypeValue);
        this.buildCombo(this.findCombo, false, this.filterCombo.model);
        final HashMap<String, String> columnNameKeywordMap = new HashMap<String, String>();
        columnNameKeywordMap.put("CLASS", "CLASS");
        columnNameKeywordMap.put("FILE", "FILE");
        columnNameKeywordMap.put("LEVEL", "LEVEL");
        columnNameKeywordMap.put("LINE", "LINE");
        columnNameKeywordMap.put("LOGGER", "LOGGER");
        columnNameKeywordMap.put("NDC", "NDC");
        columnNameKeywordMap.put("MESSAGE", "MSG");
        columnNameKeywordMap.put("THREAD", "THREAD");
        columnNameKeywordMap.put("THROWABLE", "EXCEPTION");
        columnNameKeywordMap.put("TIMESTAMP", "TIMESTAMP");
        columnNameKeywordMap.put("ID".toUpperCase(), "PROP.log4jid");
        columnNameKeywordMap.put("marker".toUpperCase(), "PROP.marker");
        columnNameKeywordMap.put("millisdelta".toUpperCase(), "PROP.millisdelta");
        this.logPanelPreferencesFrame.setTitle("'" + identifier + "' Log Panel Preferences");
        this.logPanelPreferencesFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        this.logPanelPreferencesFrame.getContentPane().add(new JScrollPane(this.logPanelPreferencesPanel));
        this.logPanelPreferencesFrame.setSize(740, 520);
        this.logPanelPreferencesPanel.setOkCancelActionListener(e -> this.logPanelPreferencesFrame.setVisible(false));
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction closeLogPanelPreferencesFrameAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.logPanelPreferencesFrame.setVisible(false);
            }
        };
        this.logPanelPreferencesFrame.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.logPanelPreferencesFrame.getRootPane().getActionMap().put("ESCAPE", closeLogPanelPreferencesFrameAction);
        this.setDetailPaneConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
        this.detailLayout.setConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
        this.undockedFrame = new JFrame(identifier);
        this.undockedFrame.setDefaultCloseOperation(0);
        if (ChainsawIcons.UNDOCKED_ICON != null) {
            this.undockedFrame.setIconImage(new ImageIcon(ChainsawIcons.UNDOCKED_ICON).getImage());
        }
        this.externalPanel = new DockablePanel();
        this.externalPanel.setLayout(new BorderLayout());
        this.undockedFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogPanel.this.dock();
            }
        });
        this.undockedToolbar = this.createDockwindowToolbar();
        this.externalPanel.add((Component)this.undockedToolbar, "North");
        this.undockedFrame.getContentPane().add(this.externalPanel);
        this.undockedFrame.setSize(new Dimension(1024, 768));
        this.undockedFrame.pack();
        this.preferenceModel.addPropertyChangeListener("scrollToBottom", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            if (value) {
                this.scrollToBottom();
            }
        });
        final JPopupMenu dateFormatChangePopup = new JPopupMenu();
        final JRadioButtonMenuItem isoButton = new JRadioButtonMenuItem(new AbstractAction("Use ISO8601Format"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.preferenceModel.setDateFormatPattern("ISO8601");
            }
        });
        final JRadioButtonMenuItem simpleTimeButton = new JRadioButtonMenuItem(new AbstractAction("Use simple time"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.preferenceModel.setDateFormatPattern("HH:mm:ss");
            }
        });
        ButtonGroup dfBG = new ButtonGroup();
        dfBG.add(isoButton);
        dfBG.add(simpleTimeButton);
        simpleTimeButton.setSelected(true);
        dateFormatChangePopup.add(isoButton);
        dateFormatChangePopup.add(simpleTimeButton);
        JCheckBoxMenuItem menuItemLoggerTree = new JCheckBoxMenuItem("Show Logger Tree");
        menuItemLoggerTree.addActionListener(e -> this.preferenceModel.setLogTreePanelVisible(menuItemLoggerTree.isSelected()));
        menuItemLoggerTree.setIcon(new ImageIcon(ChainsawIcons.WINDOW_ICON));
        JCheckBoxMenuItem menuItemToggleDetails = new JCheckBoxMenuItem("Show Detail Pane");
        menuItemToggleDetails.addActionListener(e -> this.preferenceModel.setDetailPaneVisible(menuItemToggleDetails.isSelected()));
        menuItemToggleDetails.setIcon(new ImageIcon(ChainsawIcons.INFO));
        this.preferenceModel.addPropertyChangeListener("levelIcons", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean useIcons = (Boolean)evt.getNewValue();
                LogPanel.this.renderer.setLevelUseIcons(useIcons);
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
                LogPanel.this.searchRenderer.setLevelUseIcons(useIcons);
                LogPanel.this.searchTable.tableChanged(new TableModelEvent(LogPanel.this.searchModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("wrapMessage", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean wrap = (Boolean)evt.getNewValue();
                LogPanel.this.renderer.setWrapMessage(wrap);
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
                LogPanel.this.searchRenderer.setWrapMessage(wrap);
                LogPanel.this.searchTable.tableChanged(new TableModelEvent(LogPanel.this.searchModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("searchResultsVisible", evt -> {
            boolean displaySearchResultsInDetailsIfAvailable = (Boolean)evt.getNewValue();
            if (displaySearchResultsInDetailsIfAvailable) {
                this.showSearchResults();
            } else {
                this.hideSearchResults();
            }
        });
        this.preferenceModel.addPropertyChangeListener("highlightSearchMatchText", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean highlightText = (Boolean)evt.getNewValue();
                LogPanel.this.renderer.setHighlightSearchMatchText(highlightText);
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
                LogPanel.this.searchRenderer.setHighlightSearchMatchText(highlightText);
                LogPanel.this.searchTable.tableChanged(new TableModelEvent(LogPanel.this.searchModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("detailPaneVisible", evt -> {
            boolean detailPaneVisible = (Boolean)evt.getNewValue();
            if (detailPaneVisible) {
                this.showDetailPane();
            } else if (!this.searchResultsDisplayed) {
                this.hideDetailPane();
            }
        });
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", evt -> {
            boolean newValue = (Boolean)evt.getNewValue();
            if (newValue) {
                this.showLogTreePanel();
            } else {
                this.hideLogTreePanel();
            }
        });
        this.preferenceModel.addPropertyChangeListener("toolTips", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean toolTips = (Boolean)evt.getNewValue();
                LogPanel.this.renderer.setToolTipsVisible(toolTips);
                LogPanel.this.searchRenderer.setToolTipsVisible(toolTips);
            }
        });
        this.preferenceModel.addPropertyChangeListener("visibleColumns", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableColumnModel columnModel = LogPanel.this.table.getColumnModel();
                while (columnModel.getColumnCount() > 0) {
                    columnModel.removeColumn(columnModel.getColumn(0));
                }
                for (Object o1 : LogPanel.this.preferenceModel.getVisibleColumnOrder()) {
                    TableColumn c = (TableColumn)o1;
                    if (c.getHeaderValue().toString().equalsIgnoreCase("marker")) {
                        c.setCellEditor(LogPanel.this.markerCellEditor);
                    }
                    columnModel.addColumn(c);
                }
                TableColumnModel searchColumnModel = LogPanel.this.searchTable.getColumnModel();
                while (searchColumnModel.getColumnCount() > 0) {
                    searchColumnModel.removeColumn(searchColumnModel.getColumn(0));
                }
                for (Object o : LogPanel.this.preferenceModel.getVisibleColumnOrder()) {
                    TableColumn c = (TableColumn)o;
                    searchColumnModel.addColumn(c);
                }
            }
        });
        PropertyChangeListener datePrefsChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LogPanelPreferenceModel model = (LogPanelPreferenceModel)evt.getSource();
                isoButton.setSelected(model.isUseISO8601Format());
                simpleTimeButton.setSelected(!model.isUseISO8601Format() && !model.isCustomDateFormat());
                if (model.getTimeZone() != null) {
                    LogPanel.this.renderer.setTimeZone(model.getTimeZone());
                    LogPanel.this.searchRenderer.setTimeZone(model.getTimeZone());
                }
                if (model.isUseISO8601Format()) {
                    LogPanel.this.renderer.setDateFormatter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS"));
                    LogPanel.this.searchRenderer.setDateFormatter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS"));
                } else {
                    try {
                        LogPanel.this.renderer.setDateFormatter(new SimpleDateFormat(model.getDateFormatPattern()));
                    }
                    catch (IllegalArgumentException iae) {
                        model.setDefaultDatePatternFormat();
                        LogPanel.this.renderer.setDateFormatter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS"));
                    }
                    try {
                        LogPanel.this.searchRenderer.setDateFormatter(new SimpleDateFormat(model.getDateFormatPattern()));
                    }
                    catch (IllegalArgumentException iae) {
                        model.setDefaultDatePatternFormat();
                        LogPanel.this.searchRenderer.setDateFormatter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS"));
                    }
                }
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
                LogPanel.this.searchTable.tableChanged(new TableModelEvent(LogPanel.this.searchModel));
            }
        };
        this.preferenceModel.addPropertyChangeListener("dateFormatPattern", datePrefsChangeListener);
        this.preferenceModel.addPropertyChangeListener("dateFormatTimeZone", datePrefsChangeListener);
        this.preferenceModel.addPropertyChangeListener("clearTableExpression", evt -> {
            LogPanelPreferenceModel model = (LogPanelPreferenceModel)evt.getSource();
            String expression = model.getClearTableExpression();
            try {
                this.clearTableExpressionRule = ExpressionRule.getRule((String)expression);
                this.logger.info((Object)("clearTableExpressionRule set to: " + expression));
            }
            catch (Exception e) {
                this.logger.info((Object)("clearTableExpressionRule invalid - ignoring: " + expression));
                this.clearTableExpressionRule = null;
            }
        });
        this.preferenceModel.addPropertyChangeListener("loggerPrecision", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LogPanelPreferenceModel model = (LogPanelPreferenceModel)evt.getSource();
                LogPanel.this.renderer.setLoggerPrecision(model.getLoggerPrecision());
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
                LogPanel.this.searchRenderer.setLoggerPrecision(model.getLoggerPrecision());
                LogPanel.this.searchTable.tableChanged(new TableModelEvent(LogPanel.this.searchModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("toolTips", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            this.searchToggleToolTips.setSelected(value);
            this.mainToggleToolTips.setSelected(value);
        });
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            menuItemLoggerTree.setSelected(value);
        });
        this.preferenceModel.addPropertyChangeListener("detailPaneVisible", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            menuItemToggleDetails.setSelected(value);
        });
        applicationPreferenceModel.addPropertyChangeListener("searchColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LogPanel.this.table != null) {
                    LogPanel.this.table.repaint();
                }
                if (LogPanel.this.searchTable != null) {
                    LogPanel.this.searchTable.repaint();
                }
            }
        });
        applicationPreferenceModel.addPropertyChangeListener("alternatingColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LogPanel.this.table != null) {
                    LogPanel.this.table.repaint();
                }
                if (LogPanel.this.searchTable != null) {
                    LogPanel.this.searchTable.repaint();
                }
            }
        });
        this.tableModel = new ChainsawCyclicBufferTableModel(cyclicBufferSize, this.colorizer, "main");
        this.table = new JSortTable(this.tableModel);
        this.markerCellEditor = new MarkerCellEditor();
        this.table.setName("main");
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.searchModel = new ChainsawCyclicBufferTableModel(cyclicBufferSize, this.colorizer, "search");
        this.searchTable = new JSortTable(this.searchModel);
        this.searchTable.setName("search");
        this.searchTable.setColumnSelectionAllowed(false);
        this.searchTable.setRowSelectionAllowed(true);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke("F2"), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(113, 1), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(113, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(113, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "none");
        this.searchTable.getInputMap(1).put(KeyStroke.getKeyStroke("F2"), "none");
        this.searchTable.getInputMap(1).put(KeyStroke.getKeyStroke(113, 1), "none");
        this.searchTable.getInputMap(1).put(KeyStroke.getKeyStroke(113, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "none");
        this.searchTable.getInputMap(1).put(KeyStroke.getKeyStroke(113, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1), "none");
        this.searchTable.getInputMap(1).put(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "none");
        this.tableModel.addNewKeyListener(e -> columnNameKeywordMap.put((String)e.getKey(), "PROP." + e.getKey()));
        this.tableModel.setRuleMediator(this.tableRuleMediator);
        this.searchModel.setRuleMediator(this.searchRuleMediator);
        this.tableModel.addEventCountListener((currentCount, totalCount) -> {
            if (this.isVisible()) {
                statusBar.setSelectedLine(this.table.getSelectedRow() + 1, currentCount, totalCount, this.getIdentifier());
            }
        });
        this.tableModel.addEventCountListener(new EventCountListener(){
            final NumberFormat formatter = NumberFormat.getPercentInstance();
            boolean warning75 = false;
            boolean warning100 = false;

            @Override
            public void eventCountChanged(int currentCount, int totalCount) {
                if (LogPanel.this.preferenceModel.isCyclic()) {
                    Object msg;
                    boolean wasWarning;
                    double percent = (double)totalCount / (double)LogPanel.this.tableModel.getMaxSize();
                    boolean bl = wasWarning = this.warning75 || this.warning100;
                    if (percent > 0.75 && percent < 1.0 && !this.warning75) {
                        msg = "Warning :: " + this.formatter.format(percent) + " of the '" + LogPanel.this.getIdentifier() + "' buffer has been used";
                        this.warning75 = true;
                    } else if (percent >= 1.0 && !this.warning100) {
                        msg = "Warning :: " + this.formatter.format(percent) + " of the '" + LogPanel.this.getIdentifier() + "' buffer has been used.  Older events are being discarded.";
                        this.warning100 = true;
                    } else {
                        msg = "";
                        this.warning75 = false;
                        this.warning100 = false;
                    }
                    if (msg != null && wasWarning) {
                        MessageCenter.getInstance().getLogger().info(msg);
                    }
                }
            }
        });
        LogPanelLoggerTreeModel logTreeModel = new LogPanelLoggerTreeModel();
        this.logTreePanel = new LoggerNameTreePanel(logTreeModel, this.preferenceModel, this, this.colorizer, this.filterModel);
        this.logTreePanel.getLoggerVisibilityRule().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("searchExpression")) {
                this.findCombo.setSelectedItem(evt.getNewValue().toString());
                this.findNext();
            }
        });
        this.tableModel.addLoggerNameListener(logTreeModel);
        this.tableModel.addLoggerNameListener(this.logTreePanel);
        this.tableRuleMediator.setLoggerRule(this.logTreePanel.getLoggerVisibilityRule());
        this.searchRuleMediator.setLoggerRule(this.logTreePanel.getLoggerVisibilityRule());
        this.colorizer.setLoggerRule(this.logTreePanel.getLoggerColorRule());
        this.colorFrame.setTitle("'" + identifier + "' color settings");
        this.colorFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        allColorizers.put(identifier, this.colorizer);
        this.colorPanel = new org.apache.log4j.chainsaw.color.ColorPanel(this.colorizer, this.filterModel, allColorizers, applicationPreferenceModel);
        this.colorFrame.getContentPane().add(this.colorPanel);
        AbstractAction closeColorPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.colorPanel.hidePanel();
            }
        };
        this.colorFrame.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.colorFrame.getRootPane().getActionMap().put("ESCAPE", closeColorPanelAction);
        this.colorPanel.setCloseActionListener(e -> this.colorFrame.setVisible(false));
        this.colorizer.addPropertyChangeListener("colorrule", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (Object o : LogPanel.this.tableModel.getAllEvents()) {
                    LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)o;
                    loggingEventWrapper.updateColorRuleColors(LogPanel.this.colorizer.getBackgroundColor(loggingEventWrapper.getLoggingEvent()), LogPanel.this.colorizer.getForegroundColor(loggingEventWrapper.getLoggingEvent()));
                }
                LogPanel.this.colorizedEventAndSearchMatchThumbnail.configureColors();
                LogPanel.this.lowerPanel.revalidate();
                LogPanel.this.lowerPanel.repaint();
                LogPanel.this.searchTable.revalidate();
                LogPanel.this.searchTable.repaint();
            }
        });
        this.table.setRowHeight(20);
        this.table.setRowMargin(0);
        this.table.getColumnModel().setColumnMargin(0);
        this.table.setShowGrid(false);
        this.table.getColumnModel().addColumnModelListener(new ChainsawTableColumnModelListener(this.table));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.addMouseMotionListener(new TableColumnDetailMouseListener(this.table, this.tableModel));
        this.table.addMouseListener(new TableMarkerListener(this.table, this.tableModel, this.searchModel));
        this.table.setAutoResizeMode(0);
        this.searchTable.setRowHeight(20);
        this.searchTable.setRowMargin(0);
        this.searchTable.getColumnModel().setColumnMargin(0);
        this.searchTable.setShowGrid(false);
        this.searchTable.getColumnModel().addColumnModelListener(new ChainsawTableColumnModelListener(this.searchTable));
        this.searchTable.setAutoCreateColumnsFromModel(false);
        this.searchTable.addMouseMotionListener(new TableColumnDetailMouseListener(this.searchTable, this.searchModel));
        this.searchTable.addMouseListener(new TableMarkerListener(this.searchTable, this.searchModel, this.tableModel));
        this.searchTable.setAutoResizeMode(0);
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                JEditorPane jEditorPane = LogPanel.this.detail;
                synchronized (jEditorPane) {
                    LogPanel.this.table.getSelectionModel().setValueIsAdjusting(true);
                    LogPanel.this.detail.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyReleased(KeyEvent e) {
                JEditorPane jEditorPane = LogPanel.this.detail;
                synchronized (jEditorPane) {
                    LogPanel.this.table.getSelectionModel().setValueIsAdjusting(false);
                    LogPanel.this.detail.notify();
                }
            }
        });
        this.table.setSelectionMode(0);
        this.searchTable.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(evt -> {
            boolean disableScrollToBottom;
            if (evt.getFirstIndex() == evt.getLastIndex() && evt.getFirstIndex() > 0 && this.previousLastIndex != -1 || evt.getValueIsAdjusting()) {
                return;
            }
            boolean lastIndexOnLastRow = evt.getLastIndex() == this.table.getRowCount() - 1;
            boolean lastIndexSame = this.previousLastIndex == evt.getLastIndex();
            boolean bl = disableScrollToBottom = lastIndexOnLastRow && lastIndexSame && this.previousLastIndex != evt.getFirstIndex();
            if (disableScrollToBottom && this.isScrollToBottom() && this.table.getRowCount() > 0) {
                this.preferenceModel.setScrollToBottom(false);
            }
            this.previousLastIndex = evt.getLastIndex();
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getFirstIndex() == evt.getLastIndex() && evt.getFirstIndex() > 0 && LogPanel.this.previousLastIndex != -1 || evt.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)evt.getSource();
                if (lsm.isSelectionEmpty()) {
                    if (LogPanel.this.isVisible()) {
                        statusBar.setNothingSelected();
                    }
                    if (LogPanel.this.detail.getDocument().getDefaultRootElement() != null) {
                        LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                    }
                } else if (LogPanel.this.table.getSelectedRow() > -1) {
                    int selectedRow = LogPanel.this.table.getSelectedRow();
                    if (LogPanel.this.isVisible()) {
                        LogPanel.this.updateStatusBar();
                    }
                    try {
                        if (LogPanel.this.tableModel.getRowCount() >= selectedRow) {
                            LogPanel.this.detailPaneUpdater.setSelectedRow(LogPanel.this.table.getSelectedRow());
                        } else {
                            LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                    }
                }
            }
        });
        this.renderer = new TableColorizingRenderer(this.colorizer, applicationPreferenceModel, this.tableModel, this.preferenceModel, true);
        this.renderer.setToolTipsVisible(this.preferenceModel.isToolTips());
        this.table.setDefaultRenderer(Object.class, this.renderer);
        this.searchRenderer = new TableColorizingRenderer(this.colorizer, applicationPreferenceModel, this.searchModel, this.preferenceModel, false);
        this.searchRenderer.setToolTipsVisible(this.preferenceModel.isToolTips());
        this.searchTable.setDefaultRenderer(Object.class, this.searchRenderer);
        this.table.addMouseListener(new ThrowableDisplayMouseAdapter(this.table, this.tableModel));
        this.searchTable.addMouseListener(new ThrowableDisplayMouseAdapter(this.searchTable, this.searchModel));
        this.searchTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LoggingEventWrapper loggingEventWrapper = LogPanel.this.searchModel.getRow(LogPanel.this.searchTable.getSelectedRow());
                if (loggingEventWrapper != null) {
                    int id = new Integer(loggingEventWrapper.getLoggingEvent().getProperty("log4jid"));
                    LogPanel.this.setSelectedEvent(id);
                }
            }
        });
        this.tableModel.addNewKeyListener(e -> SwingHelper.invokeOnEDT(() -> {
            try {
                if (this.table.getColumn(e.getKey()) != null) {
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            TableColumn col = new TableColumn(e.getNewModelIndex());
            col.setHeaderValue(e.getKey());
            if (this.preferenceModel.addColumn(col) && (this.preferenceModel.isColumnVisible(col) || !applicationPreferenceModel.isDefaultColumnsSet() || applicationPreferenceModel.isDefaultColumnsSet() && applicationPreferenceModel.getDefaultColumnNames().contains(col.getHeaderValue()))) {
                this.table.addColumn(col);
                this.searchTable.addColumn(col);
                this.preferenceModel.setColumnVisible(e.getKey().toString(), true);
            }
        }));
        this.tableModel.addPropertyChangeListener("refilter", new PropertyChangeListener(){
            private LoggingEventWrapper currentEvent;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    int currentRow = LogPanel.this.table.getSelectedRow();
                    if (currentRow > -1) {
                        this.currentEvent = LogPanel.this.tableModel.getRow(currentRow);
                    }
                } else if (this.currentEvent != null) {
                    LogPanel.this.table.scrollToRow(LogPanel.this.tableModel.getRowIndex(this.currentEvent));
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.checkEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkEvent(e);
            }

            private void checkEvent(MouseEvent e) {
                int index;
                TableColumnModel colModel;
                int modelIndex;
                if (e.isPopupTrigger() && (modelIndex = (colModel = LogPanel.this.table.getColumnModel()).getColumn(index = colModel.getColumnIndexAtX(e.getX())).getModelIndex()) + 1 == 3) {
                    dateFormatChangePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BoxLayout(upperPanel, 0));
        upperPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        JLabel filterLabel = new JLabel("Refine focus on: ");
        filterLabel.setFont(filterLabel.getFont().deriveFont(1));
        upperPanel.add(filterLabel);
        upperPanel.add(Box.createHorizontalStrut(3));
        upperPanel.add(this.filterCombo);
        upperPanel.add(Box.createHorizontalStrut(3));
        final JTextField filterText = (JTextField)this.filterCombo.getEditor().getEditorComponent();
        final JTextField findText = (JTextField)this.findCombo.getEditor().getEditorComponent();
        final JButton removeFilterButton = new JButton(" Remove ");
        removeFilterButton.setToolTipText("Click here to remove the selected expression from the list");
        removeFilterButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = LogPanel.this.filterCombo.getSelectedItem();
                if (e.getSource() == removeFilterButton && selectedItem != null && !selectedItem.toString().trim().equals("")) {
                    int index = LogPanel.this.filterCombo.getSelectedIndex();
                    filterText.setText(null);
                    LogPanel.this.filterCombo.setSelectedIndex(-1);
                    LogPanel.this.filterCombo.removeItemAt(index);
                    if (LogPanel.this.findCombo.getSelectedItem() == null || !LogPanel.this.findCombo.getSelectedItem().equals(selectedItem)) {
                        ((AutoFilterComboBox.AutoFilterComboBoxModel)LogPanel.this.findCombo.getModel()).removeElement(selectedItem);
                    }
                }
            }
        });
        upperPanel.add(removeFilterButton);
        upperPanel.add(Box.createHorizontalStrut(25));
        JLabel findLabel = new JLabel("Find: ");
        findLabel.setFont(filterLabel.getFont().deriveFont(1));
        upperPanel.add(findLabel);
        upperPanel.add(Box.createHorizontalStrut(3));
        upperPanel.add(this.findCombo);
        upperPanel.add(Box.createHorizontalStrut(3));
        Action findNextAction = this.getFindNextAction();
        Action findPreviousAction = this.getFindPreviousAction();
        SmallButton findNextButton = new SmallButton(findNextAction);
        findNextButton.setText("");
        findNextButton.getActionMap().put(findNextAction.getValue("Name"), findNextAction);
        findNextButton.getInputMap(2).put((KeyStroke)findNextAction.getValue("AcceleratorKey"), findNextAction.getValue("Name"));
        SmallButton findPreviousButton = new SmallButton(findPreviousAction);
        findPreviousButton.setText("");
        findPreviousButton.getActionMap().put(findPreviousAction.getValue("Name"), findPreviousAction);
        findPreviousButton.getInputMap(2).put((KeyStroke)findPreviousAction.getValue("AcceleratorKey"), findPreviousAction.getValue("Name"));
        upperPanel.add(findNextButton);
        upperPanel.add(findPreviousButton);
        upperPanel.add(Box.createHorizontalStrut(3));
        final JButton removeFindButton = new JButton(" Remove ");
        removeFindButton.setToolTipText("Click here to remove the selected expression from the list");
        removeFindButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = LogPanel.this.findCombo.getSelectedItem();
                if (e.getSource() == removeFindButton && selectedItem != null && !selectedItem.toString().trim().equals("")) {
                    int index = LogPanel.this.findCombo.getSelectedIndex();
                    findText.setText(null);
                    LogPanel.this.findCombo.setSelectedIndex(-1);
                    LogPanel.this.findCombo.removeItemAt(index);
                    if (LogPanel.this.filterCombo.getSelectedItem() == null || !LogPanel.this.filterCombo.getSelectedItem().equals(selectedItem)) {
                        ((AutoFilterComboBox.AutoFilterComboBoxModel)LogPanel.this.filterCombo.getModel()).removeElement(selectedItem);
                    }
                }
            }
        });
        upperPanel.add(removeFindButton);
        AbstractAction findFocusAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.findCombo.requestFocus();
            }
        };
        AbstractAction filterFocusAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.filterCombo.requestFocus();
            }
        };
        AbstractAction findClearAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.findCombo.setSelectedIndex(-1);
                LogPanel.this.findNext();
            }
        };
        AbstractAction filterClearAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.setRefineFocusText("");
                LogPanel.this.filterCombo.refilter();
            }
        };
        KeyStroke ksFindFocus = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ksFilterFocus = KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ksFindClear = KeyStroke.getKeyStroke(70, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ksFilterClear = KeyStroke.getKeyStroke(82, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(ksFindFocus, "FindFocus");
        this.getInputMap(2).put(ksFilterFocus, "FilterFocus");
        this.getInputMap(2).put(ksFindClear, "FindClear");
        this.getInputMap(2).put(ksFilterClear, "FilterClear");
        this.getActionMap().put("FindFocus", findFocusAction);
        this.getActionMap().put("FilterFocus", filterFocusAction);
        this.getActionMap().put("FindClear", findClearAction);
        this.getActionMap().put("FilterClear", filterClearAction);
        this.detail = new JEditorPane("text/html", "");
        this.detail.setEditable(false);
        this.detailPaneUpdater = new DetailPaneUpdater();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                LogPanel.this.detailPaneUpdater.updateDetailPane();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.findMarkerRule = ExpressionRule.getRule((String)"prop.marker exists");
        this.tableModel.addTableModelListener(e -> {
            int currentRow = this.table.getSelectedRow();
            if (e.getFirstRow() <= currentRow && e.getLastRow() >= currentRow) {
                this.detailPaneUpdater.setAndUpdateSelectedRow(this.table.getSelectedRow());
            }
        });
        this.addPropertyChangeListener("detailPaneConversionPattern", this.detailPaneUpdater);
        this.searchPane = new JScrollPane(this.searchTable);
        this.searchPane.getVerticalScrollBar().setUnitIncrement(40);
        this.searchPane.setPreferredSize(new Dimension(900, 50));
        this.detailPane = new JScrollPane(this.detail);
        this.detailPane.setPreferredSize(new Dimension(900, 50));
        this.detailPanel.add((Component)this.detailPane, "Center");
        JPanel eventsAndStatusPanel = new JPanel(new BorderLayout());
        this.eventsPane = new JScrollPane(this.table);
        this.eventsPane.getVerticalScrollBar().setUnitIncrement(40);
        eventsAndStatusPanel.add((Component)this.eventsPane, "Center");
        Integer scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        JPanel rightThumbNailPanel = new JPanel();
        rightThumbNailPanel.setLayout(new BoxLayout(rightThumbNailPanel, 1));
        rightThumbNailPanel.add(Box.createVerticalStrut(scrollBarWidth));
        this.colorizedEventAndSearchMatchThumbnail = new ColorizedEventAndSearchMatchThumbnail();
        rightThumbNailPanel.add(this.colorizedEventAndSearchMatchThumbnail);
        rightThumbNailPanel.add(Box.createVerticalStrut(scrollBarWidth));
        rightPanel.add(rightThumbNailPanel);
        if (scrollBarWidth != null) {
            rightThumbNailPanel.setPreferredSize(new Dimension(scrollBarWidth - 4, -1));
        }
        eventsAndStatusPanel.add((Component)rightPanel, "East");
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel leftThumbNailPanel = new JPanel();
        leftThumbNailPanel.setLayout(new BoxLayout(leftThumbNailPanel, 1));
        leftThumbNailPanel.add(Box.createVerticalStrut(scrollBarWidth));
        this.eventTimeDeltaMatchThumbnail = new EventTimeDeltaMatchThumbnail();
        leftThumbNailPanel.add(this.eventTimeDeltaMatchThumbnail);
        leftThumbNailPanel.add(Box.createVerticalStrut(scrollBarWidth));
        leftPanel.add(leftThumbNailPanel);
        if (scrollBarWidth != null) {
            leftThumbNailPanel.setPreferredSize(new Dimension(scrollBarWidth - 4, -1));
        }
        eventsAndStatusPanel.add((Component)leftPanel, "West");
        JPanel statusLabelPanel = new JPanel();
        statusLabelPanel.setLayout(new BorderLayout());
        statusLabelPanel.add((Component)upperPanel, "Center");
        eventsAndStatusPanel.add((Component)statusLabelPanel, "North");
        this.detailToolbar = new JToolBar(0);
        this.detailToolbar.setFloatable(false);
        final LayoutEditorPane layoutEditorPane = new LayoutEditorPane();
        final JDialog layoutEditorDialog = new JDialog((Frame)null, "Pattern Editor");
        layoutEditorDialog.getContentPane().add(layoutEditorPane);
        layoutEditorDialog.setSize(640, 480);
        layoutEditorPane.addCancelActionListener(e -> layoutEditorDialog.setVisible(false));
        layoutEditorPane.addOkActionListener(e -> {
            this.setDetailPaneConversionPattern(layoutEditorPane.getConversionPattern());
            layoutEditorDialog.setVisible(false);
        });
        AbstractAction copyToRefineFocusAction = new AbstractAction("Set 'refine focus' field"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedText = LogPanel.this.detail.getSelectedText();
                if (selectedText == null || selectedText.equals("")) {
                    return;
                }
                filterText.setText("msg ~= '" + selectedText + "'");
            }
        };
        AbstractAction copyToSearchAction = new AbstractAction("Find next"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedText = LogPanel.this.detail.getSelectedText();
                if (selectedText == null || selectedText.equals("")) {
                    return;
                }
                LogPanel.this.findCombo.setSelectedItem("msg ~= '" + selectedText + "'");
                LogPanel.this.findNext();
            }
        };
        AbstractAction editDetailAction = new AbstractAction("Edit...", new ImageIcon(ChainsawIcons.ICON_EDIT_RECEIVER)){

            @Override
            public void actionPerformed(ActionEvent e) {
                layoutEditorPane.setConversionPattern(LogPanel.this.getDetailPaneConversionPattern());
                Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                Point p = new Point((int)(size.getWidth() / 2.0 - layoutEditorDialog.getSize().getWidth() / 2.0), (int)(size.getHeight() / 2.0 - layoutEditorDialog.getSize().getHeight() / 2.0));
                layoutEditorDialog.setLocation(p);
                layoutEditorDialog.setVisible(true);
            }
        };
        editDetailAction.putValue("ShortDescription", "opens a Dialog window to Edit the Pattern Layout text");
        SmallButton editDetailButton = new SmallButton(editDetailAction);
        editDetailButton.setText(null);
        this.detailToolbar.add(Box.createHorizontalGlue());
        this.detailToolbar.add(editDetailButton);
        this.detailToolbar.addSeparator();
        this.detailToolbar.add(Box.createHorizontalStrut(5));
        AbstractAction closeDetailAction = new AbstractAction(null, LineIconFactory.createCloseIcon()){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.preferenceModel.setDetailPaneVisible(false);
            }
        };
        closeDetailAction.putValue("ShortDescription", "Hides the Detail Panel");
        SmallButton closeDetailButton = new SmallButton(closeDetailAction);
        this.detailToolbar.add(closeDetailButton);
        this.detailPanel.add((Component)this.detailToolbar, "North");
        this.lowerPanel = new JSplitPane(0, eventsAndStatusPanel, this.detailPanel);
        this.dividerSize = this.lowerPanel.getDividerSize();
        this.lowerPanel.setDividerLocation(-1);
        this.lowerPanel.setResizeWeight(1.0);
        this.lowerPanel.setBorder(null);
        this.lowerPanel.setContinuousLayout(true);
        JPopupMenu editDetailPopupMenu = new JPopupMenu();
        editDetailPopupMenu.add(copyToRefineFocusAction);
        editDetailPopupMenu.add(copyToSearchAction);
        editDetailPopupMenu.addSeparator();
        editDetailPopupMenu.add(editDetailAction);
        editDetailPopupMenu.addSeparator();
        ButtonGroup layoutGroup = new ButtonGroup();
        JRadioButtonMenuItem defaultLayoutRadio = new JRadioButtonMenuItem(new AbstractAction("Set to Default Layout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.setDetailPaneConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
            }
        });
        JRadioButtonMenuItem fullLayoutRadio = new JRadioButtonMenuItem(new AbstractAction("Set to Full Layout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.setDetailPaneConversionPattern(DefaultLayoutFactory.getFullPatternLayout());
            }
        });
        editDetailPopupMenu.add(defaultLayoutRadio);
        editDetailPopupMenu.add(fullLayoutRadio);
        layoutGroup.add(defaultLayoutRadio);
        layoutGroup.add(fullLayoutRadio);
        defaultLayoutRadio.setSelected(true);
        JRadioButtonMenuItem tccLayoutRadio = new JRadioButtonMenuItem(new AbstractAction("Set to TCCLayout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.setDetailPaneConversionPattern("%r [%t] %p %c %x - %m%n");
            }
        });
        editDetailPopupMenu.add(tccLayoutRadio);
        layoutGroup.add(tccLayoutRadio);
        PopupListener editDetailPopupListener = new PopupListener(editDetailPopupMenu);
        this.detail.addMouseListener(editDetailPopupListener);
        this.nameTreeAndMainPanelSplit = new JSplitPane(1, this.logTreePanel, this.lowerPanel);
        this.nameTreeAndMainPanelSplit.setDividerLocation(-1);
        this.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        if (this.isLogTreeVisible()) {
            this.showLogTreePanel();
        } else {
            this.hideLogTreePanel();
        }
        JPopupMenu mainPopup = new JPopupMenu();
        JPopupMenu searchPopup = new JPopupMenu();
        JMenuItem menuItemToggleDock = new JMenuItem("Undock/dock");
        this.dockingAction = new AbstractAction("Undock"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LogPanel.this.isDocked()) {
                    LogPanel.this.undock();
                } else {
                    LogPanel.this.dock();
                }
            }
        };
        this.dockingAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UNDOCK));
        menuItemToggleDock.setAction(this.dockingAction);
        class FocusOn
        extends JMenuItem {
            public FocusOn() {
                super("Set 'refine focus' field to value under pointer");
                this.addActionListener(evt -> {
                    if (LogPanel.this.currentPoint != null) {
                        String operator = "==";
                        int column = LogPanel.this.currentTable.columnAtPoint(LogPanel.this.currentPoint);
                        int row = LogPanel.this.currentTable.rowAtPoint(LogPanel.this.currentPoint);
                        String colName = LogPanel.this.currentTable.getColumnName(column).toUpperCase();
                        String value = LogPanel.this.getValueOf(row, column);
                        if (columnNameKeywordMap.containsKey(colName)) {
                            filterText.setText(((String)columnNameKeywordMap.get(colName)).toString() + " " + operator + " '" + value + "'");
                        }
                    }
                });
            }
        }
        mainPopup.add(new FocusOn());
        searchPopup.add(new FocusOn());
        class DefineAddCustomFilter
        extends JMenuItem {
            public DefineAddCustomFilter() {
                super("Add value under pointer to 'refine focus' field");
                this.addActionListener(evt -> {
                    if (LogPanel.this.currentPoint != null) {
                        String operator = "==";
                        int column = LogPanel.this.currentTable.columnAtPoint(LogPanel.this.currentPoint);
                        int row = LogPanel.this.currentTable.rowAtPoint(LogPanel.this.currentPoint);
                        String value = LogPanel.this.getValueOf(row, column);
                        String colName = LogPanel.this.currentTable.getColumnName(column).toUpperCase();
                        if (columnNameKeywordMap.containsKey(colName)) {
                            filterText.setText(filterText.getText() + " && " + ((String)columnNameKeywordMap.get(colName)).toString() + " " + operator + " '" + value + "'");
                        }
                    }
                });
            }
        }
        mainPopup.add(new DefineAddCustomFilter());
        searchPopup.add(new DefineAddCustomFilter());
        class ClearFocus
        extends AbstractAction {
            public ClearFocus() {
                super("Clear 'refine focus' field");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                filterText.setText(null);
                LogPanel.this.tableRuleMediator.setFilterRule(null);
                LogPanel.this.searchRuleMediator.setFilterRule(null);
            }
        }
        mainPopup.add(new ClearFocus());
        searchPopup.add(new ClearFocus());
        mainPopup.add(new JSeparator());
        searchPopup.add(new JSeparator());
        class Search
        extends JMenuItem {
            public Search() {
                super("Find value under pointer");
                this.addActionListener(evt -> {
                    if (LogPanel.this.currentPoint != null) {
                        String operator = "==";
                        int column = LogPanel.this.currentTable.columnAtPoint(LogPanel.this.currentPoint);
                        int row = LogPanel.this.currentTable.rowAtPoint(LogPanel.this.currentPoint);
                        String colName = LogPanel.this.currentTable.getColumnName(column).toUpperCase();
                        String value = LogPanel.this.getValueOf(row, column);
                        if (columnNameKeywordMap.containsKey(colName)) {
                            LogPanel.this.findCombo.setSelectedItem(((String)columnNameKeywordMap.get(colName)).toString() + " " + operator + " '" + value + "'");
                            LogPanel.this.findNext();
                        }
                    }
                });
            }
        }
        mainPopup.add(new Search());
        searchPopup.add(new Search());
        class DefineAddCustomFind
        extends JMenuItem {
            public DefineAddCustomFind() {
                super("Add value under pointer to 'find' field");
                this.addActionListener(evt -> {
                    if (LogPanel.this.currentPoint != null) {
                        String operator = "==";
                        int column = LogPanel.this.currentTable.columnAtPoint(LogPanel.this.currentPoint);
                        int row = LogPanel.this.currentTable.rowAtPoint(LogPanel.this.currentPoint);
                        String value = LogPanel.this.getValueOf(row, column);
                        String colName = LogPanel.this.currentTable.getColumnName(column).toUpperCase();
                        if (columnNameKeywordMap.containsKey(colName)) {
                            LogPanel.this.findCombo.setSelectedItem(findText.getText() + " && " + ((String)columnNameKeywordMap.get(colName)).toString() + " " + operator + " '" + value + "'");
                            LogPanel.this.findNext();
                        }
                    }
                });
            }
        }
        mainPopup.add(new DefineAddCustomFind());
        searchPopup.add(new DefineAddCustomFind());
        class ClearSearch
        extends AbstractAction {
            public ClearSearch() {
                super("Clear find field");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.findCombo.setSelectedItem(null);
                LogPanel.this.updateFindRule(null);
            }
        }
        mainPopup.add(new ClearSearch());
        searchPopup.add(new ClearSearch());
        mainPopup.add(new JSeparator());
        searchPopup.add(new JSeparator());
        class DisplayRelativeTimesToRowUnderCursor
        extends JMenuItem {
            public DisplayRelativeTimesToRowUnderCursor() {
                super("Show times relative to this event");
                this.addActionListener(e -> {
                    if (LogPanel.this.currentPoint != null) {
                        int row = LogPanel.this.currentTable.rowAtPoint(LogPanel.this.currentPoint);
                        ChainsawCyclicBufferTableModel cyclicBufferTableModel = (ChainsawCyclicBufferTableModel)LogPanel.this.currentTable.getModel();
                        LoggingEventWrapper loggingEventWrapper = cyclicBufferTableModel.getRow(row);
                        if (loggingEventWrapper != null) {
                            ((TableColorizingRenderer)LogPanel.this.currentTable.getDefaultRenderer(Object.class)).setUseRelativeTimes(loggingEventWrapper.getLoggingEvent().getTimeStamp());
                            cyclicBufferTableModel.reFilter();
                        }
                        this.setEnabled(true);
                    }
                });
            }
        }
        mainPopup.add(new DisplayRelativeTimesToRowUnderCursor());
        searchPopup.add(new DisplayRelativeTimesToRowUnderCursor());
        class DisplayRelativeTimesToPreviousRow
        extends JMenuItem {
            public DisplayRelativeTimesToPreviousRow() {
                super("Show times relative to previous rows");
                this.addActionListener(e -> {
                    if (LogPanel.this.currentPoint != null) {
                        ((TableColorizingRenderer)LogPanel.this.currentTable.getDefaultRenderer(Object.class)).setUseRelativeTimesToPreviousRow();
                        ((ChainsawCyclicBufferTableModel)LogPanel.this.currentTable.getModel()).reFilter();
                        this.setEnabled(true);
                    }
                });
            }
        }
        mainPopup.add(new DisplayRelativeTimesToPreviousRow());
        searchPopup.add(new DisplayRelativeTimesToPreviousRow());
        class DisplayNormalTimes
        extends JMenuItem {
            public DisplayNormalTimes() {
                super("Hide relative times");
                this.addActionListener(e -> {
                    if (LogPanel.this.currentPoint != null) {
                        ((TableColorizingRenderer)LogPanel.this.currentTable.getDefaultRenderer(Object.class)).setUseNormalTimes();
                        ((ChainsawCyclicBufferTableModel)LogPanel.this.currentTable.getModel()).reFilter();
                        this.setEnabled(true);
                    }
                });
            }
        }
        mainPopup.add(new DisplayNormalTimes());
        searchPopup.add(new DisplayNormalTimes());
        mainPopup.add(new JSeparator());
        searchPopup.add(new JSeparator());
        class BuildColorRule
        extends JMenuItem {
            public BuildColorRule() {
                super("Define color rule for value under pointer");
                this.addActionListener(evt -> {
                    if (LogPanel.this.currentPoint != null) {
                        Color c;
                        String operator = "==";
                        int column = LogPanel.this.currentTable.columnAtPoint(LogPanel.this.currentPoint);
                        int row = LogPanel.this.currentTable.rowAtPoint(LogPanel.this.currentPoint);
                        String colName = LogPanel.this.currentTable.getColumnName(column).toUpperCase();
                        String value = LogPanel.this.getValueOf(row, column);
                        if (columnNameKeywordMap.containsKey(colName) && (c = JColorChooser.showDialog(this.getRootPane(), "Choose a color", Color.red)) != null) {
                            String expression = ((String)columnNameKeywordMap.get(colName)).toString() + " " + operator + " '" + value + "'";
                            LogPanel.this.colorizer.addRule("Default", new ColorRule(expression, ExpressionRule.getRule((String)expression), c, ChainsawConstants.COLOR_DEFAULT_FOREGROUND));
                        }
                    }
                });
            }
        }
        mainPopup.add(new BuildColorRule());
        searchPopup.add(new BuildColorRule());
        mainPopup.add(new JSeparator());
        searchPopup.add(new JSeparator());
        class CopyField
        extends AbstractAction {
            public CopyField() {
                super("Copy value under pointer to clipboard");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogPanel.this.currentPoint != null && LogPanel.this.currentTable != null) {
                    int column = LogPanel.this.currentTable.columnAtPoint(LogPanel.this.currentPoint);
                    int row = LogPanel.this.currentTable.rowAtPoint(LogPanel.this.currentPoint);
                    String value = LogPanel.this.getValueOf(row, column);
                    StringSelection selection = new StringSelection(value);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, null);
                }
            }
        }
        mainPopup.add(new CopyField());
        class CopySelection
        extends AbstractAction {
            public CopySelection() {
                super("Copy selection to clipboard");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogPanel.this.currentTable == null) {
                    return;
                }
                int start = LogPanel.this.currentTable.getSelectionModel().getMinSelectionIndex();
                int end = LogPanel.this.currentTable.getSelectionModel().getMaxSelectionIndex();
                StringBuilder result = new StringBuilder();
                for (int row = start; row < end + 1; ++row) {
                    for (int column = 0; column < LogPanel.this.currentTable.getColumnCount(); ++column) {
                        result.append(LogPanel.this.getValueOf(row, column));
                        if (column == LogPanel.this.currentTable.getColumnCount() - 1) continue;
                        result.append(" - ");
                    }
                    result.append(System.getProperty("line.separator"));
                }
                StringSelection selection = new StringSelection(result.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, null);
            }
        }
        mainPopup.add(new CopySelection());
        searchPopup.add(new CopyField());
        searchPopup.add(new CopySelection());
        mainPopup.add(new JSeparator());
        searchPopup.add(new JSeparator());
        mainPopup.add(menuItemToggleDetails);
        mainPopup.add(menuItemLoggerTree);
        this.mainToggleToolTips = new ToggleToolTips();
        this.searchToggleToolTips = new ToggleToolTips();
        mainPopup.add(this.mainToggleToolTips);
        searchPopup.add(this.searchToggleToolTips);
        mainPopup.add(new JSeparator());
        mainPopup.add(menuItemToggleDock);
        class BestFit
        extends JMenuItem {
            public BestFit() {
                super("Best fit column");
                this.addActionListener(evt -> {
                    if (LogPanel.this.currentPoint != null) {
                        int column = LogPanel.this.currentTable.columnAtPoint(LogPanel.this.currentPoint);
                        int maxWidth = LogPanel.this.getMaxColumnWidth(column);
                        LogPanel.this.currentTable.getColumnModel().getColumn(column).setPreferredWidth(maxWidth);
                    }
                });
            }
        }
        mainPopup.add(new BestFit());
        searchPopup.add(new BestFit());
        mainPopup.add(new JSeparator());
        class ColorPanel
        extends JMenuItem {
            public ColorPanel() {
                super("Color settings...");
                this.setIcon(ChainsawIcons.ICON_PREFERENCES);
                this.addActionListener(evt -> LogPanel.this.showColorPreferences());
            }
        }
        mainPopup.add(new ColorPanel());
        searchPopup.add(new ColorPanel());
        class LogPanelPreferences
        extends JMenuItem {
            public LogPanelPreferences() {
                super("Tab Preferences...");
                this.setIcon(ChainsawIcons.ICON_PREFERENCES);
                this.addActionListener(evt -> LogPanel.this.showPreferences());
            }
        }
        mainPopup.add(new LogPanelPreferences());
        searchPopup.add(new LogPanelPreferences());
        PopupListener mainTablePopupListener = new PopupListener(mainPopup);
        this.eventsPane.addMouseListener(mainTablePopupListener);
        this.table.addMouseListener(mainTablePopupListener);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            private void checkMultiSelect(MouseEvent mouseEvent) {
                if (mouseEvent.isAltDown()) {
                    LogPanel.this.table.getSelectionModel().setSelectionMode(1);
                } else {
                    LogPanel.this.table.getSelectionModel().setSelectionMode(0);
                }
            }
        });
        this.searchTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.checkMultiSelect(mouseEvent);
            }

            private void checkMultiSelect(MouseEvent mouseEvent) {
                if (mouseEvent.isAltDown()) {
                    LogPanel.this.searchTable.getSelectionModel().setSelectionMode(1);
                } else {
                    LogPanel.this.searchTable.getSelectionModel().setSelectionMode(0);
                }
            }
        });
        PopupListener searchTablePopupListener = new PopupListener(searchPopup);
        this.searchPane.addMouseListener(searchTablePopupListener);
        this.searchTable.addMouseListener(searchTablePopupListener);
    }

    private String getValueOf(int row, int column) {
        if (this.currentTable == null) {
            return "";
        }
        Object o = this.currentTable.getValueAt(row, column);
        if (o instanceof Date) {
            return TIMESTAMP_DATE_FORMAT.format((Date)o);
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Level) {
            return o.toString();
        }
        if (o instanceof String[]) {
            StringBuilder value = new StringBuilder();
            String[] ti = (String[])o;
            if (!(ti.length <= 0 || ti.length == 1 && ti[0].equals(""))) {
                LoggingEventWrapper loggingEventWrapper = ((ChainsawCyclicBufferTableModel)this.currentTable.getModel()).getRow(row);
                value = new StringBuilder(loggingEventWrapper.getLoggingEvent().getMessage().toString());
                for (int i = 0; i < ((String[])o).length; ++i) {
                    value.append('\n').append(((String[])o)[i]);
                }
            }
            return value.toString();
        }
        return "";
    }

    private Action getFindNextAction() {
        AbstractAction action = new AbstractAction("Find next"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.findNext();
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F3"));
        action.putValue("ShortDescription", "Find the next occurrence of the rule from the current row");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DOWN));
        return action;
    }

    private Action getFindPreviousAction() {
        AbstractAction action = new AbstractAction("Find previous"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.findPrevious();
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 1));
        action.putValue("ShortDescription", "Find the previous occurrence of the rule from the current row");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UP));
        return action;
    }

    private void buildCombo(final AutoFilterComboBox combo, boolean isFiltering, final AutoFilterComboBox.AutoFilterComboBoxModel otherModel) {
        combo.addItem("LEVEL == TRACE");
        combo.addItem("LEVEL >= DEBUG");
        combo.addItem("LEVEL >= INFO");
        combo.addItem("LEVEL >= WARN");
        combo.addItem("LEVEL >= ERROR");
        combo.addItem("LEVEL == FATAL");
        final JTextField filterText = (JTextField)combo.getEditor().getEditorComponent();
        if (isFiltering) {
            filterText.getDocument().addDocumentListener(new DelayedTextDocumentListener(filterText));
        }
        filterText.setToolTipText("Enter an expression - right click or ctrl-space for menu - press enter to add to list");
        filterText.addKeyListener(new ExpressionRuleContext(this.filterModel, filterText));
        if (combo.getEditor().getEditorComponent() instanceof JTextField) {
            combo.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("comboBoxEdited")) {
                        try {
                            Object item = combo.getSelectedItem();
                            if (item != null && !item.toString().trim().equals("")) {
                                ExpressionRule.getRule((String)item.toString());
                                combo.insertItemAt(item, 0);
                                otherModel.insertElementAt(item, 0);
                            }
                            filterText.setBackground(UIManager.getColor("TextField.background"));
                        }
                        catch (IllegalArgumentException iae) {
                            filterText.setToolTipText(iae.getMessage());
                            filterText.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                        }
                    }
                }
            });
        }
    }

    public boolean isScrollToBottom() {
        return this.preferenceModel.isScrollToBottom();
    }

    public void setRefineFocusText(String refineFocusText) {
        JTextField filterText = (JTextField)this.filterCombo.getEditor().getEditorComponent();
        filterText.setText(refineFocusText);
    }

    public String getRefineFocusText() {
        JTextField filterText = (JTextField)this.filterCombo.getEditor().getEditorComponent();
        return filterText.getText();
    }

    public void toggleScrollToBottom() {
        this.preferenceModel.setScrollToBottom(!this.preferenceModel.isScrollToBottom());
    }

    private void scrollToBottom() {
        EventQueue.invokeLater(() -> {
            int scrollRow = this.tableModel.getRowCount() - 1;
            this.table.scrollToRow(scrollRow);
        });
    }

    public void scrollToTop() {
        EventQueue.invokeLater(() -> {
            if (this.tableModel.getRowCount() > 1) {
                this.table.scrollToRow(0);
            }
        });
    }

    @Override
    public String getNamespace() {
        return this.getIdentifier();
    }

    @Override
    public String getInterestedIdentifier() {
        return this.getIdentifier();
    }

    @Override
    public void receiveEventBatch(String ident, List<LoggingEvent> events) {
        SwingHelper.invokeOnEDT(() -> {
            int newIndex;
            if (this.isPaused()) {
                return;
            }
            int selectedRow = this.table.getSelectedRow();
            int startingRow = this.table.getRowCount();
            LoggingEventWrapper selectedEvent = selectedRow >= 0 ? this.tableModel.getRow(selectedRow) : null;
            int startingSearchRow = this.searchTable.getRowCount();
            boolean rowAdded = false;
            boolean searchRowAdded = false;
            int addedRowCount = 0;
            int searchAddedRowCount = 0;
            for (Object event1 : events) {
                LoggingEvent event = (LoggingEvent)event1;
                LoggingEventWrapper loggingEventWrapper1 = new LoggingEventWrapper(event);
                if (this.clearTableExpressionRule != null && this.clearTableExpressionRule.evaluate(event, null)) {
                    this.logger.info((Object)("clear table expression matched - clearing table - matching event msg - " + event.getMessage()));
                    this.clearEvents();
                }
                this.updateOtherModels(event);
                boolean isCurrentRowAdded = this.tableModel.isAddRow(loggingEventWrapper1);
                if (isCurrentRowAdded) {
                    ++addedRowCount;
                }
                rowAdded = rowAdded || isCurrentRowAdded;
                LoggingEventWrapper loggingEventWrapper2 = new LoggingEventWrapper(loggingEventWrapper1);
                boolean isSearchCurrentRowAdded = this.searchModel.isAddRow(loggingEventWrapper2);
                if (isSearchCurrentRowAdded) {
                    ++searchAddedRowCount;
                }
                searchRowAdded = searchRowAdded || isSearchCurrentRowAdded;
            }
            if (rowAdded) {
                this.tableModel.fireTableEvent(startingRow, startingRow + addedRowCount, addedRowCount);
            }
            if (searchRowAdded) {
                this.searchModel.fireTableEvent(startingSearchRow, startingSearchRow + searchAddedRowCount, searchAddedRowCount);
            }
            this.tableModel.notifyCountListeners();
            if (rowAdded) {
                if (this.tableModel.isSortEnabled()) {
                    this.tableModel.sort();
                }
                this.detailPaneUpdater.setSelectedRow(this.table.getSelectedRow());
            }
            if (searchRowAdded && this.searchModel.isSortEnabled()) {
                this.searchModel.sort();
            }
            if (!this.isScrollToBottom() && selectedEvent != null && (newIndex = this.tableModel.getRowIndex(selectedEvent)) >= 0) {
                this.table.setRowSelectionInterval(newIndex, newIndex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSettings(LoadSettingsEvent event) {
        File xmlFile = null;
        try {
            xmlFile = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.identifier, "UTF-8") + ".xml");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (xmlFile.exists()) {
            XStream stream = this.buildXStreamForLogPanelPreference();
            ObjectInputStream in = null;
            try {
                FileReader r = new FileReader(xmlFile);
                in = stream.createObjectInputStream((Reader)r);
                LogPanelPreferenceModel storedPrefs = (LogPanelPreferenceModel)in.readObject();
                this.lowerPanelDividerLocation = in.readInt();
                int treeDividerLocation = in.readInt();
                String conversionPattern = in.readObject().toString();
                Point p = (Point)in.readObject();
                Dimension d = (Dimension)in.readObject();
                int versionNumber = 0;
                try {
                    versionNumber = in.readInt();
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                if (versionNumber > 0) {
                    Vector savedVector = (Vector)in.readObject();
                    for (Object item : savedVector) {
                        this.filterCombo.insertItemAt(item, 0);
                        this.findCombo.insertItemAt(item, 0);
                    }
                    if (versionNumber > 1) {
                        int index = 0;
                        String columnOrder = event.getSetting(TABLE_COLUMN_ORDER);
                        StringTokenizer tok = new StringTokenizer(columnOrder, ",");
                        while (tok.hasMoreElements()) {
                            String element = tok.nextElement().toString().trim().toUpperCase();
                            TableColumn column = new TableColumn(index++);
                            column.setHeaderValue(element);
                            this.preferenceModel.addColumn(column);
                        }
                        TableColumnModel columnModel = this.table.getColumnModel();
                        while (columnModel.getColumnCount() > 0) {
                            columnModel.removeColumn(columnModel.getColumn(0));
                        }
                        for (Object o1 : this.preferenceModel.getVisibleColumnOrder()) {
                            TableColumn col = (TableColumn)o1;
                            columnModel.addColumn(col);
                        }
                        TableColumnModel searchColumnModel = this.searchTable.getColumnModel();
                        while (searchColumnModel.getColumnCount() > 0) {
                            searchColumnModel.removeColumn(searchColumnModel.getColumn(0));
                        }
                        for (Object o : this.preferenceModel.getVisibleColumnOrder()) {
                            TableColumn col = (TableColumn)o;
                            searchColumnModel.addColumn(col);
                        }
                        this.preferenceModel.apply(storedPrefs);
                    } else {
                        this.loadDefaultColumnSettings(event);
                    }
                    this.tableModel.setCyclic(this.preferenceModel.isCyclic());
                    this.searchModel.setCyclic(this.preferenceModel.isCyclic());
                    this.lowerPanel.setDividerLocation(this.lowerPanelDividerLocation);
                    this.nameTreeAndMainPanelSplit.setDividerLocation(treeDividerLocation);
                    this.detailLayout.setConversionPattern(conversionPattern);
                    if (p.x != 0 && p.y != 0) {
                        this.undockedFrame.setLocation(p.x, p.y);
                        this.undockedFrame.setSize(d);
                    }
                    this.undockedFrame.setLocation(0, 0);
                    this.undockedFrame.setSize(new Dimension(1024, 768));
                }
                this.loadDefaultColumnSettings(event);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.loadDefaultColumnSettings(event);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            this.loadDefaultColumnSettings(event);
        }
        this.tableModel.setCyclic(this.preferenceModel.isCyclic());
        this.searchModel.setCyclic(this.preferenceModel.isCyclic());
        this.logTreePanel.ignore(this.preferenceModel.getHiddenLoggers());
        this.logTreePanel.setHiddenExpression(this.preferenceModel.getHiddenExpression());
        this.logTreePanel.setAlwaysDisplayExpression(this.preferenceModel.getAlwaysDisplayExpression());
        if (this.preferenceModel.getClearTableExpression() != null) {
            try {
                this.clearTableExpressionRule = ExpressionRule.getRule((String)this.preferenceModel.getClearTableExpression());
            }
            catch (Exception e) {
                this.clearTableExpressionRule = null;
            }
        }
        this.colorizer.loadColorSettings(this.identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSettings(SaveSettingsEvent event) {
        File xmlFile;
        try {
            xmlFile = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.identifier, "UTF-8") + ".xml");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        this.preferenceModel.setHiddenLoggers(new HashSet(this.logTreePanel.getHiddenSet()));
        this.preferenceModel.setHiddenExpression(this.logTreePanel.getHiddenExpression());
        this.preferenceModel.setAlwaysDisplayExpression(this.logTreePanel.getAlwaysDisplayExpression());
        ArrayList<TableColumn> visibleOrder = new ArrayList<TableColumn>();
        Enumeration<TableColumn> cols = this.table.getColumnModel().getColumns();
        while (cols.hasMoreElements()) {
            TableColumn c = cols.nextElement();
            visibleOrder.add(c);
        }
        this.preferenceModel.setVisibleColumnOrder(visibleOrder);
        XStream stream = this.buildXStreamForLogPanelPreference();
        ObjectOutputStream s = null;
        try {
            FileWriter w = new FileWriter(xmlFile);
            s = stream.createObjectOutputStream((Writer)w);
            s.writeObject(this.preferenceModel);
            if (this.isDetailPanelVisible) {
                s.writeInt(this.lowerPanel.getDividerLocation());
            } else {
                s.writeInt(this.lowerPanelDividerLocation);
            }
            s.writeInt(this.nameTreeAndMainPanelSplit.getDividerLocation());
            s.writeObject(this.detailLayout.getConversionPattern());
            s.writeObject(this.undockedFrame.getLocation());
            s.writeObject(this.undockedFrame.getSize());
            s.writeInt(2);
            Vector combinedVector = new Vector();
            combinedVector.addAll(this.filterCombo.getModelData());
            combinedVector.addAll(this.findCombo.getModelData());
            s.writeObject(combinedVector);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.colorizer.saveColorSettings(this.identifier);
    }

    private XStream buildXStreamForLogPanelPreference() {
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        stream.registerConverter((Converter)new TableColumnConverter());
        return stream;
    }

    void showPreferences() {
        LogPanel.centerAndSetVisible(this.logPanelPreferencesFrame);
    }

    public static void centerAndSetVisible(Window window) {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation(new Point(screenDimension.width / 2 - window.getSize().width / 2, screenDimension.height / 2 - window.getSize().height / 2));
        window.setVisible(true);
    }

    void showColorPreferences() {
        this.colorPanel.loadLogPanelColorizers();
        this.colorFrame.pack();
        LogPanel.centerAndSetVisible(this.colorFrame);
    }

    void toggleDetailVisible() {
        this.preferenceModel.setDetailPaneVisible(!this.preferenceModel.isDetailPaneVisible());
    }

    boolean isDetailVisible() {
        return this.preferenceModel.isDetailPaneVisible();
    }

    boolean isSearchResultsVisible() {
        return this.preferenceModel.isSearchResultsVisible();
    }

    void toggleLogTreeVisible() {
        this.preferenceModel.setLogTreePanelVisible(!this.preferenceModel.isLogTreePanelVisible());
    }

    boolean isLogTreeVisible() {
        return this.preferenceModel.isLogTreePanelVisible();
    }

    List getEvents() {
        return this.tableModel.getAllEvents();
    }

    List getFilteredEvents() {
        return this.tableModel.getFilteredEvents();
    }

    List<LoggingEventWrapper> getMatchingEvents(Rule rule) {
        return this.tableModel.getMatchingEvents(rule);
    }

    void clearEvents() {
        this.clearModel();
    }

    String getIdentifier() {
        return this.identifier;
    }

    void undock() {
        int row = this.table.getSelectedRow();
        this.setDocked(false);
        this.externalPanel.removeAll();
        this.externalPanel.add((Component)this.undockedToolbar, "North");
        this.externalPanel.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        this.externalPanel.setDocked(false);
        this.undockedFrame.pack();
        this.undockedFrame.setVisible(true);
        this.dockingAction.putValue("Name", "Dock");
        this.dockingAction.putValue("SmallIcon", ChainsawIcons.ICON_DOCK);
        if (row > -1) {
            EventQueue.invokeLater(() -> this.table.scrollToRow(row));
        }
    }

    void addEventCountListener(EventCountListener l) {
        this.tableModel.addEventCountListener(l);
    }

    boolean isPaused() {
        return this.paused;
    }

    void setPaused(boolean paused) {
        boolean oldValue = this.paused;
        this.paused = paused;
        this.firePropertyChange("paused", oldValue, paused);
    }

    int setSelectedEvent(int eventNumber) {
        int row = this.tableModel.locate(ExpressionRule.getRule((String)("prop.log4jid == " + eventNumber)), 0, true);
        if (row > -1) {
            this.preferenceModel.setScrollToBottom(false);
            this.table.scrollToRow(row);
        }
        return row;
    }

    void addPreferencePropertyChangeListener(PropertyChangeListener listener) {
        this.preferenceModel.addPropertyChangeListener(listener);
    }

    void toggleCyclic() {
        boolean toggledCyclic = !this.preferenceModel.isCyclic();
        this.preferenceModel.setCyclic(toggledCyclic);
        this.tableModel.setCyclic(toggledCyclic);
        this.searchModel.setCyclic(toggledCyclic);
    }

    boolean isCyclic() {
        return this.preferenceModel.isCyclic();
    }

    public void updateFindRule(String ruleText) {
        block7: {
            if (ruleText == null || ruleText.trim().equals("")) {
                this.findRule = null;
                this.tableModel.updateEventsWithFindRule(null);
                this.colorizer.setFindRule(null);
                this.tableRuleMediator.setFindRule(null);
                this.searchRuleMediator.setFindRule(null);
                this.findCombo.setBackground(UIManager.getColor("TextField.background"));
                this.findCombo.setToolTipText("Enter an expression - right click or ctrl-space for menu - press enter to add to list");
                this.currentSearchMatchCount = 0;
                this.currentFindRuleText = null;
                this.statusBar.setSearchMatchCount(this.currentSearchMatchCount, this.getIdentifier());
                if (this.isSearchResultsVisible()) {
                    this.hideSearchResults();
                }
            } else {
                this.preferenceModel.setScrollToBottom(false);
                if (ruleText.equals(this.currentFindRuleText)) {
                    return;
                }
                this.currentFindRuleText = ruleText;
                try {
                    JTextField findText = (JTextField)this.findCombo.getEditor().getEditorComponent();
                    findText.setToolTipText("Enter an expression - right click or ctrl-space for menu - press enter to add to list");
                    this.findRule = ExpressionRule.getRule((String)ruleText);
                    this.currentSearchMatchCount = this.tableModel.updateEventsWithFindRule(this.findRule);
                    this.searchModel.updateEventsWithFindRule(this.findRule);
                    this.colorizer.setFindRule(this.findRule);
                    this.tableRuleMediator.setFindRule(this.findRule);
                    this.searchRuleMediator.setFindRule(this.findRule);
                    findText.setBackground(UIManager.getColor("TextField.background"));
                    this.statusBar.setSearchMatchCount(this.currentSearchMatchCount, this.getIdentifier());
                    if (this.isSearchResultsVisible()) {
                        this.showSearchResults();
                    }
                }
                catch (IllegalArgumentException re) {
                    this.findRule = null;
                    JTextField findText = (JTextField)this.findCombo.getEditor().getEditorComponent();
                    findText.setToolTipText(re.getMessage());
                    findText.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                    this.colorizer.setFindRule(null);
                    this.tableRuleMediator.setFindRule(null);
                    this.searchRuleMediator.setFindRule(null);
                    this.tableModel.updateEventsWithFindRule(null);
                    this.searchModel.updateEventsWithFindRule(null);
                    this.currentSearchMatchCount = 0;
                    this.statusBar.setSearchMatchCount(this.currentSearchMatchCount, this.getIdentifier());
                    if (!this.isSearchResultsVisible()) break block7;
                    this.hideSearchResults();
                }
            }
        }
    }

    private void hideSearchResults() {
        if (this.searchResultsDisplayed) {
            this.detailPanel.removeAll();
            JPanel leftSpacePanel = new JPanel();
            Integer scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            leftSpacePanel.setPreferredSize(new Dimension(scrollBarWidth - 4, -1));
            JPanel rightSpacePanel = new JPanel();
            rightSpacePanel.setPreferredSize(new Dimension(scrollBarWidth - 4, -1));
            this.detailPanel.add((Component)this.detailToolbar, "North");
            this.detailPanel.add((Component)this.detailPane, "Center");
            this.detailPanel.add((Component)leftSpacePanel, "West");
            this.detailPanel.add((Component)rightSpacePanel, "East");
            this.detailPanel.revalidate();
            this.detailPanel.repaint();
            this.searchResultsDisplayed = false;
            if (!this.isDetailVisible()) {
                this.hideDetailPane();
            }
        }
    }

    private void showSearchResults() {
        if (this.isSearchResultsVisible() && !this.searchResultsDisplayed && this.findRule != null) {
            this.detailPanel.removeAll();
            this.detailPanel.add((Component)this.searchPane, "Center");
            Integer scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            JPanel leftSpacePanel = new JPanel();
            leftSpacePanel.setPreferredSize(new Dimension(scrollBarWidth - 4, -1));
            JPanel rightSpacePanel = new JPanel();
            rightSpacePanel.setPreferredSize(new Dimension(scrollBarWidth - 4, -1));
            this.detailPanel.add((Component)leftSpacePanel, "West");
            this.detailPanel.add((Component)rightSpacePanel, "East");
            this.detailPanel.revalidate();
            this.detailPanel.repaint();
            this.searchResultsDisplayed = true;
            if (!this.isDetailVisible()) {
                this.showDetailPane();
            }
        }
    }

    private void showDetailPane() {
        if (!this.isDetailPanelVisible) {
            this.lowerPanel.setDividerSize(this.dividerSize);
            if (this.lowerPanelDividerLocation == 0) {
                this.lowerPanel.setDividerLocation(0.71);
                this.lowerPanelDividerLocation = this.lowerPanel.getDividerLocation();
            } else {
                this.lowerPanel.setDividerLocation(this.lowerPanelDividerLocation);
            }
            this.detailPanel.setVisible(true);
            this.detailPanel.repaint();
            this.lowerPanel.repaint();
            this.isDetailPanelVisible = true;
        }
    }

    private void hideDetailPane() {
        if (this.isDetailPanelVisible) {
            this.lowerPanelDividerLocation = this.lowerPanel.getDividerLocation();
        }
        this.lowerPanel.setDividerSize(0);
        this.detailPanel.setVisible(false);
        this.lowerPanel.repaint();
        this.isDetailPanelVisible = false;
    }

    private void showLogTreePanel() {
        this.nameTreeAndMainPanelSplit.setDividerSize(this.dividerSize);
        this.nameTreeAndMainPanelSplit.setDividerLocation(this.lastLogTreePanelSplitLocation);
        this.logTreePanel.setVisible(true);
        this.nameTreeAndMainPanelSplit.repaint();
    }

    private void hideLogTreePanel() {
        int currentSize = this.nameTreeAndMainPanelSplit.getWidth() - this.nameTreeAndMainPanelSplit.getDividerSize() - 1;
        if (currentSize > 0) {
            this.lastLogTreePanelSplitLocation = (double)this.nameTreeAndMainPanelSplit.getDividerLocation() / (double)currentSize;
        }
        this.nameTreeAndMainPanelSplit.setDividerSize(0);
        this.logTreePanel.setVisible(false);
        this.nameTreeAndMainPanelSplit.repaint();
    }

    private JToolBar createDockwindowToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        AbstractAction dockPauseAction = new AbstractAction("Pause"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.setPaused(!LogPanel.this.isPaused());
            }
        };
        dockPauseAction.putValue("MnemonicKey", 80);
        dockPauseAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F12"));
        dockPauseAction.putValue("ShortDescription", "Halts the display, while still allowing events to stream in the background");
        dockPauseAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        SmallToggleButton dockPauseButton = new SmallToggleButton(dockPauseAction);
        dockPauseButton.setText("");
        dockPauseButton.getModel().setSelected(this.isPaused());
        this.addPropertyChangeListener("paused", evt -> dockPauseButton.getModel().setSelected(this.isPaused()));
        toolbar.add(dockPauseButton);
        AbstractAction dockShowPrefsAction = new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.showPreferences();
            }
        };
        dockShowPrefsAction.putValue("ShortDescription", "Define preferences...");
        dockShowPrefsAction.putValue("SmallIcon", ChainsawIcons.ICON_PREFERENCES);
        toolbar.add(new SmallButton(dockShowPrefsAction));
        AbstractAction dockToggleLogTreeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.toggleLogTreeVisible();
            }
        };
        dockToggleLogTreeAction.putValue("ShortDescription", "Toggles the Logger Tree Pane");
        dockToggleLogTreeAction.putValue("enabled", Boolean.TRUE);
        dockToggleLogTreeAction.putValue("MnemonicKey", 84);
        dockToggleLogTreeAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        dockToggleLogTreeAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        SmallToggleButton toggleLogTreeButton = new SmallToggleButton(dockToggleLogTreeAction);
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", evt -> toggleLogTreeButton.setSelected(this.preferenceModel.isLogTreePanelVisible()));
        toggleLogTreeButton.setSelected(this.isLogTreeVisible());
        toolbar.add(toggleLogTreeButton);
        toolbar.addSeparator();
        AbstractAction undockedClearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.clearModel();
            }
        };
        undockedClearAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DELETE));
        undockedClearAction.putValue("ShortDescription", "Removes all the events from the current view");
        SmallButton dockClearButton = new SmallButton(undockedClearAction);
        dockClearButton.getInputMap(1).put(KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), undockedClearAction.getValue("Name"));
        dockClearButton.getActionMap().put(undockedClearAction.getValue("Name"), undockedClearAction);
        dockClearButton.setText("");
        toolbar.add(dockClearButton);
        toolbar.addSeparator();
        AbstractAction dockToggleScrollToBottomAction = new AbstractAction("Toggles Scroll to Bottom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.toggleScrollToBottom();
            }
        };
        dockToggleScrollToBottomAction.putValue("ShortDescription", "Toggles Scroll to Bottom");
        dockToggleScrollToBottomAction.putValue("enabled", Boolean.TRUE);
        dockToggleScrollToBottomAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        SmallToggleButton toggleScrollToBottomButton = new SmallToggleButton(dockToggleScrollToBottomAction);
        this.preferenceModel.addPropertyChangeListener("scrollToBottom", evt -> toggleScrollToBottomButton.setSelected(this.isScrollToBottom()));
        toggleScrollToBottomButton.getInputMap(1).put(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), dockToggleScrollToBottomAction.getValue("Name"));
        toggleScrollToBottomButton.getActionMap().put(dockToggleScrollToBottomAction.getValue("Name"), dockToggleScrollToBottomAction);
        toggleScrollToBottomButton.setSelected(this.isScrollToBottom());
        toggleScrollToBottomButton.setText("");
        toolbar.add(toggleScrollToBottomButton);
        toolbar.addSeparator();
        this.findCombo.addActionListener(e -> {
            if (e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.findNext();
            }
        });
        AbstractAction redockAction = new AbstractAction("", ChainsawIcons.ICON_DOCK){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.dock();
            }
        };
        redockAction.putValue("ShortDescription", "Docks this window back with the main Chainsaw window");
        SmallButton redockButton = new SmallButton(redockAction);
        toolbar.add(redockButton);
        return toolbar;
    }

    protected void updateStatusBar() {
        SwingHelper.invokeOnEDT(() -> {
            this.statusBar.setSelectedLine(this.table.getSelectedRow() + 1, this.tableModel.getRowCount(), this.tableModel.size(), this.getIdentifier());
            this.statusBar.setSearchMatchCount(this.currentSearchMatchCount, this.getIdentifier());
        });
    }

    private void setDetailPaneConversionPattern(String conversionPattern) {
        String oldPattern = this.getDetailPaneConversionPattern();
        this.detailLayout.setConversionPattern(conversionPattern);
        this.firePropertyChange("detailPaneConversionPattern", oldPattern, this.getDetailPaneConversionPattern());
    }

    private String getDetailPaneConversionPattern() {
        return this.detailLayout.getConversionPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearModel() {
        this.previousLastIndex = -1;
        this.tableModel.clearModel();
        this.searchModel.clearModel();
        JEditorPane jEditorPane = this.detail;
        synchronized (jEditorPane) {
            this.detailPaneUpdater.setSelectedRow(-1);
            this.detail.notify();
        }
        this.statusBar.setNothingSelected();
    }

    public void findNextColorizedEvent() {
        EventQueue.invokeLater(() -> {
            int nextRow = this.tableModel.findColoredRow(this.table.getSelectedRow() + 1, true);
            if (nextRow > -1) {
                this.table.scrollToRow(nextRow);
            }
        });
    }

    public void findPreviousColorizedEvent() {
        EventQueue.invokeLater(() -> {
            int previousRow = this.tableModel.findColoredRow(this.table.getSelectedRow() - 1, false);
            if (previousRow > -1) {
                this.table.scrollToRow(previousRow);
            }
        });
    }

    public void findNext() {
        Object item = this.findCombo.getSelectedItem();
        this.updateFindRule(item == null ? null : item.toString());
        if (this.findRule != null) {
            EventQueue.invokeLater(() -> {
                JTextField findText = (JTextField)this.findCombo.getEditor().getEditorComponent();
                try {
                    int nextRow;
                    int filteredEventsSize = this.getFilteredEvents().size();
                    int startRow = this.table.getSelectedRow() + 1;
                    if (startRow > filteredEventsSize - 1) {
                        startRow = 0;
                    }
                    if ((nextRow = this.tableModel.locate(this.findRule, startRow, true)) > -1) {
                        this.table.scrollToRow(nextRow);
                        findText.setToolTipText("Enter an expression - right click or ctrl-space for menu - press enter to add to list");
                    }
                    findText.setBackground(UIManager.getColor("TextField.background"));
                }
                catch (IllegalArgumentException iae) {
                    findText.setToolTipText(iae.getMessage());
                    findText.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                    this.colorizer.setFindRule(null);
                    this.tableRuleMediator.setFindRule(null);
                    this.searchRuleMediator.setFindRule(null);
                }
            });
        }
    }

    public void findPrevious() {
        Object item = this.findCombo.getSelectedItem();
        this.updateFindRule(item == null ? null : item.toString());
        if (this.findRule != null) {
            EventQueue.invokeLater(() -> {
                JTextField findText = (JTextField)this.findCombo.getEditor().getEditorComponent();
                try {
                    int previousRow;
                    int startRow = this.table.getSelectedRow() - 1;
                    int filteredEventsSize = this.getFilteredEvents().size();
                    if (startRow < 0) {
                        startRow = filteredEventsSize - 1;
                    }
                    if ((previousRow = this.tableModel.locate(this.findRule, startRow, false)) > -1) {
                        this.table.scrollToRow(previousRow);
                        this.findCombo.setToolTipText("Enter an expression - right click or ctrl-space for menu - press enter to add to list");
                    }
                    findText.setBackground(UIManager.getColor("TextField.background"));
                }
                catch (IllegalArgumentException iae) {
                    findText.setToolTipText(iae.getMessage());
                    findText.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                }
            });
        }
    }

    private void dock() {
        int row = this.table.getSelectedRow();
        this.setDocked(true);
        this.undockedFrame.setVisible(false);
        this.removeAll();
        this.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        this.externalPanel.setDocked(true);
        this.dockingAction.putValue("Name", "Undock");
        this.dockingAction.putValue("SmallIcon", ChainsawIcons.ICON_UNDOCK);
        if (row > -1) {
            EventQueue.invokeLater(() -> this.table.scrollToRow(row));
        }
    }

    private void loadDefaultColumnSettings(LoadSettingsEvent event) {
        int i;
        String columnOrder = event.getSetting(TABLE_COLUMN_ORDER);
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumnModel searchColumnModel = this.searchTable.getColumnModel();
        HashMap<String, TableColumn> columnNameMap = new HashMap<String, TableColumn>();
        HashMap<String, TableColumn> searchColumnNameMap = new HashMap<String, TableColumn>();
        for (i = 0; i < columnModel.getColumnCount(); ++i) {
            columnNameMap.put(this.table.getColumnName(i).toUpperCase(), columnModel.getColumn(i));
        }
        for (i = 0; i < searchColumnModel.getColumnCount(); ++i) {
            searchColumnNameMap.put(this.searchTable.getColumnName(i).toUpperCase(), searchColumnModel.getColumn(i));
        }
        StringTokenizer tok = new StringTokenizer(columnOrder, ",");
        ArrayList<TableColumn> sortedColumnList = new ArrayList<TableColumn>();
        while (tok.hasMoreElements()) {
            String element = tok.nextElement().toString().trim().toUpperCase();
            TableColumn tableColumn = (TableColumn)columnNameMap.get(element);
            if (tableColumn == null) continue;
            sortedColumnList.add(tableColumn);
            this.table.removeColumn(tableColumn);
            this.searchTable.removeColumn(tableColumn);
        }
        this.preferenceModel.setDetailPaneVisible(event.asBoolean("detailPaneVisible"));
        this.preferenceModel.setLogTreePanelVisible(event.asBoolean("logTreePanelVisible"));
        this.preferenceModel.setHighlightSearchMatchText(event.asBoolean("highlightSearchMatchText"));
        this.preferenceModel.setWrapMessage(event.asBoolean("wrapMessage"));
        this.preferenceModel.setSearchResultsVisible(event.asBoolean("searchResultsVisible"));
        for (Object e : sortedColumnList) {
            TableColumn element = (TableColumn)e;
            if (!this.preferenceModel.addColumn(element) || this.applicationPreferenceModel.isDefaultColumnsSet() && (!this.applicationPreferenceModel.isDefaultColumnsSet() || !this.applicationPreferenceModel.getDefaultColumnNames().contains(element.getHeaderValue()))) continue;
            this.table.addColumn(element);
            this.searchTable.addColumn(element);
            this.preferenceModel.setColumnVisible(element.getHeaderValue().toString(), true);
        }
        String columnWidths = event.getSetting(TABLE_COLUMN_WIDTHS);
        tok = new StringTokenizer(columnWidths, ",");
        int index = 0;
        while (tok.hasMoreElements()) {
            String string = (String)tok.nextElement();
            try {
                int width = Integer.parseInt(string);
                if (index > columnModel.getColumnCount() - 1) {
                    this.logger.warn((Object)("loadsettings - failed attempt to set width for index " + index + ", width " + string));
                } else {
                    columnModel.getColumn(index).setPreferredWidth(width);
                    searchColumnModel.getColumn(index).setPreferredWidth(width);
                }
                ++index;
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)"Error decoding a Table width", (Throwable)e);
            }
        }
        this.undockedFrame.setSize(this.getSize());
        this.undockedFrame.setLocation(this.getBounds().x, this.getBounds().y);
        this.repaint();
    }

    private int getMaxColumnWidth(int index) {
        FontMetrics metrics = this.getGraphics().getFontMetrics();
        int longestWidth = metrics.stringWidth("  " + this.table.getColumnName(index) + "  ") + 2 * this.table.getColumnModel().getColumnMargin();
        int j = this.tableModel.getRowCount();
        for (int i = 0; i < j; ++i) {
            Component c = this.renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(i, index), false, false, i, index);
            if (!(c instanceof JLabel)) continue;
            longestWidth = Math.max(longestWidth, metrics.stringWidth(((JLabel)c).getText()));
        }
        return longestWidth + 5;
    }

    private String getToolTipTextForEvent(LoggingEventWrapper loggingEventWrapper) {
        return this.detailLayout.getHeader() + this.detailLayout.format(loggingEventWrapper.getLoggingEvent()) + this.detailLayout.getFooter();
    }

    private void updateOtherModels(LoggingEvent event) {
        this.tableModel.addLoggerName(event.getLoggerName());
        this.filterModel.processNewLoggingEvent(event);
    }

    public void findNextMarker() {
        EventQueue.invokeLater(() -> {
            int nextRow;
            int filteredEventsSize;
            int startRow = this.table.getSelectedRow() + 1;
            if (startRow > (filteredEventsSize = this.getFilteredEvents().size()) - 1) {
                startRow = 0;
            }
            if ((nextRow = this.tableModel.locate(this.findMarkerRule, startRow, true)) > -1) {
                this.table.scrollToRow(nextRow);
            }
        });
    }

    public void findPreviousMarker() {
        EventQueue.invokeLater(() -> {
            int previousRow;
            int startRow = this.table.getSelectedRow() - 1;
            int filteredEventsSize = this.getFilteredEvents().size();
            if (startRow < 0) {
                startRow = filteredEventsSize - 1;
            }
            if ((previousRow = this.tableModel.locate(this.findMarkerRule, startRow, false)) > -1) {
                this.table.scrollToRow(previousRow);
            }
        });
    }

    public void clearAllMarkers() {
        this.tableModel.removePropertyFromEvents("marker");
    }

    public void toggleMarker() {
        LoggingEventWrapper loggingEventWrapper;
        int row = this.table.getSelectedRow();
        if (row != -1 && (loggingEventWrapper = this.tableModel.getRow(row)) != null) {
            String marker = loggingEventWrapper.getLoggingEvent().getProperty("marker");
            if (marker == null) {
                loggingEventWrapper.setProperty("marker", "set");
            } else {
                loggingEventWrapper.removeProperty("marker");
            }
            this.tableModel.fireRowUpdated(row, marker == null);
        }
    }

    public void layoutComponents() {
        if (this.preferenceModel.isDetailPaneVisible()) {
            this.showDetailPane();
        } else {
            this.hideDetailPane();
        }
    }

    public void setFindText(String findText) {
        this.findCombo.setSelectedItem(findText);
        this.findNext();
    }

    public String getFindText() {
        Object selectedItem = this.findCombo.getSelectedItem();
        if (selectedItem == null) {
            return "";
        }
        return selectedItem.toString();
    }

    class ToggleToolTips
    extends JCheckBoxMenuItem {
        public ToggleToolTips() {
            super("Show ToolTips", new ImageIcon(ChainsawIcons.TOOL_TIP));
            this.addActionListener(evt -> LogPanel.this.preferenceModel.setToolTips(this.isSelected()));
        }
    }

    class AutoFilterComboBox
    extends JComboBox {
        private boolean bypassFiltering;
        private List allEntries = new ArrayList();
        private List displayedEntries = new ArrayList();
        private AutoFilterComboBoxModel model = new AutoFilterComboBoxModel();
        private final JTextField textField = new JTextField();
        private String lastTextToMatch;

        public AutoFilterComboBox() {
            this.textField.setPreferredSize(this.getPreferredSize());
            this.setModel(this.model);
            this.setEditor(new AutoFilterEditor());
            ((JTextField)this.getEditor().getEditorComponent()).getDocument().addDocumentListener(new AutoFilterDocumentListener());
            this.setEditable(true);
            this.addPopupMenuListener(new PopupMenuListenerImpl());
        }

        public Vector getModelData() {
            Vector vector = new Vector();
            for (Object allEntry : this.allEntries) {
                vector.insertElementAt(allEntry, 0);
            }
            return vector;
        }

        private void refilter() {
            String textToMatch = this.getEditor().getItem().toString();
            if (this.bypassFiltering || this.lastTextToMatch != null && this.lastTextToMatch.equals(textToMatch)) {
                return;
            }
            this.lastTextToMatch = textToMatch;
            this.bypassFiltering = true;
            this.model.removeAllElements();
            ArrayList entriesCopy = new ArrayList(this.allEntries);
            for (Object anEntriesCopy : entriesCopy) {
                String thisEntry = anEntriesCopy.toString();
                if (!thisEntry.toLowerCase(Locale.ENGLISH).contains(textToMatch.toLowerCase())) continue;
                this.model.addElement(thisEntry);
            }
            this.bypassFiltering = false;
            if (this.displayedEntries.size() > 0 && !textToMatch.equals("")) {
                this.showPopup();
            } else {
                this.hidePopup();
            }
        }

        private class PopupMenuListenerImpl
        implements PopupMenuListener {
            private boolean willBecomeVisible = false;

            private PopupMenuListenerImpl() {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AutoFilterComboBox.this.bypassFiltering = true;
                ((JComboBox)e.getSource()).setSelectedIndex(-1);
                AutoFilterComboBox.this.bypassFiltering = false;
                if (!this.willBecomeVisible) {
                    if (AutoFilterComboBox.this.displayedEntries.contains(AutoFilterComboBox.this.textField.getText())) {
                        AutoFilterComboBox.this.model.showAllElements();
                    }
                    JComboBox list = (JComboBox)e.getSource();
                    this.willBecomeVisible = true;
                    try {
                        list.getUI().setPopupVisible(list, true);
                    }
                    finally {
                        this.willBecomeVisible = false;
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }

        class AutoFilterComboBoxModel
        extends AbstractListModel
        implements MutableComboBoxModel {
            private Object selectedItem;

            AutoFilterComboBoxModel() {
            }

            public void addElement(Object obj) {
                boolean entryExists;
                AutoFilterComboBox.this.bypassFiltering = true;
                boolean bl = entryExists = !AutoFilterComboBox.this.allEntries.contains(obj);
                if (entryExists) {
                    AutoFilterComboBox.this.allEntries.add(obj);
                }
                AutoFilterComboBox.this.displayedEntries.add(obj);
                if (!entryExists) {
                    this.fireIntervalAdded(this, AutoFilterComboBox.this.displayedEntries.size() - 1, AutoFilterComboBox.this.displayedEntries.size());
                }
                AutoFilterComboBox.this.bypassFiltering = false;
            }

            @Override
            public void removeElement(Object obj) {
                int index = AutoFilterComboBox.this.displayedEntries.indexOf(obj);
                if (index != -1) {
                    this.removeElementAt(index);
                }
            }

            public void insertElementAt(Object obj, int index) {
                if (AutoFilterComboBox.this.allEntries.contains(obj)) {
                    return;
                }
                AutoFilterComboBox.this.bypassFiltering = true;
                AutoFilterComboBox.this.displayedEntries.add(index, obj);
                AutoFilterComboBox.this.allEntries.add(index, obj);
                this.fireIntervalAdded(this, index, index);
                AutoFilterComboBox.this.bypassFiltering = false;
                AutoFilterComboBox.this.refilter();
            }

            @Override
            public void removeElementAt(int index) {
                AutoFilterComboBox.this.bypassFiltering = true;
                Object obj = AutoFilterComboBox.this.displayedEntries.get(index);
                AutoFilterComboBox.this.allEntries.remove(obj);
                AutoFilterComboBox.this.displayedEntries.remove(obj);
                this.fireIntervalRemoved(this, index, index);
                AutoFilterComboBox.this.bypassFiltering = false;
                AutoFilterComboBox.this.refilter();
            }

            @Override
            public void setSelectedItem(Object item) {
                if (this.selectedItem != null && !this.selectedItem.equals(item) || this.selectedItem == null && item != null) {
                    this.selectedItem = item;
                    this.fireContentsChanged(this, -1, -1);
                }
            }

            @Override
            public Object getSelectedItem() {
                return this.selectedItem;
            }

            @Override
            public int getSize() {
                return AutoFilterComboBox.this.displayedEntries.size();
            }

            @Override
            public Object getElementAt(int index) {
                if (index >= 0 && index < AutoFilterComboBox.this.displayedEntries.size()) {
                    return AutoFilterComboBox.this.displayedEntries.get(index);
                }
                return null;
            }

            public void removeAllElements() {
                AutoFilterComboBox.this.bypassFiltering = true;
                int displayedEntrySize = AutoFilterComboBox.this.displayedEntries.size();
                if (displayedEntrySize > 0) {
                    AutoFilterComboBox.this.displayedEntries.clear();
                    this.fireIntervalRemoved(this, 0, displayedEntrySize - 1);
                }
                AutoFilterComboBox.this.bypassFiltering = false;
            }

            public void showAllElements() {
                this.removeAllElements();
                AutoFilterComboBox.this.bypassFiltering = true;
                AutoFilterComboBox.this.displayedEntries.addAll(AutoFilterComboBox.this.allEntries);
                if (AutoFilterComboBox.this.displayedEntries.size() > 0) {
                    this.fireIntervalAdded(this, 0, AutoFilterComboBox.this.displayedEntries.size() - 1);
                }
                AutoFilterComboBox.this.bypassFiltering = false;
            }
        }

        class AutoFilterDocumentListener
        implements DocumentListener {
            AutoFilterDocumentListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AutoFilterComboBox.this.refilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AutoFilterComboBox.this.refilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AutoFilterComboBox.this.refilter();
            }
        }

        class AutoFilterEditor
        implements ComboBoxEditor {
            AutoFilterEditor() {
            }

            @Override
            public Component getEditorComponent() {
                return AutoFilterComboBox.this.textField;
            }

            @Override
            public void setItem(Object item) {
                if (AutoFilterComboBox.this.bypassFiltering) {
                    return;
                }
                AutoFilterComboBox.this.bypassFiltering = true;
                if (item == null) {
                    AutoFilterComboBox.this.textField.setText("");
                } else {
                    AutoFilterComboBox.this.textField.setText(item.toString());
                }
                AutoFilterComboBox.this.bypassFiltering = false;
            }

            @Override
            public Object getItem() {
                return AutoFilterComboBox.this.textField.getText();
            }

            @Override
            public void selectAll() {
                AutoFilterComboBox.this.textField.selectAll();
            }

            @Override
            public void addActionListener(ActionListener listener) {
                AutoFilterComboBox.this.textField.addActionListener(listener);
            }

            @Override
            public void removeActionListener(ActionListener listener) {
                AutoFilterComboBox.this.textField.removeActionListener(listener);
            }
        }
    }

    class ThumbnailLoggingEventWrapper {
        int rowNum;
        LoggingEventWrapper loggingEventWrapper;

        public ThumbnailLoggingEventWrapper(int rowNum, LoggingEventWrapper loggingEventWrapper) {
            this.rowNum = rowNum;
            this.loggingEventWrapper = loggingEventWrapper;
        }

        public String toString() {
            return "event - rownum: " + this.rowNum + ", level: " + this.loggingEventWrapper.getLoggingEvent().getLevel();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThumbnailLoggingEventWrapper that = (ThumbnailLoggingEventWrapper)o;
            return this.loggingEventWrapper != null ? this.loggingEventWrapper.equals(that.loggingEventWrapper) : that.loggingEventWrapper == null;
        }

        public int hashCode() {
            return this.loggingEventWrapper != null ? this.loggingEventWrapper.hashCode() : 0;
        }
    }

    abstract class AbstractEventMatchThumbnail
    extends JPanel {
        protected List<ThumbnailLoggingEventWrapper> primaryList = new ArrayList<ThumbnailLoggingEventWrapper>();
        protected List<ThumbnailLoggingEventWrapper> secondaryList = new ArrayList<ThumbnailLoggingEventWrapper>();
        protected final int maxEventHeight = 6;

        AbstractEventMatchThumbnail() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (LogPanel.this.preferenceModel.isThumbnailBarToolTips()) {
                        int yPosition = e.getPoint().y;
                        ThumbnailLoggingEventWrapper event = AbstractEventMatchThumbnail.this.getEventWrapperAtPosition(yPosition);
                        if (event != null) {
                            AbstractEventMatchThumbnail.this.setToolTipText(LogPanel.this.getToolTipTextForEvent(event.loggingEventWrapper));
                        }
                    } else {
                        AbstractEventMatchThumbnail.this.setToolTipText(null);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int yPosition = e.getPoint().y;
                    ThumbnailLoggingEventWrapper event = AbstractEventMatchThumbnail.this.getEventWrapperAtPosition(yPosition);
                    if (event != null) {
                        int id = Integer.parseInt(event.loggingEventWrapper.getLoggingEvent().getProperty("log4jid"));
                        LogPanel.this.setSelectedEvent(id);
                    }
                }
            });
            LogPanel.this.tableModel.addTableModelListener(e -> {
                int firstRow = e.getFirstRow();
                int lastRow = Math.min(e.getLastRow(), LogPanel.this.table.getRowCount() - 1);
                if (firstRow < 0 || lastRow < 0) {
                    this.primaryList.clear();
                    this.secondaryList.clear();
                }
                List displayedEvents = LogPanel.this.tableModel.getFilteredEvents();
                if (e.getType() == 1) {
                    for (int i = firstRow; i < lastRow; ++i) {
                        LoggingEventWrapper event = (LoggingEventWrapper)displayedEvents.get(i);
                        ThumbnailLoggingEventWrapper wrapper = new ThumbnailLoggingEventWrapper(i, event);
                        if (this.secondaryMatches(wrapper)) {
                            this.secondaryList.add(wrapper);
                        }
                        if (!this.primaryMatches(wrapper)) continue;
                        this.primaryList.add(wrapper);
                    }
                } else if (e.getType() == -1) {
                    ThumbnailLoggingEventWrapper wrapper;
                    Iterator<ThumbnailLoggingEventWrapper> iter = this.secondaryList.iterator();
                    while (iter.hasNext()) {
                        wrapper = iter.next();
                        if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                        iter.remove();
                    }
                    iter = this.primaryList.iterator();
                    while (iter.hasNext()) {
                        wrapper = iter.next();
                        if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                        iter.remove();
                    }
                } else if (e.getType() == 0) {
                    ThumbnailLoggingEventWrapper wrapper;
                    Iterator<ThumbnailLoggingEventWrapper> iter = this.secondaryList.iterator();
                    while (iter.hasNext()) {
                        wrapper = iter.next();
                        if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                        iter.remove();
                    }
                    iter = this.primaryList.iterator();
                    while (iter.hasNext()) {
                        wrapper = iter.next();
                        if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                        iter.remove();
                    }
                    for (int i = firstRow; i <= lastRow; ++i) {
                        LoggingEventWrapper event = (LoggingEventWrapper)displayedEvents.get(i);
                        ThumbnailLoggingEventWrapper wrapper2 = new ThumbnailLoggingEventWrapper(i, event);
                        if (this.primaryMatches(wrapper2)) {
                            this.primaryList.add(wrapper2);
                        } else {
                            this.primaryList.remove(wrapper2);
                        }
                        if (this.secondaryMatches(wrapper2)) {
                            this.secondaryList.add(wrapper2);
                            continue;
                        }
                        this.secondaryList.remove(wrapper2);
                    }
                }
                this.revalidate();
                this.repaint();
                EventQueue.invokeLater(() -> {
                    if (LogPanel.this.isScrollToBottom()) {
                        LogPanel.this.scrollToBottom();
                    }
                });
            });
        }

        abstract boolean primaryMatches(ThumbnailLoggingEventWrapper var1);

        abstract boolean secondaryMatches(ThumbnailLoggingEventWrapper var1);

        protected ThumbnailLoggingEventWrapper getEventWrapperAtPosition(int yPosition) {
            int rowCount = LogPanel.this.table.getRowCount();
            int height = LogPanel.this.eventsPane.getHeight();
            if ((yPosition = Math.max(yPosition, 0)) >= height) {
                yPosition = height;
            }
            float ratio = (float)yPosition / (float)height;
            int rowToSelect = Math.round((float)rowCount * ratio);
            ThumbnailLoggingEventWrapper event = this.getClosestRow(rowToSelect);
            return event;
        }

        private ThumbnailLoggingEventWrapper getClosestRow(int rowToSelect) {
            int newRowDelta;
            ThumbnailLoggingEventWrapper event;
            ThumbnailLoggingEventWrapper closestRow = null;
            int rowDelta = Integer.MAX_VALUE;
            Iterator<ThumbnailLoggingEventWrapper> iterator = this.secondaryList.iterator();
            while (iterator.hasNext()) {
                ThumbnailLoggingEventWrapper aSecondaryList;
                event = aSecondaryList = iterator.next();
                newRowDelta = Math.abs(rowToSelect - event.rowNum);
                if (newRowDelta >= rowDelta) continue;
                closestRow = event;
                rowDelta = newRowDelta;
            }
            iterator = this.primaryList.iterator();
            while (iterator.hasNext()) {
                ThumbnailLoggingEventWrapper aPrimaryList;
                event = aPrimaryList = iterator.next();
                newRowDelta = Math.abs(rowToSelect - event.rowNum);
                if (newRowDelta >= rowDelta) continue;
                closestRow = event;
                rowDelta = newRowDelta;
            }
            return closestRow;
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), event.getY() + 30);
        }

        protected void drawEvent(Color newColor, int verticalLocation, int eventHeight, Graphics g, int x, int width) {
            int y = verticalLocation + eventHeight / 2;
            Color oldColor = g.getColor();
            g.setColor(newColor);
            g.fillRect(x, y, width, eventHeight);
            if (eventHeight >= 3) {
                g.setColor(newColor.darker());
                g.drawRect(x, y, width, eventHeight);
            }
            g.setColor(oldColor);
        }
    }

    private class ColorizedEventAndSearchMatchThumbnail
    extends AbstractEventMatchThumbnail {
        public ColorizedEventAndSearchMatchThumbnail() {
            this.configureColors();
        }

        @Override
        boolean primaryMatches(ThumbnailLoggingEventWrapper wrapper) {
            return !wrapper.loggingEventWrapper.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND);
        }

        @Override
        boolean secondaryMatches(ThumbnailLoggingEventWrapper wrapper) {
            return wrapper.loggingEventWrapper.isSearchMatch();
        }

        private void configureColors() {
            this.secondaryList.clear();
            this.primaryList.clear();
            int i = 0;
            for (Object o : LogPanel.this.tableModel.getFilteredEvents()) {
                LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)o;
                ThumbnailLoggingEventWrapper wrapper = new ThumbnailLoggingEventWrapper(i, loggingEventWrapper);
                if (this.secondaryMatches(wrapper)) {
                    this.secondaryList.add(wrapper);
                }
                ++i;
                if (!this.primaryMatches(wrapper)) continue;
                this.primaryList.add(wrapper);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            int width;
            int startX;
            int verticalLocation;
            float ratio;
            ThumbnailLoggingEventWrapper wrapper;
            super.paintComponent(g);
            int rowCount = LogPanel.this.table.getRowCount();
            if (rowCount == 0) {
                return;
            }
            int height = LogPanel.this.eventsPane.getHeight();
            int maxHeight = Math.min(6, height / rowCount);
            int minHeight = Math.max(1, maxHeight);
            int componentHeight = height - minHeight;
            int eventHeight = minHeight;
            for (Object aPrimaryList1 : this.primaryList) {
                wrapper = (ThumbnailLoggingEventWrapper)aPrimaryList1;
                if (wrapper.loggingEventWrapper.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) || wrapper.loggingEventWrapper.getLoggingEvent().getLevel().toInt() >= Level.WARN.toInt() || wrapper.loggingEventWrapper.getLoggingEvent().getProperty("marker") != null) continue;
                ratio = (float)wrapper.rowNum / (float)rowCount;
                verticalLocation = (int)((float)componentHeight * ratio);
                startX = 1;
                width = this.getWidth() - startX * 2;
                this.drawEvent(wrapper.loggingEventWrapper.getColorRuleBackground(), verticalLocation, eventHeight, g, startX, width);
            }
            for (Object aPrimaryList : this.primaryList) {
                wrapper = (ThumbnailLoggingEventWrapper)aPrimaryList;
                if (wrapper.loggingEventWrapper.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) || wrapper.loggingEventWrapper.getLoggingEvent().getLevel().toInt() < Level.WARN.toInt() && wrapper.loggingEventWrapper.getLoggingEvent().getProperty("marker") == null) continue;
                ratio = (float)wrapper.rowNum / (float)rowCount;
                verticalLocation = (int)((float)componentHeight * ratio);
                startX = 1;
                width = this.getWidth() - startX * 2;
                eventHeight = Math.min(6, eventHeight + 3);
                this.drawEvent(wrapper.loggingEventWrapper.getColorRuleBackground(), verticalLocation - eventHeight + 1, eventHeight, g, startX, width);
            }
            for (Object aSecondaryList : this.secondaryList) {
                wrapper = (ThumbnailLoggingEventWrapper)aSecondaryList;
                ratio = (float)wrapper.rowNum / (float)rowCount;
                verticalLocation = (int)((float)componentHeight * ratio);
                startX = 1;
                width = this.getWidth() - startX * 2;
                this.drawEvent(Color.BLACK, verticalLocation, eventHeight, g, startX, width /= 2);
            }
        }
    }

    private class EventTimeDeltaMatchThumbnail
    extends AbstractEventMatchThumbnail {
        public EventTimeDeltaMatchThumbnail() {
            this.initializeLists();
        }

        @Override
        boolean primaryMatches(ThumbnailLoggingEventWrapper wrapper) {
            String millisDelta = wrapper.loggingEventWrapper.getLoggingEvent().getProperty("millisdelta");
            if (millisDelta != null && !millisDelta.trim().equals("")) {
                long millisDeltaLong = Long.parseLong(millisDelta);
                return millisDeltaLong >= 1000L;
            }
            return false;
        }

        @Override
        boolean secondaryMatches(ThumbnailLoggingEventWrapper wrapper) {
            return false;
        }

        private void initializeLists() {
            this.secondaryList.clear();
            this.primaryList.clear();
            int i = 0;
            for (Object o : LogPanel.this.tableModel.getFilteredEvents()) {
                LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)o;
                ThumbnailLoggingEventWrapper wrapper = new ThumbnailLoggingEventWrapper(i, loggingEventWrapper);
                ++i;
                if (!this.primaryMatches(wrapper)) continue;
                this.primaryList.add(wrapper);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int rowCount = LogPanel.this.table.getRowCount();
            if (rowCount == 0) {
                return;
            }
            int height = LogPanel.this.eventsPane.getHeight();
            int maxHeight = Math.min(6, height / rowCount);
            int minHeight = Math.max(1, maxHeight);
            int componentHeight = height - minHeight;
            int eventHeight = minHeight;
            for (Object aPrimaryList : this.primaryList) {
                ThumbnailLoggingEventWrapper wrapper = (ThumbnailLoggingEventWrapper)aPrimaryList;
                if (!this.primaryMatches(wrapper)) continue;
                float ratio = (float)wrapper.rowNum / (float)rowCount;
                int verticalLocation = (int)((float)componentHeight * ratio);
                int startX = 1;
                int width = this.getWidth() - startX * 2;
                String millisDelta = wrapper.loggingEventWrapper.getLoggingEvent().getProperty("millisdelta");
                long millisDeltaLong = Long.parseLong(millisDelta);
                long delta = Math.min(50L, Math.max(0L, (long)((float)millisDeltaLong * 0.002f)));
                float widthMaxMillisDeltaRenderRatio = (float)width / 50.0f;
                int widthToUse = Math.max(2, (int)((float)delta * widthMaxMillisDeltaRenderRatio));
                eventHeight = Math.min(6, eventHeight + 3);
                this.drawEvent(LogPanel.this.applicationPreferenceModel.getDeltaColor(), verticalLocation - eventHeight + 1, eventHeight, g, startX, widthToUse);
            }
        }
    }

    private class MarkerCellEditor
    implements TableCellEditor {
        JTable currentTable;
        JTextField textField = new JTextField();
        Set<CellEditorListener> cellEditorListeners = new HashSet<CellEditorListener>();
        private LoggingEventWrapper currentLoggingEventWrapper;
        private final Object mutex = new Object();

        private MarkerCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getText();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            this.textField.selectAll();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean stopCellEditing() {
            HashSet<CellEditorListener> cellEditorListenersCopy;
            if (this.textField.getText().trim().equals("")) {
                this.currentLoggingEventWrapper.removeProperty("marker");
            } else {
                this.currentLoggingEventWrapper.setProperty("marker", this.textField.getText());
            }
            LogPanel.this.tableModel.fireRowUpdated(LogPanel.this.tableModel.getRowIndex(this.currentLoggingEventWrapper), true);
            int index = LogPanel.this.searchModel.getRowIndex(this.currentLoggingEventWrapper);
            if (index > -1) {
                LogPanel.this.searchModel.fireRowUpdated(index, true);
            }
            ChangeEvent event = new ChangeEvent(this.currentTable);
            Iterator iterator = this.mutex;
            synchronized (iterator) {
                cellEditorListenersCopy = new HashSet<CellEditorListener>(this.cellEditorListeners);
            }
            for (Object e : cellEditorListenersCopy) {
                ((CellEditorListener)e).editingStopped(event);
            }
            this.currentLoggingEventWrapper = null;
            this.currentTable = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelCellEditing() {
            HashSet<CellEditorListener> cellEditorListenersCopy;
            Object object = this.mutex;
            synchronized (object) {
                cellEditorListenersCopy = new HashSet<CellEditorListener>(this.cellEditorListeners);
            }
            ChangeEvent event = new ChangeEvent(this.currentTable);
            for (Object e : cellEditorListenersCopy) {
                ((CellEditorListener)e).editingCanceled(event);
            }
            this.currentLoggingEventWrapper = null;
            this.currentTable = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener l) {
            Object object = this.mutex;
            synchronized (object) {
                this.cellEditorListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            Object object = this.mutex;
            synchronized (object) {
                this.cellEditorListeners.remove(l);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentTable = table;
            this.currentLoggingEventWrapper = ((EventContainer)table.getModel()).getRow(row);
            if (this.currentLoggingEventWrapper != null) {
                this.textField.setText(this.currentLoggingEventWrapper.getLoggingEvent().getProperty("marker"));
                this.textField.selectAll();
            } else {
                this.textField.setText("");
            }
            return this.textField;
        }
    }

    private class ThrowableDisplayMouseAdapter
    extends MouseAdapter {
        private JTable throwableTable;
        private EventContainer throwableEventContainer;
        final JDialog detailDialog;
        final JEditorPane detailArea;

        public ThrowableDisplayMouseAdapter(JTable throwableTable, EventContainer throwableEventContainer) {
            this.throwableTable = throwableTable;
            this.throwableEventContainer = throwableEventContainer;
            this.detailDialog = new JDialog((Frame)null, true);
            Container container = this.detailDialog.getContentPane();
            this.detailArea = new JEditorPane();
            JTextComponentFormatter.applySystemFontAndSize(this.detailArea);
            this.detailArea.setEditable(false);
            Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.detailArea.setPreferredSize(new Dimension(screenDimension.width / 2, screenDimension.height / 2));
            container.setLayout(new BoxLayout(container, 1));
            container.add(new JScrollPane(this.detailArea));
            this.detailDialog.pack();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableColumn column = this.throwableTable.getColumnModel().getColumn(this.throwableTable.columnAtPoint(e.getPoint()));
            if (!column.getHeaderValue().toString().toUpperCase().equals(ChainsawColumns.getColumnName(8))) {
                return;
            }
            LoggingEventWrapper loggingEventWrapper = this.throwableEventContainer.getRow(this.throwableTable.getSelectedRow());
            String[] ti = loggingEventWrapper.getLoggingEvent().getThrowableStrRep();
            if (!(ti == null || ti.length <= 0 || ti.length == 1 && ti[0].equals(""))) {
                this.detailDialog.setTitle(this.throwableTable.getColumnName(this.throwableTable.getSelectedColumn()) + " detail...");
                StringBuilder buf = new StringBuilder();
                buf.append(loggingEventWrapper.getLoggingEvent().getMessage());
                buf.append("\n");
                for (String aTi : ti) {
                    buf.append(aTi).append("\n    ");
                }
                this.detailArea.setText(buf.toString());
                SwingHelper.invokeOnEDT(() -> LogPanel.centerAndSetVisible(this.detailDialog));
            }
        }
    }

    private class DetailPaneUpdater
    implements PropertyChangeListener {
        private int selectedRow = -1;
        int lastRow = -1;

        private DetailPaneUpdater() {
        }

        private void setSelectedRow(int row) {
            this.selectedRow = row;
            this.updateDetailPane();
        }

        private void setAndUpdateSelectedRow(int row) {
            this.selectedRow = row;
            this.updateDetailPane(true);
        }

        private void updateDetailPane() {
            this.updateDetailPane(false);
        }

        private void updateDetailPane(boolean force) {
            if (!LogPanel.this.preferenceModel.isDetailPaneVisible()) {
                return;
            }
            LoggingEventWrapper loggingEventWrapper = null;
            if ((force || this.selectedRow != -1 && this.lastRow != this.selectedRow) && (loggingEventWrapper = LogPanel.this.tableModel.getRow(this.selectedRow)) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(LogPanel.this.detailLayout.getHeader()).append(LogPanel.this.detailLayout.format(loggingEventWrapper.getLoggingEvent())).append(LogPanel.this.detailLayout.getFooter());
                if (buf.length() > 0) {
                    try {
                        Document doc = LogPanel.this.detail.getEditorKit().createDefaultDocument();
                        LogPanel.this.detail.getEditorKit().read(new StringReader(buf.toString()), doc, 0);
                        SwingHelper.invokeOnEDT(() -> {
                            LogPanel.this.detail.setDocument(doc);
                            JTextComponentFormatter.applySystemFontAndSize(LogPanel.this.detail);
                            LogPanel.this.detail.setCaretPosition(0);
                            this.lastRow = this.selectedRow;
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (loggingEventWrapper == null && this.lastRow != this.selectedRow) {
                try {
                    Document doc = LogPanel.this.detail.getEditorKit().createDefaultDocument();
                    LogPanel.this.detail.getEditorKit().read(new StringReader("<html>Nothing selected</html>"), doc, 0);
                    SwingHelper.invokeOnEDT(() -> {
                        LogPanel.this.detail.setDocument(doc);
                        JTextComponentFormatter.applySystemFontAndSize(LogPanel.this.detail);
                        LogPanel.this.detail.setCaretPosition(0);
                        this.lastRow = this.selectedRow;
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            SwingUtilities.invokeLater(() -> this.updateDetailPane(true));
        }
    }

    private class ChainsawTableColumnModelListener
    implements TableColumnModelListener {
        private JSortTable modelListenerTable;

        private ChainsawTableColumnModelListener(JSortTable modelListenerTable) {
            this.modelListenerTable = modelListenerTable;
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            this.modelListenerTable.updateSortedColumn();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            this.modelListenerTable.updateSortedColumn();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private final class TableColumnDetailMouseListener
    extends MouseMotionAdapter {
        private int currentRow = -1;
        private JTable detailTable;
        private EventContainer detailEventContainer;

        private TableColumnDetailMouseListener(JTable detailTable, EventContainer detailEventContainer) {
            this.detailTable = detailTable;
            this.detailEventContainer = detailEventContainer;
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            LogPanel.this.currentPoint = evt.getPoint();
            LogPanel.this.currentTable = this.detailTable;
            if (LogPanel.this.preferenceModel.isToolTips()) {
                int row = this.detailTable.rowAtPoint(evt.getPoint());
                if (row == this.currentRow || row == -1) {
                    return;
                }
                this.currentRow = row;
                LoggingEventWrapper event = this.detailEventContainer.getRow(this.currentRow);
                if (event != null) {
                    String toolTipText = LogPanel.this.getToolTipTextForEvent(event);
                    this.detailTable.setToolTipText(toolTipText);
                }
            } else {
                this.detailTable.setToolTipText(null);
            }
        }
    }

    private final class TableMarkerListener
    extends MouseAdapter {
        private JTable markerTable;
        private EventContainer markerEventContainer;
        private EventContainer otherMarkerEventContainer;

        private TableMarkerListener(JTable markerTable, EventContainer markerEventContainer, EventContainer otherMarkerEventContainer) {
            this.markerTable = markerTable;
            this.markerEventContainer = markerEventContainer;
            this.otherMarkerEventContainer = otherMarkerEventContainer;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            LoggingEventWrapper loggingEventWrapper;
            int row;
            if (evt.getClickCount() == 2 && (row = this.markerTable.rowAtPoint(evt.getPoint())) != -1 && (loggingEventWrapper = this.markerEventContainer.getRow(row)) != null) {
                String marker = loggingEventWrapper.getLoggingEvent().getProperty("marker");
                if (marker == null) {
                    loggingEventWrapper.setProperty("marker", "set");
                } else {
                    loggingEventWrapper.removeProperty("marker");
                }
                this.markerEventContainer.fireRowUpdated(row, marker == null);
                this.otherMarkerEventContainer.fireRowUpdated(this.otherMarkerEventContainer.getRowIndex(loggingEventWrapper), marker == null);
            }
        }
    }

    private final class DelayedTextDocumentListener
    implements DocumentListener {
        private static final long CHECK_PERIOD = 1000L;
        private final JTextField textField;
        private long lastTimeStamp = System.currentTimeMillis();
        private final Thread delayThread;
        private final String defaultToolTip;
        private String lastText = "";

        private DelayedTextDocumentListener(JTextField textFeld) {
            this.textField = textFeld;
            this.defaultToolTip = textFeld.getToolTipText();
            this.delayThread = new Thread(() -> {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - this.lastTimeStamp < 1000L || System.currentTimeMillis() - this.lastTimeStamp >= 2000L || textFeld.getText().trim().equals(this.lastText.trim())) continue;
                    this.lastText = textFeld.getText();
                    EventQueue.invokeLater(this::setFilter);
                }
            });
            this.delayThread.setPriority(1);
            this.delayThread.start();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.notifyChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.notifyChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.notifyChange();
        }

        private void notifyChange() {
            this.lastTimeStamp = System.currentTimeMillis();
        }

        private void setFilter() {
            block6: {
                if (this.textField.getText().trim().equals("")) {
                    this.textField.setBackground(UIManager.getColor("TextField.background"));
                    LogPanel.this.tableRuleMediator.setFilterRule(null);
                    LogPanel.this.searchRuleMediator.setFilterRule(null);
                    this.textField.setToolTipText(this.defaultToolTip);
                    if (LogPanel.this.findRule != null) {
                        LogPanel.this.currentSearchMatchCount = LogPanel.this.tableModel.getSearchMatchCount();
                        LogPanel.this.statusBar.setSearchMatchCount(LogPanel.this.currentSearchMatchCount, LogPanel.this.getIdentifier());
                    }
                } else {
                    try {
                        LogPanel.this.tableRuleMediator.setFilterRule(ExpressionRule.getRule((String)this.textField.getText()));
                        LogPanel.this.searchRuleMediator.setFilterRule(ExpressionRule.getRule((String)this.textField.getText()));
                        this.textField.setToolTipText(this.defaultToolTip);
                        if (LogPanel.this.findRule != null) {
                            LogPanel.this.currentSearchMatchCount = LogPanel.this.tableModel.getSearchMatchCount();
                            LogPanel.this.statusBar.setSearchMatchCount(LogPanel.this.currentSearchMatchCount, LogPanel.this.getIdentifier());
                        }
                        this.textField.setBackground(UIManager.getColor("TextField.background"));
                    }
                    catch (IllegalArgumentException iae) {
                        this.textField.setToolTipText(iae.getMessage());
                        this.textField.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                        if (LogPanel.this.findRule == null) break block6;
                        LogPanel.this.currentSearchMatchCount = LogPanel.this.tableModel.getSearchMatchCount();
                        LogPanel.this.statusBar.setSearchMatchCount(LogPanel.this.currentSearchMatchCount, LogPanel.this.getIdentifier());
                    }
                }
            }
        }
    }
}

