/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.jorphan.gui.DynamicStyle;
import org.apache.jorphan.gui.FocusActions;
import org.apache.jorphan.gui.JEditableCheckBox;
import org.apiguardian.api.API;

@API(since="5.3", status=API.Status.EXPERIMENTAL)
public class JFactory {
    private static final String SIZE_VARIANT = "JComponent.sizeVariant";
    private static final DynamicStyle STYLE = new DynamicStyle();

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static void refreshUI() {
        STYLE.updateLaf();
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static void refreshUI(String className) {
        STYLE.updateLaf(className);
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JTextArea tabMovesFocus(JTextArea textArea) {
        return STYLE.withDynamic(textArea, c -> FocusActions.bind(c, KeyStroke.getKeyStroke(9, 0), KeyStroke.getKeyStroke(9, 64)));
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JButton small(JButton component) {
        component.putClientProperty(SIZE_VARIANT, "small");
        return STYLE.withFont(component, "[jmeter]Button.smallFont");
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JLabel small(JLabel component) {
        return STYLE.withFont(component, "[jmeter]Label.smallFont");
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JTextField small(JTextField component) {
        component.putClientProperty(SIZE_VARIANT, "small");
        return STYLE.withFont(component, "[jmeter]TextField.smallFont");
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JCheckBox small(JCheckBox component) {
        component.putClientProperty(SIZE_VARIANT, "small");
        return STYLE.withFont(component, "[jmeter]CheckBox.smallFont");
    }

    @API(since="5.6", status=API.Status.EXPERIMENTAL)
    public static JEditableCheckBox small(JEditableCheckBox component) {
        component.makeSmall();
        return component;
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JLabel big(JLabel component) {
        return STYLE.withFont(component, "[jmeter]Label.bigFont");
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JToolBar small(JToolBar component) {
        return STYLE.withFont(component, "[jmeter]ToolBar.smallFont");
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JTable singleLineRowHeight(JTable component) {
        return STYLE.withDynamic(component, c -> {
            int rowHeight = UIManager.getInt("Table.rowHeight");
            if (rowHeight != 0) {
                c.setRowHeight(rowHeight);
            }
        });
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JLabel error(JLabel component) {
        return STYLE.withDynamic(component, c -> {
            c.setFont(UIManager.getFont("[jmeter]Label.errorFont"));
            c.setForeground(UIManager.getColor("[jmeter]Label.errorForeground"));
        });
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static JLabel warning(JLabel component) {
        return STYLE.withDynamic(component, c -> {
            c.setFont(UIManager.getFont("[jmeter]Label.warningFont"));
            c.setForeground(UIManager.getColor("[jmeter]Label.warningForeground"));
        });
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static <T extends JComponent> T withDynamic(T component, Consumer<? super T> onUpdateUi) {
        return STYLE.withDynamic(component, onUpdateUi);
    }

    public static void updateUi(JComponent c) {
        STYLE.updateComponentTreeUI(c);
    }
}

