/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.jmeter.save.converters.ConversionHelp;
import org.apache.jmeter.testelement.property.StringProperty;

public class StringPropertyConverter
implements Converter {
    public static String getVersion() {
        return "$Revision$";
    }

    public boolean canConvert(Class arg0) {
        return StringProperty.class.equals((Object)arg0);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext arg2) {
        StringProperty prop = (StringProperty)obj;
        writer.addAttribute("name", ConversionHelp.encode(prop.getName()));
        writer.setValue(ConversionHelp.encode(prop.getStringValue()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String name = ConversionHelp.getPropertyName(reader, context);
        if (name == null) {
            return null;
        }
        String value = ConversionHelp.getPropertyValue(reader, context, name);
        StringProperty prop = new StringProperty(name, value);
        return prop;
    }
}

