/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class JvmClasses
implements PlainJsonSerializable {
    private final long currentLoadedCount;
    private final long totalLoadedCount;
    private final long totalUnloadedCount;
    public static final JsonpDeserializer<JvmClasses> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmClasses::setupJvmClassesDeserializer);

    private JvmClasses(Builder builder) {
        this.currentLoadedCount = ApiTypeHelper.requireNonNull(builder.currentLoadedCount, this, "currentLoadedCount");
        this.totalLoadedCount = ApiTypeHelper.requireNonNull(builder.totalLoadedCount, this, "totalLoadedCount");
        this.totalUnloadedCount = ApiTypeHelper.requireNonNull(builder.totalUnloadedCount, this, "totalUnloadedCount");
    }

    public static JvmClasses of(Function<Builder, ObjectBuilder<JvmClasses>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long currentLoadedCount() {
        return this.currentLoadedCount;
    }

    public final long totalLoadedCount() {
        return this.totalLoadedCount;
    }

    public final long totalUnloadedCount() {
        return this.totalUnloadedCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_loaded_count");
        generator.write(this.currentLoadedCount);
        generator.writeKey("total_loaded_count");
        generator.write(this.totalLoadedCount);
        generator.writeKey("total_unloaded_count");
        generator.write(this.totalUnloadedCount);
    }

    protected static void setupJvmClassesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentLoadedCount, JsonpDeserializer.longDeserializer(), "current_loaded_count");
        op.add(Builder::totalLoadedCount, JsonpDeserializer.longDeserializer(), "total_loaded_count");
        op.add(Builder::totalUnloadedCount, JsonpDeserializer.longDeserializer(), "total_unloaded_count");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<JvmClasses> {
        private Long currentLoadedCount;
        private Long totalLoadedCount;
        private Long totalUnloadedCount;

        public final Builder currentLoadedCount(long value) {
            this.currentLoadedCount = value;
            return this;
        }

        public final Builder totalLoadedCount(long value) {
            this.totalLoadedCount = value;
            return this;
        }

        public final Builder totalUnloadedCount(long value) {
            this.totalUnloadedCount = value;
            return this;
        }

        @Override
        public JvmClasses build() {
            this._checkSingleUse();
            return new JvmClasses(this);
        }
    }
}

