/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CachingTextExtractor
implements TextExtractor {
    private final TextExtractor underlying;
    private final AsyncCache<String, ParsedContent> cache;
    private final Metric weightMetric;

    public CachingTextExtractor(TextExtractor underlying, Duration cacheEvictionPeriod, Long cacheWeightInBytes, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this.underlying = underlying;
        this.weightMetric = metricFactory.generate("textExtractor.cache.weight");
        RemovalListener removalListener = (key, value, removalCause) -> Optional.ofNullable(value).map(this::computeWeight).ifPresent(arg_0 -> ((Metric)this.weightMetric).remove(arg_0));
        Weigher weigher = (key, parsedContent) -> this.computeWeight((ParsedContent)parsedContent);
        this.cache = Caffeine.newBuilder().expireAfterAccess(cacheEvictionPeriod).maximumWeight(cacheWeightInBytes.longValue()).weigher(weigher).evictionListener(removalListener).recordStats().buildAsync();
        this.recordStats(gaugeRegistry);
    }

    public void recordStats(GaugeRegistry gaugeRegistry) {
        gaugeRegistry.register("textExtractor.cache.hit.rate", () -> this.cache.synchronous().stats().hitRate()).register("textExtractor.cache.hit.count", () -> this.cache.synchronous().stats().hitCount());
        gaugeRegistry.register("textExtractor.cache.load.count", () -> this.cache.synchronous().stats().loadCount()).register("textExtractor.cache.eviction.count", () -> this.cache.synchronous().stats().evictionCount()).register("textExtractor.cache.load.exception.rate", () -> this.cache.synchronous().stats().loadFailureRate()).register("textExtractor.cache.load.miss.rate", () -> this.cache.synchronous().stats().missRate()).register("textExtractor.cache.load.miss.count", () -> this.cache.synchronous().stats().missCount()).register("textExtractor.cache.size", () -> ((Cache)this.cache.synchronous()).estimatedSize());
    }

    private int computeWeight(ParsedContent parsedContent) {
        return parsedContent.getTextualContent().map(String::length).map(this::utf16LengthToBytesCount).orElse(0);
    }

    private int utf16LengthToBytesCount(Integer value) {
        return value * 2;
    }

    public Mono<ParsedContent> extractContentReactive(InputStream inputStream, ContentType contentType) {
        return Mono.fromCallable(() -> IOUtils.toByteArray((InputStream)inputStream)).subscribeOn(Schedulers.boundedElastic()).flatMap(bytes -> Mono.fromCallable(() -> Hashing.sha256().hashBytes(bytes).toString()).subscribeOn(Schedulers.parallel()).publishOn(Schedulers.boundedElastic()).flatMap(key -> Mono.fromFuture((CompletableFuture)this.cache.get(key, (a, b) -> this.retrieveAndUpdateWeight((byte[])bytes, contentType).toFuture()))));
    }

    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) {
        return (ParsedContent)this.extractContentReactive(inputStream, contentType).block();
    }

    private Mono<ParsedContent> retrieveAndUpdateWeight(byte[] bytes, ContentType contentType) {
        return this.underlying.extractContentReactive((InputStream)new ByteArrayInputStream(bytes), contentType).doOnNext(next -> this.weightMetric.add(this.computeWeight((ParsedContent)next)));
    }
}

