/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.apache.james.mailbox.opensearch.IndexAttachments;
import org.apache.james.mailbox.opensearch.IndexBody;
import org.apache.james.mailbox.opensearch.IndexHeaders;
import org.apache.james.mailbox.opensearch.MailboxOpenSearchConstants;
import org.apache.james.mailbox.opensearch.json.MessageToOpenSearchJson;

public class OpenSearchMailboxConfiguration {
    private static final String OPENSEARCH_INDEX_NAME = "opensearch.index.name";
    private static final String OPENSEARCH_INDEX_MAILBOX_NAME = "opensearch.index.mailbox.name";
    private static final String OPENSEARCH_ALIAS_READ_NAME = "opensearch.alias.read.name";
    private static final String OPENSEARCH_ALIAS_WRITE_NAME = "opensearch.alias.write.name";
    private static final String OPENSEARCH_ALIAS_READ_MAILBOX_NAME = "opensearch.alias.read.mailbox.name";
    private static final String OPENSEARCH_ALIAS_WRITE_MAILBOX_NAME = "opensearch.alias.write.mailbox.name";
    private static final String OPENSEARCH_INDEX_ATTACHMENTS = "opensearch.indexAttachments";
    private static final String OPENSEARCH_INDEX_HEADERS = "opensearch.indexHeaders";
    private static final String OPENSEARCH_MESSAGE_INDEX_OPTIMIZE_MOVE = "opensearch.message.index.optimize.move";
    private static final String OPENSEARCH_TEXT_FUZZINESS_SEARCH = "opensearch.text.fuzziness.search";
    private static final String OPENSEARCH_TEXT_STRING_QUERY = "opensearch.text.string.query";
    private static final String OPENSEARCH_INDEX_BODY = "opensearch.indexBody";
    private static final String OPENSEARCH_INDEX_USER = "opensearch.indexUser";
    private static final boolean DEFAULT_INDEX_ATTACHMENTS = true;
    private static final boolean DEFAULT_INDEX_HEADERS = true;
    public static final boolean DEFAULT_OPTIMIZE_MOVES = false;
    public static final boolean DEFAULT_TEXT_FUZZINESS_SEARCH = false;
    public static final boolean DEFAULT_USE_SIMPLE_TEXT_QUERY = false;
    public static final boolean DEFAULT_INDEX_BODY = true;
    public static final boolean DEFAULT_INDEX_USER = false;
    public static final OpenSearchMailboxConfiguration DEFAULT_CONFIGURATION = OpenSearchMailboxConfiguration.builder().build();
    private final IndexName indexMailboxName;
    private final ReadAliasName readAliasMailboxName;
    private final WriteAliasName writeAliasMailboxName;
    private final IndexAttachments indexAttachment;
    private final IndexHeaders indexHeaders;
    private final boolean optimiseMoves;
    private final boolean textFuzzinessSearch;
    private final boolean useQueryStringQuery;
    private final IndexBody indexBody;
    private final MessageToOpenSearchJson.IndexUser indexUser;

    public static Builder builder() {
        return new Builder();
    }

    public static OpenSearchMailboxConfiguration fromProperties(Configuration configuration) {
        return OpenSearchMailboxConfiguration.builder().indexMailboxName(OpenSearchMailboxConfiguration.computeMailboxIndexName(configuration)).readAliasMailboxName(OpenSearchMailboxConfiguration.computeMailboxReadAlias(configuration)).writeAliasMailboxName(OpenSearchMailboxConfiguration.computeMailboxWriteAlias(configuration)).indexAttachment(OpenSearchMailboxConfiguration.provideIndexAttachments(configuration)).indexHeaders(OpenSearchMailboxConfiguration.provideIndexHeaders(configuration)).optimiseMoves(configuration.getBoolean(OPENSEARCH_MESSAGE_INDEX_OPTIMIZE_MOVE, null)).textFuzzinessSearch(configuration.getBoolean(OPENSEARCH_TEXT_FUZZINESS_SEARCH, null)).useQueryStringQuery(configuration.getBoolean(OPENSEARCH_TEXT_STRING_QUERY, null)).indexBody(OpenSearchMailboxConfiguration.provideIndexBody(configuration)).indexUser(OpenSearchMailboxConfiguration.provideIndexUser(configuration)).build();
    }

    static Optional<IndexName> computeMailboxIndexName(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(OPENSEARCH_INDEX_MAILBOX_NAME)).map(IndexName::new).or(() -> Optional.ofNullable(configuration.getString(OPENSEARCH_INDEX_NAME)).map(IndexName::new));
    }

    static Optional<WriteAliasName> computeMailboxWriteAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_WRITE_MAILBOX_NAME)).map(WriteAliasName::new).or(() -> Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_WRITE_NAME)).map(WriteAliasName::new));
    }

    static Optional<ReadAliasName> computeMailboxReadAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_READ_MAILBOX_NAME)).map(ReadAliasName::new).or(() -> Optional.ofNullable(configuration.getString(OPENSEARCH_ALIAS_READ_NAME)).map(ReadAliasName::new));
    }

    private static IndexAttachments provideIndexAttachments(Configuration configuration) {
        if (configuration.getBoolean(OPENSEARCH_INDEX_ATTACHMENTS, true)) {
            return IndexAttachments.YES;
        }
        return IndexAttachments.NO;
    }

    private static IndexHeaders provideIndexHeaders(Configuration configuration) {
        if (configuration.getBoolean(OPENSEARCH_INDEX_HEADERS, true)) {
            return IndexHeaders.YES;
        }
        return IndexHeaders.NO;
    }

    private static IndexBody provideIndexBody(Configuration configuration) {
        if (configuration.getBoolean(OPENSEARCH_INDEX_BODY, true)) {
            return IndexBody.YES;
        }
        return IndexBody.NO;
    }

    private static MessageToOpenSearchJson.IndexUser provideIndexUser(Configuration configuration) {
        if (configuration.getBoolean(OPENSEARCH_INDEX_USER, false)) {
            return MessageToOpenSearchJson.IndexUser.YES;
        }
        return MessageToOpenSearchJson.IndexUser.NO;
    }

    private OpenSearchMailboxConfiguration(IndexName indexMailboxName, ReadAliasName readAliasMailboxName, WriteAliasName writeAliasMailboxName, IndexAttachments indexAttachment, IndexHeaders indexHeaders, boolean optimiseMoves, boolean textFuzzinessSearch, boolean useSimpleTextQuery, IndexBody indexBody, MessageToOpenSearchJson.IndexUser indexUser) {
        this.indexMailboxName = indexMailboxName;
        this.readAliasMailboxName = readAliasMailboxName;
        this.writeAliasMailboxName = writeAliasMailboxName;
        this.indexAttachment = indexAttachment;
        this.indexHeaders = indexHeaders;
        this.optimiseMoves = optimiseMoves;
        this.textFuzzinessSearch = textFuzzinessSearch;
        this.useQueryStringQuery = useSimpleTextQuery;
        this.indexBody = indexBody;
        this.indexUser = indexUser;
    }

    public IndexName getIndexMailboxName() {
        return this.indexMailboxName;
    }

    public ReadAliasName getReadAliasMailboxName() {
        return this.readAliasMailboxName;
    }

    public WriteAliasName getWriteAliasMailboxName() {
        return this.writeAliasMailboxName;
    }

    public IndexAttachments getIndexAttachment() {
        return this.indexAttachment;
    }

    public IndexHeaders getIndexHeaders() {
        return this.indexHeaders;
    }

    public boolean isOptimiseMoves() {
        return this.optimiseMoves;
    }

    public boolean textFuzzinessSearchEnable() {
        return this.textFuzzinessSearch;
    }

    public IndexBody getIndexBody() {
        return this.indexBody;
    }

    public MessageToOpenSearchJson.IndexUser getIndexUser() {
        return this.indexUser;
    }

    public boolean isUseQueryStringQuery() {
        return this.useQueryStringQuery;
    }

    public final boolean equals(Object o) {
        if (o instanceof OpenSearchMailboxConfiguration) {
            OpenSearchMailboxConfiguration that = (OpenSearchMailboxConfiguration)o;
            return Objects.equals((Object)this.indexAttachment, (Object)that.indexAttachment) && Objects.equals((Object)this.indexHeaders, (Object)that.indexHeaders) && Objects.equals(this.indexMailboxName, that.indexMailboxName) && Objects.equals(this.readAliasMailboxName, that.readAliasMailboxName) && Objects.equals(this.optimiseMoves, that.optimiseMoves) && Objects.equals(this.textFuzzinessSearch, that.textFuzzinessSearch) && Objects.equals(this.useQueryStringQuery, that.useQueryStringQuery) && Objects.equals(this.writeAliasMailboxName, that.writeAliasMailboxName) && Objects.equals((Object)this.indexBody, (Object)that.indexBody) && Objects.equals((Object)this.indexUser, (Object)that.indexUser);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.indexMailboxName, this.readAliasMailboxName, this.writeAliasMailboxName, this.indexAttachment, this.indexHeaders, this.writeAliasMailboxName, this.optimiseMoves, this.textFuzzinessSearch, this.useQueryStringQuery, this.indexBody, this.indexUser});
    }

    public static class Builder {
        private Optional<IndexName> indexMailboxName = Optional.empty();
        private Optional<ReadAliasName> readAliasMailboxName = Optional.empty();
        private Optional<WriteAliasName> writeAliasMailboxName = Optional.empty();
        private Optional<IndexAttachments> indexAttachment = Optional.empty();
        private Optional<IndexHeaders> indexHeaders = Optional.empty();
        private Optional<Boolean> optimiseMoves = Optional.empty();
        private Optional<Boolean> textFuzzinessSearch = Optional.empty();
        private Optional<Boolean> useQueryStringQuery = Optional.empty();
        private Optional<IndexBody> indexBody = Optional.empty();
        private Optional<MessageToOpenSearchJson.IndexUser> indexUser = Optional.empty();

        Builder() {
        }

        public Builder indexMailboxName(Optional<IndexName> indexMailboxName) {
            this.indexMailboxName = indexMailboxName;
            return this;
        }

        public Builder readAliasMailboxName(Optional<ReadAliasName> readAliasMailboxName) {
            this.readAliasMailboxName = readAliasMailboxName;
            return this;
        }

        public Builder writeAliasMailboxName(Optional<WriteAliasName> writeAliasMailboxName) {
            this.writeAliasMailboxName = writeAliasMailboxName;
            return this;
        }

        public Builder indexAttachment(IndexAttachments indexAttachment) {
            this.indexAttachment = Optional.of(indexAttachment);
            return this;
        }

        public Builder indexHeaders(IndexHeaders indexHeaders) {
            this.indexHeaders = Optional.of(indexHeaders);
            return this;
        }

        public Builder optimiseMoves(Boolean optimiseMoves) {
            this.optimiseMoves = Optional.ofNullable(optimiseMoves);
            return this;
        }

        public Builder textFuzzinessSearch(Boolean textFuzzinessSearch) {
            this.textFuzzinessSearch = Optional.ofNullable(textFuzzinessSearch);
            return this;
        }

        public Builder useQueryStringQuery(Boolean useQueryStringQuery) {
            this.useQueryStringQuery = Optional.ofNullable(useQueryStringQuery);
            return this;
        }

        public Builder indexBody(IndexBody indexBody) {
            this.indexBody = Optional.ofNullable(indexBody);
            return this;
        }

        public Builder indexUser(MessageToOpenSearchJson.IndexUser indexUser) {
            this.indexUser = Optional.ofNullable(indexUser);
            return this;
        }

        public OpenSearchMailboxConfiguration build() {
            return new OpenSearchMailboxConfiguration(this.indexMailboxName.orElse(MailboxOpenSearchConstants.DEFAULT_MAILBOX_INDEX), this.readAliasMailboxName.orElse(MailboxOpenSearchConstants.DEFAULT_MAILBOX_READ_ALIAS), this.writeAliasMailboxName.orElse(MailboxOpenSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS), this.indexAttachment.orElse(IndexAttachments.YES), this.indexHeaders.orElse(IndexHeaders.YES), this.optimiseMoves.orElse(false), this.textFuzzinessSearch.orElse(false), this.useQueryStringQuery.orElse(false), this.indexBody.orElse(IndexBody.YES), this.indexUser.orElse(MessageToOpenSearchJson.IndexUser.NO));
        }
    }
}

