/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import jakarta.mail.Flags;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;

public class StorageDirective {
    private static final String DELIVERY_PATH_PREFIX = "DeliveryPath_";
    private static final String DELIVERY_PATHS_PREFIX = "DeliveryPaths_";
    private static final String SEEN_PREFIX = "Seen_";
    private static final String IMPORTANT_PREFIX = "Important_";
    private static final String KEYWORDS_PREFIX = "Keywords_";
    private final Optional<Collection<String>> targetFolder;
    private final Optional<Boolean> seen;
    private final Optional<Boolean> important;
    private final Optional<Collection<String>> keywords;

    public static Builder builder() {
        return new Builder();
    }

    public static StorageDirective fromMail(Username username, Mail mail) {
        Optional<Attribute> seen = mail.getAttribute(AttributeName.of(SEEN_PREFIX + username.asString()));
        Optional<Attribute> important = mail.getAttribute(AttributeName.of(IMPORTANT_PREFIX + username.asString()));
        Optional<Attribute> keywords = mail.getAttribute(AttributeName.of(KEYWORDS_PREFIX + username.asString()));
        return new StorageDirective(StorageDirective.locateFolder(username, mail), StorageDirective.asBooleanOptional(seen), StorageDirective.asBooleanOptional(important), StorageDirective.extractKeywords(keywords));
    }

    private static Optional<Collection<String>> extractKeywords(Optional<Attribute> keywords) {
        Stream<Object> stream = keywords.map(Attribute::getValue).map(AttributeValue::getValue).filter(Collection.class::isInstance).map(Collection.class::cast).stream().flatMap(Collection::stream).filter(AttributeValue.class::isInstance).map(AttributeValue.class::cast).map(a -> ((AttributeValue)a).getValue()).filter(String.class::isInstance).map(String.class::cast);
        Collection result = (Collection)stream.collect(ImmutableSet.toImmutableSet());
        return Optional.of(result).filter(c -> !c.isEmpty());
    }

    private static Optional<Boolean> asBooleanOptional(Optional<Attribute> attr) {
        return attr.map(Attribute::getValue).map(AttributeValue::getValue).filter(Boolean.class::isInstance).map(Boolean.class::cast);
    }

    private static Optional<Collection<String>> locateFolder(Username username, Mail mail) {
        AttributeName foldersAttribute = AttributeName.of(DELIVERY_PATHS_PREFIX + username.asString());
        if (mail.getAttribute(foldersAttribute).isPresent()) {
            return AttributeUtils.getValueAndCastFromMail(mail, foldersAttribute, Collection.class).map(collection -> collection).map(collection -> (Collection)collection.stream().map(AttributeValue::getValue).map(String.class::cast).collect(ImmutableList.toImmutableList()));
        }
        return AttributeUtils.getValueAndCastFromMail(mail, AttributeName.of(DELIVERY_PATH_PREFIX + username.asString()), String.class).map(ImmutableList::of);
    }

    private StorageDirective(Optional<Collection<String>> targetFolder, Optional<Boolean> seen, Optional<Boolean> important, Optional<Collection<String>> keywords) {
        this.targetFolder = targetFolder;
        this.seen = seen;
        this.important = important;
        this.keywords = keywords;
    }

    public Optional<Flags> getFlags() {
        if (this.seen.isEmpty() && this.important.isEmpty() && this.keywords.isEmpty()) {
            return Optional.empty();
        }
        Flags flags = new Flags();
        this.seen.ifPresent(seenFlag -> {
            if (seenFlag.booleanValue()) {
                flags.add(Flags.Flag.SEEN);
            }
        });
        this.important.ifPresent(seenFlag -> {
            if (seenFlag.booleanValue()) {
                flags.add(Flags.Flag.FLAGGED);
            }
        });
        this.keywords.stream().flatMap(Collection::stream).forEach(arg_0 -> ((Flags)flags).add(arg_0));
        return Optional.of(flags);
    }

    public Stream<Attribute> encodeAsAttributes(Username username) {
        return Stream.of(this.targetFolder.map(value -> new Attribute(AttributeName.of(DELIVERY_PATHS_PREFIX + username.asString()), this.asAttributeValue((Collection<String>)value))), this.seen.map(value -> new Attribute(AttributeName.of(SEEN_PREFIX + username.asString()), AttributeValue.of(value))), this.important.map(value -> new Attribute(AttributeName.of(IMPORTANT_PREFIX + username.asString()), AttributeValue.of(value))), this.keywords.map(value -> new Attribute(AttributeName.of(KEYWORDS_PREFIX + username.asString()), this.asAttributeValue((Collection<String>)value)))).flatMap(Optional::stream);
    }

    private AttributeValue asAttributeValue(Collection<String> value) {
        return AttributeValue.of((Collection)value.stream().map(AttributeValue::of).collect(ImmutableSet.toImmutableSet()));
    }

    public StorageDirective withDefaultFolder(String folder) {
        if (this.targetFolder.isEmpty()) {
            return new StorageDirective(Optional.of(ImmutableList.of((Object)folder)), this.seen, this.important, this.keywords);
        }
        return this;
    }

    public Optional<Collection<String>> getTargetFolders() {
        return this.targetFolder;
    }

    public final boolean equals(Object o) {
        if (o instanceof StorageDirective) {
            StorageDirective other = (StorageDirective)o;
            return Objects.equals(this.targetFolder, other.targetFolder) && Objects.equals(this.seen, other.seen) && Objects.equals(this.important, other.important) && Objects.equals(this.keywords, other.keywords);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.targetFolder, this.seen, this.important, this.keywords);
    }

    public static class Builder {
        private ImmutableList.Builder<String> targetFolders = ImmutableList.builder();
        private Optional<Boolean> seen = Optional.empty();
        private Optional<Boolean> important = Optional.empty();
        private Optional<Collection<String>> keywords = Optional.empty();

        public Builder seen(Optional<Boolean> value) {
            this.seen = value;
            return this;
        }

        public Builder important(Optional<Boolean> value) {
            this.important = value;
            return this;
        }

        public Builder targetFolder(Optional<String> value) {
            value.ifPresent(arg_0 -> this.targetFolders.add(arg_0));
            return this;
        }

        public Builder targetFolder(String value) {
            this.targetFolders.add((Object)value);
            return this;
        }

        public Builder targetFolders(Collection<String> values) {
            this.targetFolders.addAll(values);
            return this;
        }

        public Builder targetFolders(Optional<List<String>> values) {
            values.ifPresent(this::targetFolders);
            return this;
        }

        public Builder keywords(Optional<Collection<String>> value) {
            this.keywords = value;
            return this;
        }

        public StorageDirective build() {
            Preconditions.checkState((boolean)this.hasChanges(), (Object)"Expecting one of the storage directives to be specified: [targetFolder, seen, important, keywords]");
            Optional<Collection<String>> targetFolders = Optional.of(this.targetFolders.build()).filter(c -> !c.isEmpty()).map(c -> c);
            return new StorageDirective(targetFolders, this.seen, this.important, this.keywords);
        }

        private boolean hasChanges() {
            return Booleans.countTrue((boolean[])new boolean[]{this.seen.isPresent(), this.important.isPresent(), !this.targetFolders.build().isEmpty(), this.keywords.isPresent()}) > 0;
        }

        public Optional<StorageDirective> buildOptional() {
            if (!this.hasChanges()) {
                return Optional.empty();
            }
            return Optional.of(this.build());
        }
    }
}

