/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Map;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.ACLResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class ACLResponseEncoder
implements ImapResponseEncoder<ACLResponse> {
    @Override
    public void encode(ACLResponse aclResponse, ImapResponseComposer composer) throws IOException {
        Map entries = aclResponse.getAcl().getEntries();
        composer.untagged();
        composer.message("ACL");
        String mailboxName = aclResponse.getMailboxName();
        composer.mailbox(mailboxName == null ? "" : mailboxName);
        if (entries != null) {
            for (Map.Entry entry : entries.entrySet()) {
                String identifier = ((MailboxACL.EntryKey)entry.getKey()).serialize();
                composer.quote(identifier);
                String rights = ((MailboxACL.Rfc4314Rights)entry.getValue()).serialize();
                composer.quote(rights == null ? "" : rights);
            }
        }
        composer.end();
    }

    @Override
    public Class<ACLResponse> acceptableMessages() {
        return ACLResponse.class;
    }
}

