/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core.util;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return ClassUtil.class.getClassLoader();
    }

    public static Class<?> loadClassOptional(String className, boolean ignoreBrokenClasses) {
        ClassLoader cl = ClassUtil.getClassLoader();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            if (ignoreBrokenClasses) {
                return null;
            }
            throw ncdfe;
        }
    }
}

