/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.quota;

import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.james.backends.jpa.TransactionRunner;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.jpa.quota.model.MaxDomainMessageCount;
import org.apache.james.mailbox.jpa.quota.model.MaxDomainStorage;
import org.apache.james.mailbox.jpa.quota.model.MaxGlobalMessageCount;
import org.apache.james.mailbox.jpa.quota.model.MaxGlobalStorage;
import org.apache.james.mailbox.jpa.quota.model.MaxUserMessageCount;
import org.apache.james.mailbox.jpa.quota.model.MaxUserStorage;
import org.apache.james.mailbox.model.QuotaRoot;

public class JPAPerUserMaxQuotaDAO {
    private static final long INFINITE = -1L;
    private final TransactionRunner transactionRunner;

    @Inject
    public JPAPerUserMaxQuotaDAO(EntityManagerFactory entityManagerFactory) {
        this.transactionRunner = new TransactionRunner(entityManagerFactory);
    }

    public void setMaxStorage(QuotaRoot quotaRoot, Optional<QuotaSizeLimit> maxStorageQuota) {
        this.transactionRunner.run(entityManager -> {
            MaxUserStorage storedValue = this.getMaxUserStorageEntity((EntityManager)entityManager, quotaRoot, maxStorageQuota);
            entityManager.persist((Object)storedValue);
        });
    }

    private MaxUserStorage getMaxUserStorageEntity(EntityManager entityManager, QuotaRoot quotaRoot, Optional<QuotaSizeLimit> maxStorageQuota) {
        MaxUserStorage storedValue = (MaxUserStorage)entityManager.find(MaxUserStorage.class, (Object)quotaRoot.getValue());
        Long value = this.quotaValueToLong(maxStorageQuota);
        if (storedValue == null) {
            return new MaxUserStorage(quotaRoot.getValue(), value);
        }
        storedValue.setValue(value);
        return storedValue;
    }

    public void setMaxMessage(QuotaRoot quotaRoot, Optional<QuotaCountLimit> maxMessageCount) {
        this.transactionRunner.run(entityManager -> {
            MaxUserMessageCount storedValue = this.getMaxUserMessageEntity((EntityManager)entityManager, quotaRoot, maxMessageCount);
            entityManager.persist((Object)storedValue);
        });
    }

    private MaxUserMessageCount getMaxUserMessageEntity(EntityManager entityManager, QuotaRoot quotaRoot, Optional<QuotaCountLimit> maxMessageQuota) {
        MaxUserMessageCount storedValue = (MaxUserMessageCount)entityManager.find(MaxUserMessageCount.class, (Object)quotaRoot.getValue());
        Long value = this.quotaValueToLong(maxMessageQuota);
        if (storedValue == null) {
            return new MaxUserMessageCount(quotaRoot.getValue(), value);
        }
        storedValue.setValue(value);
        return storedValue;
    }

    public void setDomainMaxMessage(Domain domain, Optional<QuotaCountLimit> count) {
        this.transactionRunner.run(entityManager -> {
            MaxDomainMessageCount storedValue = this.getMaxDomainMessageEntity((EntityManager)entityManager, domain, count);
            entityManager.persist((Object)storedValue);
        });
    }

    public void setDomainMaxStorage(Domain domain, Optional<QuotaSizeLimit> size) {
        this.transactionRunner.run(entityManager -> {
            MaxDomainStorage storedValue = this.getMaxDomainStorageEntity((EntityManager)entityManager, domain, size);
            entityManager.persist((Object)storedValue);
        });
    }

    private MaxDomainMessageCount getMaxDomainMessageEntity(EntityManager entityManager, Domain domain, Optional<QuotaCountLimit> maxMessageQuota) {
        MaxDomainMessageCount storedValue = (MaxDomainMessageCount)entityManager.find(MaxDomainMessageCount.class, (Object)domain.asString());
        Long value = this.quotaValueToLong(maxMessageQuota);
        if (storedValue == null) {
            return new MaxDomainMessageCount(domain, value);
        }
        storedValue.setValue(value);
        return storedValue;
    }

    private MaxDomainStorage getMaxDomainStorageEntity(EntityManager entityManager, Domain domain, Optional<QuotaSizeLimit> maxStorageQuota) {
        MaxDomainStorage storedValue = (MaxDomainStorage)entityManager.find(MaxDomainStorage.class, (Object)domain.asString());
        Long value = this.quotaValueToLong(maxStorageQuota);
        if (storedValue == null) {
            return new MaxDomainStorage(domain, value);
        }
        storedValue.setValue(value);
        return storedValue;
    }

    public void setGlobalMaxStorage(Optional<QuotaSizeLimit> globalMaxStorage) {
        this.transactionRunner.run(entityManager -> {
            MaxGlobalStorage globalMaxStorageEntity = this.getGlobalMaxStorageEntity((EntityManager)entityManager, globalMaxStorage);
            entityManager.persist((Object)globalMaxStorageEntity);
        });
    }

    private MaxGlobalStorage getGlobalMaxStorageEntity(EntityManager entityManager, Optional<QuotaSizeLimit> maxSizeQuota) {
        MaxGlobalStorage storedValue = (MaxGlobalStorage)entityManager.find(MaxGlobalStorage.class, (Object)"default_key");
        Long value = this.quotaValueToLong(maxSizeQuota);
        if (storedValue == null) {
            return new MaxGlobalStorage(value);
        }
        storedValue.setValue(value);
        return storedValue;
    }

    public void setGlobalMaxMessage(Optional<QuotaCountLimit> globalMaxMessageCount) {
        this.transactionRunner.run(entityManager -> {
            MaxGlobalMessageCount globalMaxMessageEntity = this.getGlobalMaxMessageEntity((EntityManager)entityManager, globalMaxMessageCount);
            entityManager.persist((Object)globalMaxMessageEntity);
        });
    }

    private MaxGlobalMessageCount getGlobalMaxMessageEntity(EntityManager entityManager, Optional<QuotaCountLimit> maxMessageQuota) {
        MaxGlobalMessageCount storedValue = (MaxGlobalMessageCount)entityManager.find(MaxGlobalMessageCount.class, (Object)"default_key");
        Long value = this.quotaValueToLong(maxMessageQuota);
        if (storedValue == null) {
            return new MaxGlobalMessageCount(value);
        }
        storedValue.setValue(value);
        return storedValue;
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage(EntityManager entityManager) {
        MaxGlobalStorage storedValue = (MaxGlobalStorage)entityManager.find(MaxGlobalStorage.class, (Object)"default_key");
        if (storedValue == null) {
            return Optional.empty();
        }
        return this.longToQuotaSize(storedValue.getValue());
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage(EntityManager entityManager) {
        MaxGlobalMessageCount storedValue = (MaxGlobalMessageCount)entityManager.find(MaxGlobalMessageCount.class, (Object)"default_key");
        if (storedValue == null) {
            return Optional.empty();
        }
        return this.longToQuotaCount(storedValue.getValue());
    }

    public Optional<QuotaSizeLimit> getMaxStorage(EntityManager entityManager, QuotaRoot quotaRoot) {
        MaxUserStorage storedValue = (MaxUserStorage)entityManager.find(MaxUserStorage.class, (Object)quotaRoot.getValue());
        if (storedValue == null) {
            return Optional.empty();
        }
        return this.longToQuotaSize(storedValue.getValue());
    }

    public Optional<QuotaCountLimit> getMaxMessage(EntityManager entityManager, QuotaRoot quotaRoot) {
        MaxUserMessageCount storedValue = (MaxUserMessageCount)entityManager.find(MaxUserMessageCount.class, (Object)quotaRoot.getValue());
        if (storedValue == null) {
            return Optional.empty();
        }
        return this.longToQuotaCount(storedValue.getValue());
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(EntityManager entityManager, Domain domain) {
        MaxDomainMessageCount storedValue = (MaxDomainMessageCount)entityManager.find(MaxDomainMessageCount.class, (Object)domain.asString());
        if (storedValue == null) {
            return Optional.empty();
        }
        return this.longToQuotaCount(storedValue.getValue());
    }

    public Optional<QuotaSizeLimit> getDomainMaxStorage(EntityManager entityManager, Domain domain) {
        MaxDomainStorage storedValue = (MaxDomainStorage)entityManager.find(MaxDomainStorage.class, (Object)domain.asString());
        if (storedValue == null) {
            return Optional.empty();
        }
        return this.longToQuotaSize(storedValue.getValue());
    }

    private Long quotaValueToLong(Optional<? extends QuotaLimitValue<?>> maxStorageQuota) {
        return maxStorageQuota.map(value -> {
            if (value.isUnlimited()) {
                return -1L;
            }
            return value.asLong();
        }).orElse(null);
    }

    private Optional<QuotaSizeLimit> longToQuotaSize(Long value) {
        return this.longToQuotaValue(value, QuotaSizeLimit.unlimited(), QuotaSizeLimit::size);
    }

    private Optional<QuotaCountLimit> longToQuotaCount(Long value) {
        return this.longToQuotaValue(value, QuotaCountLimit.unlimited(), QuotaCountLimit::count);
    }

    private <T extends QuotaLimitValue<T>> Optional<T> longToQuotaValue(Long value, T infiniteValue, Function<Long, T> quotaFactory) {
        if (value == null) {
            return Optional.empty();
        }
        if (value == -1L) {
            return Optional.of(infiniteValue);
        }
        return Optional.of((QuotaLimitValue)quotaFactory.apply(value));
    }
}

