/*
 * Decompiled with CFR 0.152.
 */
package org.mpierce.metrics.reservoir.hdrhistogram;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.mpierce.metrics.reservoir.hdrhistogram.HistogramSnapshot;

@ThreadSafe
public final class HdrHistogramReservoir
implements Reservoir {
    private final Recorder recorder;
    @GuardedBy(value="this")
    private final Histogram runningTotals;
    @Nonnull
    @GuardedBy(value="this")
    private Histogram intervalHistogram;

    public HdrHistogramReservoir() {
        this(new Recorder(2));
    }

    public HdrHistogramReservoir(Recorder recorder) {
        this.recorder = recorder;
        this.intervalHistogram = recorder.getIntervalHistogram();
        this.runningTotals = new Histogram(this.intervalHistogram.getNumberOfSignificantValueDigits());
    }

    public int size() {
        return this.getSnapshot().size();
    }

    public void update(long value) {
        this.recorder.recordValue(value);
    }

    public Snapshot getSnapshot() {
        return new HistogramSnapshot(this.updateRunningTotals());
    }

    @Nonnull
    private synchronized Histogram updateRunningTotals() {
        this.intervalHistogram = this.recorder.getIntervalHistogram(this.intervalHistogram);
        this.runningTotals.add((AbstractHistogram)this.intervalHistogram);
        return this.runningTotals.copy();
    }
}

