/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AssertionRequestControl
extends Control {
    @NotNull
    public static final String ASSERTION_REQUEST_OID = "1.3.6.1.1.12";
    @NotNull
    private static final String JSON_FIELD_FILTER = "filter";
    private static final long serialVersionUID = 6592634203410511095L;
    @NotNull
    private final Filter filter;

    public AssertionRequestControl(@NotNull String filter) throws LDAPException {
        this(Filter.create(filter), true);
    }

    public AssertionRequestControl(@NotNull Filter filter) {
        this(filter, true);
    }

    public AssertionRequestControl(@NotNull String filter, boolean isCritical) throws LDAPException {
        this(Filter.create(filter), isCritical);
    }

    public AssertionRequestControl(@NotNull Filter filter, boolean isCritical) {
        super(ASSERTION_REQUEST_OID, isCritical, AssertionRequestControl.encodeValue(filter));
        this.filter = filter;
    }

    public AssertionRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSERT_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            this.filter = Filter.decode(valueElement);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSERT_CANNOT_DECODE.get(e), e);
        }
    }

    @NotNull
    public static AssertionRequestControl generate(@NotNull Entry sourceEntry, String ... attributes) {
        ArrayList<Filter> andComponents;
        Validator.ensureNotNull(sourceEntry);
        if (attributes == null || attributes.length == 0) {
            Collection<Attribute> entryAttrs = sourceEntry.getAttributes();
            andComponents = new ArrayList(entryAttrs.size());
            for (Attribute a : entryAttrs) {
                for (ASN1OctetString v : a.getRawValues()) {
                    andComponents.add(Filter.createEqualityFilter(a.getName(), v.getValue()));
                }
            }
        } else {
            andComponents = new ArrayList<Filter>(attributes.length);
            for (String name : attributes) {
                Attribute a = sourceEntry.getAttribute(name);
                if (a == null) continue;
                for (ASN1OctetString v : a.getRawValues()) {
                    andComponents.add(Filter.createEqualityFilter(name, v.getValue()));
                }
            }
        }
        if (andComponents.size() == 1) {
            return new AssertionRequestControl(andComponents.get(0));
        }
        return new AssertionRequestControl(Filter.createANDFilter(andComponents));
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull Filter filter) {
        return new ASN1OctetString(filter.encode().encode());
    }

    @NotNull
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ASSERTION_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", ASSERTION_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_ASSERTION_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_FILTER, this.filter.toString()))));
    }

    @NotNull
    public static AssertionRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        Filter parsedFilter;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new AssertionRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String filterString = valueObject.getFieldAsString(JSON_FIELD_FILTER);
        if (filterString == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSERT_JSON_CONTROL_MISSING_FILTER.get(controlObject.toSingleLineString(), JSON_FIELD_FILTER));
        }
        try {
            parsedFilter = Filter.create(filterString);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSERT_JSON_CONTROL_INVALID_FILTER.get(controlObject.toSingleLineString(), filterString), e);
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_FILTER)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSERT_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new AssertionRequestControl(parsedFilter, jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AssertionRequestControl(filter='");
        this.filter.toString(buffer);
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

