/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.KeyedProcessor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IngestTotal
implements JsonpSerializable {
    private final long count;
    private final long current;
    private final long failed;
    private final List<KeyedProcessor> processors;
    private final long timeInMillis;
    public static final JsonpDeserializer<IngestTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestTotal::setupIngestTotalDeserializer);

    private IngestTotal(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.current = ApiTypeHelper.requireNonNull(builder.current, this, "current");
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
        this.processors = ApiTypeHelper.unmodifiableRequired(builder.processors, (Object)this, "processors");
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis");
    }

    public static IngestTotal of(Function<Builder, ObjectBuilder<IngestTotal>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final long current() {
        return this.current;
    }

    public final long failed() {
        return this.failed;
    }

    public final List<KeyedProcessor> processors() {
        return this.processors;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("failed");
        generator.write(this.failed);
        if (ApiTypeHelper.isDefined(this.processors)) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (KeyedProcessor item0 : this.processors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
    }

    protected static void setupIngestTotalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed");
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(KeyedProcessor._DESERIALIZER), "processors");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IngestTotal> {
        private Long count;
        private Long current;
        private Long failed;
        private List<KeyedProcessor> processors;
        private Long timeInMillis;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        public final Builder failed(long value) {
            this.failed = value;
            return this;
        }

        public final Builder processors(List<KeyedProcessor> list) {
            this.processors = Builder._listAddAll(this.processors, list);
            return this;
        }

        public final Builder processors(KeyedProcessor value, KeyedProcessor ... values) {
            this.processors = Builder._listAdd(this.processors, value, values);
            return this;
        }

        public final Builder processors(Function<KeyedProcessor.Builder, ObjectBuilder<KeyedProcessor>> fn) {
            return this.processors(fn.apply(new KeyedProcessor.Builder()).build(), new KeyedProcessor[0]);
        }

        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        public IngestTotal build() {
            this._checkSingleUse();
            return new IngestTotal(this);
        }
    }
}

