/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Objects;
import org.apache.james.utils.FullyQualifiedClassName;
import org.apache.james.utils.PackageName;

public class ClassName {
    private final String name;

    public ClassName(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"A class name can not be empty");
        Preconditions.checkArgument((!name.startsWith(String.valueOf('.')) ? 1 : 0) != 0, (Object)"A class name can not start with '.'");
        Preconditions.checkArgument((!name.endsWith(String.valueOf('.')) ? 1 : 0) != 0, (Object)"A class name can not end with '.'");
        Splitter.on((char)'.').split((CharSequence)name).forEach(part -> Preconditions.checkArgument((!part.isEmpty() ? 1 : 0) != 0, (Object)"Package part can not be empty within a class name"));
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    FullyQualifiedClassName appendPackage(PackageName aPackage) {
        return new FullyQualifiedClassName(aPackage.getName() + "." + this.name);
    }

    FullyQualifiedClassName asFullyQualified() {
        return new FullyQualifiedClassName(this.name);
    }

    public final boolean equals(Object o) {
        if (o instanceof ClassName) {
            ClassName className = (ClassName)o;
            return Objects.equals(this.name, className.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

