/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mdn.fields.AddressType;
import org.apache.james.mdn.fields.Field;
import org.apache.james.mdn.fields.Text;

public class Gateway
implements Field {
    public static final String FIELD_NAME = "MDN-Gateway";
    private final AddressType nameType;
    private final Text name;

    public static Builder builder() {
        return new Builder();
    }

    private Gateway(AddressType nameType, Text name) {
        this.nameType = nameType;
        this.name = name;
    }

    @Override
    public String formattedValue() {
        return "MDN-Gateway: " + this.fieldValue();
    }

    public String fieldValue() {
        return Joiner.on(";").skipNulls().join(this.nameType.getType(), this.name.formatted(), new Object[0]);
    }

    public AddressType getNameType() {
        return this.nameType;
    }

    public Text getName() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (o instanceof Gateway) {
            Gateway gateway = (Gateway)o;
            return Objects.equals(this.nameType, gateway.nameType) && Objects.equals(this.name, gateway.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.nameType, this.name);
    }

    public String toString() {
        return this.formattedValue();
    }

    public static class Builder {
        private Optional<AddressType> nameType = Optional.empty();
        private Text name;

        private Builder() {
        }

        public Builder nameType(AddressType nameType) {
            this.nameType = Optional.of(nameType);
            return this;
        }

        public Builder name(Text name) {
            this.name = name;
            return this;
        }

        public Gateway build() {
            Preconditions.checkNotNull(this.name);
            return new Gateway(this.nameType.orElse(AddressType.DNS), this.name);
        }
    }
}

