/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.util.Objects;
import reactor.netty.http.HttpDecoderSpec;

public final class HttpResponseDecoderSpec
extends HttpDecoderSpec<HttpResponseDecoderSpec> {
    public static final boolean DEFAULT_FAIL_ON_MISSING_RESPONSE = false;
    public static final boolean DEFAULT_PARSE_HTTP_AFTER_CONNECT_REQUEST = false;
    public static final int DEFAULT_H2C_MAX_CONTENT_LENGTH = 65536;
    boolean failOnMissingResponse = false;
    boolean parseHttpAfterConnectRequest = false;

    HttpResponseDecoderSpec() {
        this.h2cMaxContentLength = 65536;
    }

    @Override
    public HttpResponseDecoderSpec get() {
        return this;
    }

    public HttpResponseDecoderSpec failOnMissingResponse(boolean failOnMissingResponse) {
        this.failOnMissingResponse = failOnMissingResponse;
        return this;
    }

    public HttpResponseDecoderSpec parseHttpAfterConnectRequest(boolean parseHttpAfterConnectRequest) {
        this.parseHttpAfterConnectRequest = parseHttpAfterConnectRequest;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpResponseDecoderSpec that = (HttpResponseDecoderSpec)o;
        return this.failOnMissingResponse == that.failOnMissingResponse && this.parseHttpAfterConnectRequest == that.parseHttpAfterConnectRequest;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.failOnMissingResponse, this.parseHttpAfterConnectRequest);
    }

    HttpResponseDecoderSpec build() {
        HttpResponseDecoderSpec decoder = new HttpResponseDecoderSpec();
        decoder.initialBufferSize = this.initialBufferSize;
        decoder.maxChunkSize = this.maxChunkSize;
        decoder.maxHeaderSize = this.maxHeaderSize;
        decoder.maxInitialLineLength = this.maxInitialLineLength;
        decoder.validateHeaders = this.validateHeaders;
        decoder.allowDuplicateContentLengths = this.allowDuplicateContentLengths;
        decoder.failOnMissingResponse = this.failOnMissingResponse;
        decoder.parseHttpAfterConnectRequest = this.parseHttpAfterConnectRequest;
        decoder.h2cMaxContentLength = this.h2cMaxContentLength;
        return decoder;
    }
}

