/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.io.File;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class UnloadFileOperator
extends Operator {
    private File file;
    private File targetDir;

    public UnloadFileOperator(File file, File targetDir) {
        super(71);
        this.file = file;
        this.targetDir = targetDir;
        this.operatorType = Operator.OperatorType.UNLOAD_FILE;
    }

    public File getFile() {
        return this.file;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return new OperateFilePlan(this.file, this.targetDir, Operator.OperatorType.UNLOAD_FILE);
    }
}

