/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.doublelive.OperationSyncDDLProtector;
import org.apache.iotdb.db.doublelive.OperationSyncProtector;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.session.pool.SessionPool;

public class OperationSyncDMLProtector
extends OperationSyncProtector {
    private final OperationSyncDDLProtector ddlProtector;
    private final SessionPool operationSyncSessionPool;

    public OperationSyncDMLProtector(OperationSyncDDLProtector ddlProtector, SessionPool operationSyncSessionPool) {
        this.ddlProtector = ddlProtector;
        this.operationSyncSessionPool = operationSyncSessionPool;
    }

    @Override
    protected void preCheck() {
        while (this.ddlProtector.isAtWork()) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void transmitPhysicalPlan(ByteBuffer planBuffer, PhysicalPlan physicalPlan) {
        long sleepTimeInSeconds = 1L;
        while (true) {
            boolean transmitStatus;
            block13: {
                transmitStatus = false;
                if (StorageEngine.isSecondaryAlive().get()) {
                    try {
                        planBuffer.position(0);
                        transmitStatus = this.operationSyncSessionPool.operationSyncTransmit(planBuffer);
                        break block13;
                    }
                    catch (IoTDBConnectionException connectionException) {
                        LOGGER.warn("OperationSyncDMLProtector can't transmit for connection error, retrying...", (Throwable)connectionException);
                        break block13;
                    }
                    catch (BatchExecutionException batchExecutionException) {
                        if (batchExecutionException.getStatusList().stream().anyMatch(s -> s.getCode() == TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode())) {
                            sleepTimeInSeconds = 10L;
                            LOGGER.warn("OperationSyncDMLProtector can't transmit for STORAGE_GROUP_NOT_READY", (Throwable)batchExecutionException);
                            break block13;
                        }
                        LOGGER.warn("OperationSyncDMLProtector can't transmit for batchExecutionException, discard it", (Throwable)batchExecutionException);
                        break;
                    }
                    catch (StatementExecutionException statementExecutionException) {
                        if (statementExecutionException.getStatusCode() == TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode()) {
                            LOGGER.warn("OperationSyncDMLProtector can't transmit for STORAGE_GROUP_NOT_READY", (Throwable)statementExecutionException);
                            sleepTimeInSeconds = 10L;
                            break block13;
                        }
                        LOGGER.warn("OperationSyncDMLProtector can't transmit for statementExecutionException, discard it", (Throwable)statementExecutionException);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("OperationSyncDMLProtector can't transmit, discard it", (Throwable)e);
                        break;
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (transmitStatus) break;
            try {
                TimeUnit.SECONDS.sleep(sleepTimeInSeconds);
            }
            catch (InterruptedException e) {
                LOGGER.warn("OperationSyncDMLProtector is interrupted", (Throwable)e);
            }
        }
    }
}

