/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.virtualSg;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.VirtualPartitioner;
import org.apache.iotdb.db.metadata.path.PartialPath;

public class HashVirtualPartitioner
implements VirtualPartitioner {
    private static int STORAGE_GROUP_NUM = IoTDBDescriptor.getInstance().getConfig().getVirtualStorageGroupNum();

    private HashVirtualPartitioner() {
    }

    public static HashVirtualPartitioner getInstance() {
        return HashVirtualPartitionerHolder.INSTANCE;
    }

    @Override
    public int deviceToVirtualStorageGroupId(PartialPath deviceId) {
        return this.toStorageGroupId(deviceId);
    }

    @Override
    public int getPartitionCount() {
        return STORAGE_GROUP_NUM;
    }

    private int toStorageGroupId(PartialPath deviceId) {
        return Math.abs(deviceId.hashCode() % STORAGE_GROUP_NUM);
    }

    public void reset() {
        STORAGE_GROUP_NUM = IoTDBDescriptor.getInstance().getConfig().getVirtualStorageGroupNum();
    }

    private static class HashVirtualPartitionerHolder {
        private static final HashVirtualPartitioner INSTANCE = new HashVirtualPartitioner();

        private HashVirtualPartitionerHolder() {
        }
    }
}

