/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompactionTask
implements Callable<CompactionTaskSummary> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected String fullStorageGroupName;
    protected long timePartition;
    protected final AtomicInteger currentTaskNum;
    protected final TsFileManager tsFileManager;
    protected long timeCost = 0L;

    public AbstractCompactionTask(String fullStorageGroupName, long timePartition, TsFileManager tsFileManager, AtomicInteger currentTaskNum) {
        this.fullStorageGroupName = fullStorageGroupName;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.currentTaskNum = currentTaskNum;
    }

    public abstract void setSourceFilesToCompactionCandidate();

    protected abstract void doCompaction() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionTaskSummary call() throws Exception {
        long startTime = System.currentTimeMillis();
        this.currentTaskNum.incrementAndGet();
        boolean isSuccess = false;
        try {
            this.doCompaction();
            isSuccess = true;
        }
        catch (Exception e) {
            LOGGER.error("Running compaction task failed", (Throwable)e);
        }
        finally {
            CompactionTaskManager.getInstance().removeRunningTaskFromList(this);
            this.timeCost = System.currentTimeMillis() - startTime;
            this.currentTaskNum.decrementAndGet();
        }
        return new CompactionTaskSummary(isSuccess);
    }

    public String getFullStorageGroupName() {
        return this.fullStorageGroupName;
    }

    public long getTimePartition() {
        return this.timePartition;
    }

    public abstract boolean equalsOtherTask(AbstractCompactionTask var1);

    public abstract boolean checkValidAndSetMerging();

    public boolean equals(Object other) {
        if (other instanceof AbstractCompactionTask) {
            return this.equalsOtherTask((AbstractCompactionTask)other);
        }
        return false;
    }

    public abstract void resetCompactionCandidateStatusForAllSourceFiles();

    public long getTimeCost() {
        return this.timeCost;
    }
}

