/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.logit.util.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;

public abstract class ShutdownAbleThread
implements Runnable {
    private static final IgniteLogger LOG = Loggers.forClass(ShutdownAbleThread.class);
    private static final long JOIN_TIME = 90000L;
    private Thread thread;
    protected volatile boolean stopped = false;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public abstract void onShutdown();

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
        LOG.info("Try to start service thread:{} started:{} lastThread:{}", this.getServiceName(), this.started.get(), this.thread);
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.stopped = false;
        this.thread = new Thread((Runnable)this, this.getServiceName());
        this.thread.start();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean interrupt) {
        LOG.info("Try to shutdown service thread:{} started:{} lastThread:{}", this.getServiceName(), this.started.get(), this.thread);
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.stopped = true;
        try {
            if (interrupt) {
                this.thread.interrupt();
            }
            this.thread.join(90000L);
        }
        catch (InterruptedException e) {
            LOG.error("Error when shutdown thread, serviceName:{}", this.getServiceName(), e);
        }
    }

    protected void waitForRunning(long interval) throws InterruptedException {
        Thread.sleep(interval);
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

