/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.Set;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessageBuilder;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;

class EnlistedPartitionGroupMessageDeserializer
implements MessageDeserializer<EnlistedPartitionGroupMessage> {
    private final EnlistedPartitionGroupMessageBuilder msg;

    EnlistedPartitionGroupMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.enlistedPartitionGroupMessage();
    }

    @Override
    public Class<EnlistedPartitionGroupMessage> klass() {
        return EnlistedPartitionGroupMessage.class;
    }

    @Override
    public EnlistedPartitionGroupMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId(tmp);
                reader.incrementState();
            }
            case 1: {
                ReplicationGroupIdMessage tmp = reader.readSet("tableIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableIds((Set<Integer>)((Object)tmp));
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(EnlistedPartitionGroupMessage.class);
    }
}

